package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 付款预警信息实体
 * 
 * @author generator
 * 
 */
public class PmEarlyWarningVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String projectName; // 项目名称
    private String billCode; // 单据编号
    private Long isAlert; // 是否预警 1 是  2 否
    private String alertReason; // 预警原因
    private String contractStageName; // 付款阶段
    private String businessType; // 业务类型
    /**
     * 申请付款日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime; // 申请付款日期
    private Long receiveUnitId; // 收款单位主键
    private String receiveUnitName; // 收款单位
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long projectId; // 项目
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间
    private String memo; // 备注
    private Integer payType; // 付款类型：1-组织付款 2-项目付款
    private Long contractId; // 合同主键
    private Long contractType; // 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String payReason; // 付款事由
    private Long applyUserId; // 申请人
    private String applyUserName; // 申请人名称
    private Long applyOrgId; // 申请付款组织id
    private String applyOrgName; // 申请付款组织名称
    private Long actualOrgId; // 实际付款组织id
    private String actualOrgName; // 实际付款组织名称
    private String sourceId; // 记录来源单据主键
    private BigDecimal applyMny;//申请金额
    private BigDecimal payScale;//合同支付比例
    

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getIsAalert() {
        return isAlert;
    }

    public void setIsAlert(Long isAlert) {
        this.isAlert = isAlert;
    }
    public String getAlertReason() {
        return alertReason;
    }

    public void setAlertReason(String alertReason) {
        this.alertReason = alertReason;
    }
    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }
    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
   
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }
    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public Long getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }
    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    public Long getActualOrgId() {
        return actualOrgId;
    }

    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }
    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }
    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

	public BigDecimal getApplyMny() {
		return applyMny;
	}

	public void setApplyMny(BigDecimal applyMny) {
		this.applyMny = applyMny;
	}

	public BigDecimal getPayScale() {
		return payScale;
	}

	public void setPayScale(BigDecimal payScale) {
		this.payScale = payScale;
	}

	public Long getIsAlert() {
		return isAlert;
	}
    
}
