package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 借款申请
 *
 * @author generator
 *
 */
public class LoadApplyVO extends BaseVO {
    public static final String BILL_TYPE_CODE = "BT200629000000001";
    private static final long serialVersionUID = 1L;

    private java.lang.Long projectId; // 项目
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.String billCode; // 申请编号
    private java.lang.String memo; // 申请事由
    private java.math.BigDecimal applyMny; // 申请金额
    private java.math.BigDecimal unpaidMny; // 未付金额
    private java.math.BigDecimal surplusMny; // 剩余借款
    private java.lang.Long applyEmployeeId; // 申请人
    private java.lang.String applyEmployeeName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyTime; // 申请时间
    private java.lang.String accountName; // 账户名
    private java.lang.String bankAccount; // 银行账号
    private java.lang.String bankName; // 开户行
    private java.lang.Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date useTime; // 用款时间
    private java.lang.Integer payType; // 付款类型：1-组织付款 2-项目付款
    private java.lang.Integer payStatus; // 支付状态：1-未支付 2-已支付
    private java.math.BigDecimal payMny; // 支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTime; // 支付时间
    private List<PayRecordVO> recordList = new ArrayList<>(); // 付款申请记录实体
    /**
     * 是否属于项目
     */
    private String dependOnProject;

    private String billStateName;

    private java.math.BigDecimal reimburseMny; // 报销金额

    private java.math.BigDecimal backMny; // 退还金额

    private java.math.BigDecimal sumPenaltyMoney; // 扣款单金额
    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }

    /**
     * 是否需要发票
     */
    private String invoiceFlagName;


    private String orgCode; // 组织编码

    private Map<String, Object> _payRecordId;

    /**
     * 推送凭证标识
     */
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    private String voucherInfo;
    private BigDecimal thisPayMnyRecord; // 本期支付金额（支付记录）
    private String accountNameRecord; // 账户名称（支付记录）
    private String accountNumRecord; // 银行账号（支付记录）
    private String accountBankRecord; // 开户行名（支付记录）
    private String applyUserNameRecord; // 申请人名称（支付记录）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTimeRecord; // 经办时间（支付记录）
    private String payWayNameRecord; // 付款方式名称（支付记录）
    private String memoRecord; // 备注（支付记录）

    public BigDecimal getThisPayMnyRecord() {
        return thisPayMnyRecord;
    }

    public void setThisPayMnyRecord(BigDecimal thisPayMnyRecord) {
        this.thisPayMnyRecord = thisPayMnyRecord;
    }

    public String getAccountNameRecord() {
        return accountNameRecord;
    }

    public void setAccountNameRecord(String accountNameRecord) {
        this.accountNameRecord = accountNameRecord;
    }

    public String getAccountNumRecord() {
        return accountNumRecord;
    }

    public void setAccountNumRecord(String accountNumRecord) {
        this.accountNumRecord = accountNumRecord;
    }

    public String getAccountBankRecord() {
        return accountBankRecord;
    }

    public void setAccountBankRecord(String accountBankRecord) {
        this.accountBankRecord = accountBankRecord;
    }

    public String getApplyUserNameRecord() {
        return applyUserNameRecord;
    }

    public void setApplyUserNameRecord(String applyUserNameRecord) {
        this.applyUserNameRecord = applyUserNameRecord;
    }

    public Date getConfirmTimeRecord() {
        return confirmTimeRecord;
    }

    public void setConfirmTimeRecord(Date confirmTimeRecord) {
        this.confirmTimeRecord = confirmTimeRecord;
    }

    public String getPayWayNameRecord() {
        return payWayNameRecord;
    }

    public void setPayWayNameRecord(String payWayNameRecord) {
        this.payWayNameRecord = payWayNameRecord;
    }

    public String getMemoRecord() {
        return memoRecord;
    }

    public void setMemoRecord(String memoRecord) {
        this.memoRecord = memoRecord;
    }

    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public Map<String, Object> get_payRecordId() {
        return _payRecordId;
    }

    public void set_payRecordId(Map<String, Object> _payRecordId) {
        this._payRecordId = _payRecordId;
    }


    public String getOrgCode() {
        return orgCode;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public List<PayRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<PayRecordVO> recordList) {
        this.recordList = recordList;
    }

    public String getInvoiceFlagName() {
        if (this.invoiceFlag == null) {
            return null;
        } else if ("1".equals(this.invoiceFlag)) {
            return "有";
        } else if ("2".equals(this.invoiceFlag)) {
            return "没有";
        } else if ("3".equals(this.invoiceFlag)) {
            return "不确定";
        }
        return null;
    }

    public void setInvoiceFlagName(String invoiceFlagName) {
        this.invoiceFlagName = invoiceFlagName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getSumPenaltyMoney() {
        return sumPenaltyMoney;
    }

    public void setSumPenaltyMoney(BigDecimal sumPenaltyMoney) {
        this.sumPenaltyMoney = sumPenaltyMoney;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
}
