package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.utils.ParamSearchUtil;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 前端控制器
 * </p>
 */
@Controller
@RequestMapping("/laborSalaryApply")
public class LaborSalaryApplyController {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayContractService contractService;

    @Autowired
    private IPaySporadicService paySporadicService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @param param
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", QueryParam.DESC);
        JSONObject page = contractService.queryLaborSalaryApplyPageJson(param, false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List<Long> ids = vos.stream().map(PayContractVO::getId).collect(Collectors.toList());
        List<Long> payContractIds = vos.stream().filter(vo -> "1".equals(vo.getContractFlag())).map(PayContractVO::getId).collect(Collectors.toList());
        List<Long> paySporadicIds = vos.stream().filter(vo -> "0".equals(vo.getContractFlag())).map(PayContractVO::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(payContractIds)){
            String msg = contractService.delete(payContractIds);
        }
        if(CollectionUtils.isNotEmpty(paySporadicIds)){
            paySporadicService.delete(paySporadicIds);
        }
        return CommonResponse.success("删除成功！");
    }
    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        List<PayContractVO> supplierVos = contractService.queryLaborSalaryApplyExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-laborSalaryApply-export.xlsx", beans, response);
    }

    @PostMapping("/checkParams")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PayContractVO vo){
        ParamsCheckVO paramsCheckVO = contractService.checkParamsToLabor(vo);
        return CommonResponse.success("参数校验成功！", paramsCheckVO);
    }

}
