package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;

@RestController
@RequestMapping("/api/budgetControl/")
public class BudgetControlApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayReimburseService payReimburseService;//费用报销
    @Autowired
    private IPaySporadicService paySporadicService; //零星付款申请
    @Autowired
    private ILoadReimburseService loadReimburseService;//备用金
    /**
     * 根据项目id统计费用报销、备用金报销、零星付款申请
     */
    @GetMapping(value = "budgetControlTotal")
    public CommonResponse<BigDecimal> budgetControlTotal(Long projectId) {
        BigDecimal applyMny = BigDecimal.ZERO;
        PayReimburseVO payReimburse = new PayReimburseVO();
        payReimburse.setProjectId(projectId);
        applyMny = applyMny.add(payReimburseService.totalBudgetMny(payReimburse));
        LoadReimburseVO loadReimburse = new LoadReimburseVO();
        loadReimburse.setProjectId(projectId);
        applyMny = applyMny.add(loadReimburseService.totalBudgetMny(loadReimburse));
        PaySporadicVO paySporadic = new PaySporadicVO();
        paySporadic.setProjectId(projectId);
        applyMny = applyMny.add(paySporadicService.totalBudgetMny(paySporadic));
        return CommonResponse.success(applyMny);
    }
}
