/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayRecordSettleEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.mapper.PayRecordMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayRecordSalaryGrantService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayRecordSettleService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.PayRecordMessageService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payRecordService")
public class PayRecordServiceImpl
extends BaseServiceImpl<PayRecordMapper, PayRecordEntity>
implements IPayRecordService {
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IPayContractSettleService contracctSettleService;
    @Autowired
    private IPayRecordSettleService settleService;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IPayRecordSalaryGrantService payRecordSalaryGrantService;
    @Autowired
    private PayRecordMessageService payRecordMessageService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IBankFlowService bankFlowService;

    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo, boolean isBatchPay) {
        PaySporadicEntity sporadic;
        QueryParam queryParam;
        PayContractEntity contract;
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        BankFlowVO bankFlowVO = null;
        BigDecimal msgPayMny = BigDecimal.ZERO;
        if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
            contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u652f\u51fa\u5408\u540c\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setTradeAccountName(contract.getAccountName());
            bankFlowVO.setTradeAccountNum(contract.getAccountNum());
            bankFlowVO.setTradeAccountBank(contract.getAccountBank());
            entity.setBillCode(contract.getBillCode());
            entity.setContractId(contract.getContractId());
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());
            entity.setContractTypeExtend(contract.getContractTypeExtend());
            entity.setProjectId(contract.getProjectId());
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());
            entity.setApplyMny(contract.getApplyMny());
            entity.setReceiveUnitId(contract.getReceiveUnitId());
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            entity.setExplanation(contract.getPayReason());
            super.saveOrUpdate((Object)entity);
            contract.setPayStatus(2);
            contract.setConfirmTime(entity.getConfirmTime());
            contract.setEmployeeId(entity.getEmployeeId());
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd((BigDecimal)contract.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = contract.getPayMny();
            queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper wrapper = PayRecordServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)this.payRecordService.getOne((Wrapper)wrapper));
            if (payRecordEntity != null) {
                contract.setPayAccountName(payRecordEntity.getAccountName());
                contract.setPayAccountNum(payRecordEntity.getAccountNum());
                contract.setPayAccountBank(payRecordEntity.getAccountBank());
            }
            this.contractService.saveOrUpdate((Object)contract);
            List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);
            this.writeBackSumPayMny(entity.getPayapplyId(), entity, settleList, true);
        } else if ("\u5de5\u4eba\u5de5\u8d44-\u6709\u5408\u540c".equals(vo.getApplyType())) {
            contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u652f\u51fa\u5408\u540c\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setTradeAccountName(contract.getAccountName());
            bankFlowVO.setTradeAccountNum(contract.getAccountNum());
            bankFlowVO.setTradeAccountBank(contract.getAccountBank());
            entity.setBillCode(contract.getBillCode());
            entity.setContractId(contract.getContractId());
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());
            entity.setContractTypeExtend(contract.getContractTypeExtend());
            entity.setProjectId(contract.getProjectId());
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());
            entity.setApplyMny(contract.getApplyMny());
            entity.setReceiveUnitId(contract.getReceiveUnitId());
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            contract.setPayStatus(2);
            contract.setConfirmTime(entity.getConfirmTime());
            contract.setEmployeeId(entity.getEmployeeId());
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd((BigDecimal)contract.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper wrapper = PayRecordServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)this.payRecordService.getOne((Wrapper)wrapper));
            if (payRecordEntity != null) {
                contract.setPayAccountName(payRecordEntity.getAccountName());
                contract.setPayAccountNum(payRecordEntity.getAccountNum());
                contract.setPayAccountBank(payRecordEntity.getAccountBank());
            }
            this.contractService.saveOrUpdate((Object)contract);
            this.payRecordSalaryGrantService.payForGrant(entity, true, isBatchPay);
        } else if ("\u5de5\u4eba\u5de5\u8d44-\u65e0\u5408\u540c".equals(vo.getApplyType())) {
            sporadic = (PaySporadicEntity)((Object)this.sporadicService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u96f6\u661f\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(sporadic.getApplyUserId());
            bankFlowVO.setTradeOrgName(sporadic.getApplyUserName());
            bankFlowVO.setTradeAccountName(sporadic.getAccountName());
            bankFlowVO.setTradeAccountNum(sporadic.getAccountNum());
            bankFlowVO.setTradeAccountBank(sporadic.getAccountBank());
            entity.setBillCode(sporadic.getBillCode());
            entity.setProjectId(sporadic.getProjectId());
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());
            entity.setApplyMny(sporadic.getApplyMny());
            sporadic.setPayStatus(2);
            sporadic.setConfirmTime(entity.getConfirmTime());
            sporadic.setEmployeeId(entity.getEmployeeId());
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd((BigDecimal)sporadic.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper wrapper = PayRecordServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)this.payRecordService.getOne((Wrapper)wrapper));
            if (payRecordEntity != null) {
                sporadic.setPayAccountName(payRecordEntity.getAccountName());
                sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
                sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
            }
            this.sporadicService.saveOrUpdate((Object)sporadic);
            this.payRecordSalaryGrantService.payForGrantNoCantract(entity, false, isBatchPay);
            this.sporadicService.costPush(sporadic);
        } else if ("\u96f6\u661f\u91c7\u8d2d".equals(vo.getApplyType())) {
            sporadic = (PaySporadicEntity)((Object)this.sporadicService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u96f6\u661f\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(sporadic.getSupplierId());
            bankFlowVO.setTradeOrgName(sporadic.getSupplierName());
            bankFlowVO.setTradeAccountName(sporadic.getAccountName());
            bankFlowVO.setTradeAccountNum(sporadic.getAccountNum());
            bankFlowVO.setTradeAccountBank(sporadic.getAccountBank());
            entity.setBillCode(sporadic.getBillCode());
            entity.setProjectId(sporadic.getProjectId());
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());
            entity.setApplyMny(sporadic.getApplyMny());
            entity.setExplanation(sporadic.getPayReason());
            this.saveOrUpdateNoES((Object)entity);
            sporadic.setPayStatus(2);
            sporadic.setConfirmTime(entity.getConfirmTime());
            sporadic.setEmployeeId(entity.getEmployeeId());
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd((BigDecimal)sporadic.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = sporadic.getPayMny();
            queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper wrapper = PayRecordServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)this.payRecordService.getOne((Wrapper)wrapper));
            if (payRecordEntity != null) {
                sporadic.setPayAccountName(payRecordEntity.getAccountName());
                sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
                sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
            }
            this.sporadicService.saveOrUpdate((Object)sporadic);
            this.sporadicService.costPush(sporadic);
        } else if ("\u62a5\u9500".equals(vo.getApplyType())) {
            PayReimburseEntity reimburse = (PayReimburseEntity)((Object)this.reimburseService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u8d39\u7528\u62a5\u9500);
            bankFlowVO.setTradeOrgId(reimburse.getApplyUserId());
            bankFlowVO.setTradeOrgName(reimburse.getApplyUserName());
            bankFlowVO.setTradeAccountName(reimburse.getAccountName());
            bankFlowVO.setTradeAccountNum(reimburse.getAccountNum());
            bankFlowVO.setTradeAccountBank(reimburse.getAccountBank());
            entity.setBillCode(reimburse.getBillCode());
            entity.setProjectId(reimburse.getProjectId());
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());
            entity.setApplyMny(reimburse.getApplyMny());
            entity.setFeeType(reimburse.getFeeType());
            entity.setExplanation(reimburse.getPayReason());
            super.saveOrUpdate((Object)entity);
            reimburse.setPayStatus(2);
            reimburse.setConfirmTime(entity.getConfirmTime());
            reimburse.setEmployeeId(entity.getEmployeeId());
            reimburse.setEmployeeName(entity.getEmployeeName());
            reimburse.setPayMny(MathUtil.safeAdd((BigDecimal)reimburse.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = reimburse.getPayMny();
            this.reimburseService.saveOrUpdate((Object)reimburse);
            this.reimburseService.costPush(reimburse);
        } else if ("\u62bc\u91d1".equals(vo.getApplyType())) {
            PayForegiftEntity foregift = (PayForegiftEntity)((Object)this.foregiftService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u62bc\u91d1\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(foregift.getApplyUserId());
            bankFlowVO.setTradeOrgName(foregift.getApplyUserName());
            bankFlowVO.setTradeAccountName(foregift.getAccountName());
            bankFlowVO.setTradeAccountNum(foregift.getAccountNum());
            bankFlowVO.setTradeAccountBank(foregift.getAccountBank());
            entity.setBillCode(foregift.getBillCode());
            entity.setContractId(foregift.getContractId());
            entity.setContractName(foregift.getContractName());
            entity.setContractType(foregift.getContractType());
            entity.setContractTypeExtend(foregift.getContractTypeExtend());
            entity.setProjectId(foregift.getProjectId());
            entity.setProjectName(foregift.getProjectName());
            entity.setOrgId(foregift.getOrgId());
            entity.setOrgName(foregift.getOrgName());
            entity.setApplyUserId(foregift.getApplyUserId());
            entity.setApplyUserName(foregift.getApplyUserName());
            entity.setApplyTime(foregift.getApplyTime());
            entity.setApplyMny(foregift.getApplyMny());
            entity.setReceiveUnitId(foregift.getReceiveUnitId());
            entity.setReceiveUnitName(foregift.getReceiveUnitName());
            super.saveOrUpdate((Object)entity);
            foregift.setPayStatus(2);
            foregift.setConfirmTime(entity.getConfirmTime());
            foregift.setEmployeeId(entity.getEmployeeId());
            foregift.setEmployeeName(entity.getEmployeeName());
            foregift.setPayMny(MathUtil.safeAdd((BigDecimal)foregift.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = foregift.getPayMny();
            this.foregiftService.saveOrUpdate((Object)foregift);
        } else if ("\u5907\u7528\u91d1".equals(vo.getApplyType())) {
            LoadApplyEntity loadApplyEntity = (LoadApplyEntity)((Object)this.loadApplyService.selectById(entity.getPayapplyId()));
            bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u5907\u7528\u91d1\u4ed8\u6b3e);
            bankFlowVO.setTradeOrgId(loadApplyEntity.getApplyEmployeeId());
            bankFlowVO.setTradeOrgName(loadApplyEntity.getApplyEmployeeName());
            bankFlowVO.setTradeAccountName(loadApplyEntity.getAccountName());
            bankFlowVO.setTradeAccountNum(loadApplyEntity.getBankAccount());
            bankFlowVO.setTradeAccountBank(loadApplyEntity.getBankName());
            entity.setBillCode(loadApplyEntity.getBillCode());
            entity.setProjectId(loadApplyEntity.getProjectId());
            entity.setProjectName(loadApplyEntity.getProjectName());
            entity.setOrgId(loadApplyEntity.getOrgId());
            entity.setOrgName(loadApplyEntity.getOrgName());
            entity.setApplyUserId(loadApplyEntity.getApplyEmployeeId());
            entity.setApplyUserName(loadApplyEntity.getApplyEmployeeName());
            entity.setApplyTime(loadApplyEntity.getApplyTime());
            entity.setApplyMny(loadApplyEntity.getApplyMny());
            super.saveOrUpdate((Object)entity);
            loadApplyEntity.setPayStatus(2);
            loadApplyEntity.setConfirmTime(entity.getConfirmTime());
            loadApplyEntity.setEmployeeId(entity.getEmployeeId());
            loadApplyEntity.setEmployeeName(entity.getEmployeeName());
            loadApplyEntity.setPayMny(MathUtil.safeAdd((BigDecimal)loadApplyEntity.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = loadApplyEntity.getPayMny();
            this.loadApplyService.saveOrUpdate((Object)loadApplyEntity);
        }
        bankFlowVO.setOrgId(entity.getOrgId());
        bankFlowVO.setOrgName(entity.getOrgName());
        bankFlowVO.setSourceId(entity.getId());
        bankFlowVO.setBillId(entity.getPayapplyId());
        bankFlowVO.setBillCode(entity.getBillCode());
        bankFlowVO.setBillDate(entity.getConfirmTime());
        bankFlowVO.setAccountId(entity.getAccountId());
        bankFlowVO.setAccountName(entity.getAccountName());
        bankFlowVO.setAccountNum(entity.getAccountNum());
        bankFlowVO.setAccountBank(entity.getAccountBank());
        bankFlowVO.setPayMoney(entity.getThisPayMny());
        bankFlowVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(bankFlowVO);
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        this.payRecordMessageService.sendMsg(payRecordVO, receivers, NoticeEnum.PAY_SUCCESS);
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();
        List contractSettleList = this.contracctSettleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)entity.getPayapplyId()));
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            BigDecimal surplusPayMny = MathUtil.safeSub((BigDecimal)contractSettle.getBodyApplyMny(), (BigDecimal)contractSettle.getSumPayMny());
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)BigDecimal.ZERO) <= 0 || MathUtil.safeCompareTo((BigDecimal)surplusPayMny, (BigDecimal)BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)surplusPayMny) > 0) {
                settle.setSettlePayMny(surplusPayMny);
            } else {
                settle.setSettlePayMny(pendPayMny);
            }
            pendPayMny = MathUtil.safeSub((BigDecimal)pendPayMny, (BigDecimal)settle.getSettlePayMny());
            contractSettle.setSumPayMny(MathUtil.safeAdd((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)settle.getSettlePayMny()));
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    public boolean writeBackSumPayMny(Long billId, PayRecordEntity entity, List<PayRecordSettleEntity> settleList, boolean flag) {
        BigDecimal payMny = flag ? entity.getThisPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)entity.getThisPayMny());
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        HashMap<Long, BigDecimal> settleMnyMap = new HashMap<Long, BigDecimal>();
        BigDecimal pendPayMny = payMny;
        for (PayRecordSettleEntity settle : settleList) {
            BigDecimal applyMny = flag ? settle.getSettlePayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settle.getSettlePayMny());
            settleMnyMap.put(settle.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.subApi.updateSubSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayRecordSettleEntity settle : settleList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            this.rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settleEntity : settleList) {
                this.rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 6L) {
            this.otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settleEntity : settleList) {
                this.otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        BigDecimal msgPayMny = BigDecimal.ZERO;
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
            entity.setThisPayMny(entity.getThisPayMny().negate());
            PayContractEntity contract = (PayContractEntity)((Object)this.contractService.selectById(entity.getPayapplyId()));
            entity.setBillCode(contract.getBillCode());
            entity.setContractId(contract.getContractId());
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());
            entity.setProjectId(contract.getProjectId());
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());
            entity.setApplyMny(contract.getApplyMny());
            entity.setReceiveUnitId(contract.getReceiveUnitId());
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            entity.setExplanation(contract.getPayReason());
            super.saveOrUpdate((Object)entity);
            contract.setPayStatus(2);
            contract.setConfirmTime(entity.getConfirmTime());
            contract.setEmployeeId(entity.getEmployeeId());
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd((BigDecimal)contract.getPayMny(), (BigDecimal)entity.getThisPayMny()));
            msgPayMny = contract.getPayMny();
            this.contractService.saveOrUpdate((Object)contract);
            List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);
            this.writeBackSumPayMnyAfterReturnPayment(entity, settleList);
            if (vo.getClosed().booleanValue()) {
                this.contractService.closePayment(vo.getPayapplyId());
            }
            BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u4ed8\u6b3e\u9000\u8fd8, (String)"\u5408\u540c\u4ed8\u6b3e\u9000\u56de");
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setOrgId(entity.getOrgId());
            bankFlowVO.setOrgName(entity.getOrgName());
            bankFlowVO.setSourceId(entity.getId());
            bankFlowVO.setBillId(entity.getPayapplyId());
            bankFlowVO.setBillCode(entity.getBillCode());
            bankFlowVO.setBillDate(entity.getConfirmTime());
            bankFlowVO.setAccountId(entity.getAccountId());
            bankFlowVO.setAccountName(entity.getAccountName());
            bankFlowVO.setAccountNum(entity.getAccountNum());
            bankFlowVO.setAccountBank(entity.getAccountBank());
            bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
            bankFlowVO.setMemo(entity.getMemo());
            this.bankFlowService.saveFlowVO(bankFlowVO);
        }
        PayRecordVO payRecordVO = (PayRecordVO)BeanMapper.map((Object)((Object)entity), PayRecordVO.class);
        return payRecordVO;
    }

    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        ArrayList<PayRecordSettleEntity> settleLsit = new ArrayList<PayRecordSettleEntity>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();
        List contractSettleList = this.contracctSettleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PayContractSettleEntity::getPayapplyId, (Object)entity.getPayapplyId())).orderByDesc(BaseEntity::getCreateTime));
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo((BigDecimal)pendPayMny, (BigDecimal)BigDecimal.ZERO) <= 0) continue;
            PayRecordSettleEntity settle = new PayRecordSettleEntity();
            settle.setRecordId(entity.getId());
            settle.setPayapplyId(entity.getPayapplyId());
            settle.setSettleId(contractSettle.getSettleId());
            settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
            if (MathUtil.safeCompareTo((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)pendPayMny) >= 0) {
                settle.setReturnPayMny(pendPayMny);
                contractSettle.setSumPayMny(MathUtil.safeSub((BigDecimal)contractSettle.getSumPayMny(), (BigDecimal)pendPayMny));
                pendPayMny = BigDecimal.ZERO;
            } else {
                settle.setReturnPayMny(contractSettle.getSumPayMny());
                pendPayMny = MathUtil.safeSub((BigDecimal)pendPayMny, (BigDecimal)contractSettle.getSumPayMny());
                contractSettle.setSumPayMny(BigDecimal.ZERO);
            }
            settle.setSettlePayMny(contractSettle.getSumPayMny());
            settleLsit.add(settle);
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            this.settleService.saveOrUpdateBatch(settleLsit);
            this.contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    public boolean writeBackSumPayMnyAfterReturnPayment(PayRecordEntity entity, List<PayRecordSettleEntity> settleList) {
        BigDecimal payMny = entity.getThisPayMny();
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        HashMap<Long, BigDecimal> settleMnyMap = new HashMap<Long, BigDecimal>();
        BigDecimal pendPayMny = payMny;
        for (PayRecordSettleEntity settle : settleList) {
            settleMnyMap.put(settle.getSettleId(), settle.getReturnPayMny().negate());
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.subApi.updateSubSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settle : settleList) {
                this.equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayRecordSettleEntity settle : settleList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), (BigDecimal)settleMnyMap.get(settle.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            this.rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settleEntity : settleList) {
                this.rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 6L) {
            this.otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayRecordSettleEntity settleEntity : settleList) {
                this.otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settleMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }
}

