package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_back")
public class BondDownBackEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @TableField("bond_id")
    private Long bondId;//保证金主键

    @TableField("bill_code")
    private String billCode;//退还编号

    @TableField("memo")
    private String memo;//退还说明

    @TableField("employee_id")
    private Long employeeId;//申请人

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("back_time")
    private Date backTime; //办理时间

    @TableField("employee_name")
    private String employeeName;//申请人 名称

    @TableField("back_mny")
    private BigDecimal backMny;//退还金额 0

    @TableField("bond_code")
    private String bondCode; //保证金编号 1

    @TableField("contract_name")
    private String contractName;// 合同名称 1

    @TableField("contract_id")
    private String contractId;//合同ID 1

    @TableField(value = "org_id")
    private Long orgId; // 组织 1

    @TableField(value = "org_name")
    private String orgName; // 组织名称 1

    @TableField(value = "project_id")
    private Long projectId; // 项目 1

    @TableField(value = "project_name")
    private String projectName; // 项目名称 1

    @TableField(value = "supplier_id")
    private Long supplierId; // 供应商id 1

    @TableField(value = "supplier_name")
    private String supplierName; // 供应商名字 1

    @TableField(value = " bond_pay_mny")
    private BigDecimal bondPayMny;//保证金支付金额 1

    @TableField(value = "return_pay_mny")
    private BigDecimal returnPayMny;//已退还金额 1

    @TableField(value = "residue_mny")
    private BigDecimal residueMny;//剩余可退还金额 1


    @TableField(value = "apply_time")
    private java.util.Date applyTime; // 退还日期 1

    @TableField(value = "account_name")
    private String accountName; // 账户名 1

    @TableField(value = "bank_account")
    private String bankAccount; // 银行账号 1

    @TableField(value = "bank_name")
    private String bankName; // 开户行 1
    @TableField(value="pay_account_name")
    private String payAccountName; // 账户名
    @TableField(value="pay_account_num")
    private String payAccountNum; // 银行账号
    @TableField(value="pay_account_bank")
    private String payAccountBank; // 开户行
    @TableField(value="pay_account_id")
    private Long payAccountId; // 账户名
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态1

    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBondCode() {
        return bondCode;
    }

    public void setBondCode(String bondCode) {
        this.bondCode = bondCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    public Long getPayAccountId() {
        return payAccountId;
    }

    public void setPayAccountId(Long payAccountId) {
        this.payAccountId = payAccountId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getBondPayMny() {
        return bondPayMny;
    }

    public void setBondPayMny(BigDecimal bondPayMny) {
        this.bondPayMny = bondPayMny;
    }

    public BigDecimal getReturnPayMny() {
        return returnPayMny;
    }

    public void setReturnPayMny(BigDecimal returnPayMny) {
        this.returnPayMny = returnPayMny;
    }

    public BigDecimal getResidueMny() {
        return residueMny;
    }

    public void setResidueMny(BigDecimal residueMny) {
        this.residueMny = residueMny;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
