package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 借款申请
 *
 * @author generator
 *
 */
 @TableName("ejc_finance_load_apply")
public class LoadApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    /**
     * 是否属于项目
     */
    @TableField(value = "depend_on_project")
    private String dependOnProject;
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="use_time")
    private java.util.Date useTime; // 用款时间
    @TableField(value="bill_code")
    private java.lang.String billCode; // 申请编号
    @TableField(value="memo")
    private java.lang.String memo; // 申请事由
    @TableField(value="apply_mny")
    private java.math.BigDecimal applyMny; // 申请金额
    @TableField(value="surplus_mny")
    private java.math.BigDecimal surplusMny; // 剩余借款
    @TableField(value="apply_employee_id")
    private java.lang.Long applyEmployeeId; // 申请人
    @TableField(value="apply_employee_name")
    private java.lang.String applyEmployeeName; // 申请人名称

    @TableField(value="dept_id")
    private java.lang.Long deptId; // 费用承担部门
    @TableField(value="dept_name")
    private java.lang.String deptName; // 费用承担部门


    @TableField(value="fee_type")
    private Long feeType;
    @TableField(value="fee_type_name")
    private String feeTypeName;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="apply_time")
    private java.util.Date applyTime; // 申请时间
    @TableField(value="account_name")
    private java.lang.String accountName; // 账户名
    @TableField(value="bank_account")
    private java.lang.String bankAccount; // 银行账号
    @TableField(value="bank_name")
    private java.lang.String bankName; // 开户行
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态
    @TableField(value="pay_type")
    private java.lang.Integer payType; // 付款类型：1-组织付款 2-项目付款
    @TableField(value="pay_status")
    private java.lang.Integer payStatus; // 支付状态：1-未支付 2-已支付
    @TableField(value="pay_mny")
    private java.math.BigDecimal payMny; // 支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="approve_time")
    private java.util.Date approveTime; // 审批时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="confirm_time")
    private java.util.Date confirmTime; // 支付时间
    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    @TableField(value="invoice_flag")
    private String invoiceFlag;

    @TableField(value="org_code")
    private String orgCode; // 组织编码
    /**
     * 收款方式名称
     */
    @TableField("receive_way_name")
    private String receiveWayName;
    /**
     * 收款方式
     */
    @TableField("receive_way")
    private Long receiveWay;

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    @TableField(value="pro_contract_mny")
    private BigDecimal proContractMny; // 收入合同金额
    @TableField(value="pro_output_mny")
    private BigDecimal proOutputMny; // 完成产值
    @TableField(value="pro_date_progress")
    private BigDecimal proDateProgress; // 日期进度
    @TableField(value="pro_output_progress")
    private BigDecimal proOutputProgress; // 产值进度
    @TableField(value="pro_contract_receive_mny")
    private BigDecimal proContractReceiveMny; // 合同累计收款金额
    @TableField(value="pro_receive_mny")
    private BigDecimal proReceiveMny; // 累计收款
    @TableField(value="pro_pay_mny")
    private BigDecimal proPayMny; // 累计付款
    @TableField(value="pro_cost_list_surplus")
    private BigDecimal proCostListSurplus; // 费用清单结余
    @TableField(value="pro_transfer_surplus")
    private BigDecimal proTransferSurplus; // 项目代转款款结余
    @TableField(value="pro_risk_margin_surplus")
    private BigDecimal proRiskMarginSurplus; // 风险保证金结余
    @TableField(value="pro_loan_balance")
    private BigDecimal proLoanBalance; // 借款结余
    @TableField(value="pro_loan_interest")
    private BigDecimal proLoanInterest; // 借款利息
    @TableField(value="pro_other_fee_deduct")
    private BigDecimal proOtherFeeDeduct; // 其他费用扣除
    @TableField(value="pro_other_fee_back")
    private BigDecimal proOtherFeeBack; // 其他费用退还
    @TableField(value="pro_surplus_mny")
    private BigDecimal proSurplusMny; // 项目可用资金
    @TableField(value="pro_surplus_apply_mny")
    private BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    @TableField(value="pro_petty_cash")
    private BigDecimal proPettyCash; // 备用金结余
    @TableField(value="pro_manage_scale")
    private BigDecimal proManageScale; // 管理费比例
    @TableField(value="pro_manage_fee")
    private BigDecimal proManageFee; // 管理费
    @TableField(value="pro_amerce")
    private BigDecimal proAmerce; // 罚款

    @TableField(value="pro_apply_unpay_mny")
    private BigDecimal proApplyUnpayMny; // 已申请未支付金额

    /**
     * 确认收票标识：1-未确认收票，2-已确认
     */
    @TableField("receive_invoice_flag")
    private Integer receiveInvoiceFlag;

    public Integer getReceiveInvoiceFlag() {
        return receiveInvoiceFlag;
    }

    public void setReceiveInvoiceFlag(Integer receiveInvoiceFlag) {
        this.receiveInvoiceFlag = receiveInvoiceFlag;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }


    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }

    public Long getReceiveWay() {
        return receiveWay;
    }

    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }

    public String getOrgCode() {
        return orgCode;
    }



    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }

    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
}
