package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.pub.consts.FinancePubConsts;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.vo.PayReimburseStatisticsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@Controller
@RequestMapping("/payReimburseStatistics")
public class StatisticsController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayReimburseService service;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi orgApi;


    /**
     * 费用报销报表查询
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayReimburseStatisticsVO>> queryList(@RequestBody QueryParam param) {
        List<Integer> billstate = new ArrayList<>();
        String dependOnProject = "0";
        if (param.getParams().containsKey("dependOnProject")) {
            dependOnProject = String.valueOf(param.getParams().get("dependOnProject").getValue());
            param.getParams().remove("dependOnProject");
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("t.billState", new Parameter(QueryParam.IN, billstate));
        param.getParams().put("t.dr", new Parameter(QueryParam.EQ, 0));
        param.getParams().put("t1.dr", new Parameter(QueryParam.EQ, 0));
        // 组织本下
        param.getParams().put("t.org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //接收费用类型筛选条件
        String feeTypeName = param.getParams().get("feeTypeName") != null ? param.getParams().get("feeTypeName").getValue().toString() : null;
        //定义费用类型map
        Map<Long, String> feeTypeMap = new HashMap<>();
        Page<PayReimburseStatisticsVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        //查询自定义档案 费用报销类型
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(FinancePubConsts.COST_TYPE);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
            List<DefdocDetailVO> list = resp.getData().stream().filter(s -> s.getEnabled() != 0).collect(Collectors.toList());
            if ("1".equals(dependOnProject)) {
                DefdocDetailVO defdocDetailVO = new DefdocDetailVO();
                defdocDetailVO.setId(null);
                defdocDetailVO.setName("分摊费用");
                list.add(defdocDetailVO);
            }
            //循环费用类型的档案，如果输入了费用类别筛选 ，匹配档案中的name并保存档案id用作查询筛选
            for (DefdocDetailVO defdoc : list) {
                if (StringUtils.isNotBlank(feeTypeName)) {
                    String defdocName = defdoc.getName();
                    if (defdocName.contains(feeTypeName)) {
                        feeTypeMap.put(defdoc.getId(), defdoc.getName());
                    }
                }
            }
            List<Long> feeType = new ArrayList<>(feeTypeMap.keySet());
            //查询外层项目维度数据
            param.getParams().remove("feeTypeName");
            if (CollectionUtils.isNotEmpty(feeType)) {
                //param.getParams().put("feeType",new Parameter(QueryParam.IN,feeType));
            }


            QueryWrapper<PayReimburseEntity> wrapper = changeToQueryWrapper(param);
            wrapper.eq("t.depend_on_project", dependOnProject);
            if (CollectionUtils.isNotEmpty(feeType)) {
                if (feeType.contains(null)) {
                    wrapper.in("t1.fee_type", feeType).or().isNull("t1.fee_type");
                }
            }
            IPage<PayReimburseStatisticsVO> listPage = service.payReimburseStatisticsList(page, wrapper, dependOnProject);
            List<PayReimburseStatisticsVO> records = listPage.getRecords();

            for (DefdocDetailVO defdoc : list) {
                //项目维度的数据插入子项目明细，根据费用类型维度，每种类型固定插入明细数据
                for (PayReimburseStatisticsVO record : records) {
                    List<PayReimburseStatisticsVO> children = record.getChildren();
                    if (CollectionUtils.isEmpty(children)) {
                        children = new ArrayList<>();
                    }
                    //判断没输入费用类型，或者匹配到费用类型
                    if(feeTypeMap.isEmpty() || feeTypeMap.containsKey(defdoc.getId())){
                        PayReimburseStatisticsVO newVO = new PayReimburseStatisticsVO();
                        newVO.setId(IdWorker.getId());
                        newVO.setProjectId(record.getProjectId());
                        newVO.setOrgId(record.getOrgId());
                        newVO.setFeeType(defdoc.getId());
                        newVO.setFeeTypeName(defdoc.getName());
                        children.add(newVO);

                        newVO.setThisMonthApplyMny(BigDecimal.ZERO);//本月申请金额
                        newVO.setThisMonthInvoiceMny(BigDecimal.ZERO);//本月发票金额
                        newVO.setThisMonthPayMny(BigDecimal.ZERO);//本月支付金额
                        newVO.setThisMonthShareMny(BigDecimal.ZERO);//本月分摊金额
                        newVO.setThisMonthOrgShareMny(BigDecimal.ZERO);//本月组织报销被分摊费用

                        newVO.setThisYearApplyMny(BigDecimal.ZERO);//本年申请金额
                        newVO.setThisYearInvoiceMny(BigDecimal.ZERO);//本年发票金额
                        newVO.setThisYearPayMny(BigDecimal.ZERO);//本年支付金额
                        newVO.setThisYearShareMny(BigDecimal.ZERO);//本年分摊金额
                        newVO.setThisYearOrgShareMny(BigDecimal.ZERO);//本年组织报销被分摊费用

                        newVO.setSumApplyMny(BigDecimal.ZERO);//累计申请金额
                        newVO.setSumInvoiceMny(BigDecimal.ZERO);//累计发票金额
                        newVO.setSumPayMny(BigDecimal.ZERO);//累计支付金额
                        newVO.setSumShareMny(BigDecimal.ZERO);//累计分摊金额
                        newVO.setSumOrgShareMny(BigDecimal.ZERO);//累计组织报销被分摊费用
                        record.setChildren(children);
                    }
                }
            }

            for (PayReimburseStatisticsVO record : records) {
                List<PayReimburseStatisticsVO> children = record.getChildren();
                //根据项目查询金额明细
                List<PayReimburseStatisticsVO> detailList = service.payReimburseStatisticsDetailList(record.getProjectId(), record.getOrgId(), wrapper);
                if(CollectionUtils.isEmpty(children)){
                    children = new ArrayList<>();
                }
                //循环明细
                for (PayReimburseStatisticsVO detail : children) {
                    for (PayReimburseStatisticsVO detailData : detailList) {
                        //循环查询到的金额明细，如果查到的费用类型匹配预制的费用类型，则插入金额字段
                        Long detailId = detail.getProjectId() != null ? detail.getProjectId() : detail.getOrgId();
                        Long detailDataId = detailData.getProjectId() != null ? detailData.getProjectId() : detailData.getOrgId();
                        if (detailId.equals(detailDataId)) {
                            if ((detail.getFeeType() == null && detailData.getFeeType() == null) || (detail.getFeeType() != null && detail.getFeeType().equals(detailData.getFeeType()))) {
                                detail.setThisMonthApplyMny(detailData.getThisMonthApplyMny());//本月申请金额
                                detail.setThisMonthInvoiceMny(detailData.getThisMonthInvoiceMny());//本月发票金额
                                detail.setThisMonthPayMny(detailData.getThisMonthPayMny());//本月支付金额
                                detail.setThisMonthShareMny(detailData.getThisMonthShareMny());//本月分摊金额
                                detail.setThisMonthOrgShareMny(detailData.getThisMonthOrgShareMny());//本月组织报销被分摊费用

                                detail.setThisYearApplyMny(detailData.getThisYearApplyMny());//本年申请金额
                                detail.setThisYearInvoiceMny(detailData.getThisYearInvoiceMny());//本年发票金额
                                detail.setThisYearPayMny(detailData.getThisYearPayMny());//本年支付金额
                                detail.setThisYearShareMny(detailData.getThisYearShareMny());//本年分摊金额
                                detail.setThisYearOrgShareMny(detailData.getThisYearOrgShareMny());//本年组织报销被分摊费用

                                detail.setSumApplyMny(detailData.getSumApplyMny());//累计申请金额
                                detail.setSumInvoiceMny(detailData.getSumInvoiceMny());//累计发票金额
                                detail.setSumPayMny(detailData.getSumPayMny());//累计支付金额
                                detail.setSumShareMny(detailData.getSumShareMny());//累计分摊金额
                                detail.setSumOrgShareMny(detailData.getSumOrgShareMny());//累计组织报销被分摊费用
                            }
                        }
                    }
                }
            }
            return CommonResponse.success("列表查询成功",listPage);
        }else{
            return CommonResponse.error("列表查询失败");
        }
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<Integer> billstate = new ArrayList<>();
        String dependOnProject = "0";
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().containsKey("dependOnProject")) {
            dependOnProject = String.valueOf(param.getParams().get("dependOnProject").getValue());
            param.getParams().remove("dependOnProject");
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("t.billState", new Parameter(QueryParam.IN, billstate));
        param.getParams().put("t.dr", new Parameter(QueryParam.EQ, 0));
        // 组织本下
        param.getParams().put("t.org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //接收费用类型筛选条件
        String feeTypeName = param.getParams().get("feeTypeName") != null ? param.getParams().get("feeTypeName").getValue().toString() : null;
        //定义费用类型map
        Map<Long, String> feeTypeMap = new HashMap<>();
        Page<PayReimburseStatisticsVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<PayReimburseStatisticsVO> listPage = new Page<>();
        //查询自定义档案 费用报销类型
        CommonResponse<List<DefdocDetailVO>> resp = defdocApi.getDefDocByDefId(FinancePubConsts.COST_TYPE);
        if(resp.isSuccess() && CollectionUtils.isNotEmpty(resp.getData())) {
            List<DefdocDetailVO> list = resp.getData().stream().filter(s -> s.getEnabled() != 0).collect(Collectors.toList());
            if ("1".equals(dependOnProject)) {
                DefdocDetailVO defdocDetailVO = new DefdocDetailVO();
                defdocDetailVO.setId(null);
                defdocDetailVO.setName("分摊费用");
                list.add(defdocDetailVO);
            }
            //循环费用类型的档案，如果输入了费用类别筛选 ，匹配档案中的name并保存档案id用作查询筛选
            for (DefdocDetailVO defdoc : list) {
                if (StringUtils.isNotBlank(feeTypeName)) {
                    String defdocName = defdoc.getName();
                    if (defdocName.contains(feeTypeName)) {
                        feeTypeMap.put(defdoc.getId(), defdoc.getName());
                    }
                }
            }
            List<Long> feeType = new ArrayList<Long>(feeTypeMap.keySet());
            //查询外层项目维度数据
            param.getParams().remove("feeTypeName");
            if (CollectionUtils.isNotEmpty(feeType)) {
                //param.getParams().put("feeType",new Parameter(QueryParam.IN,feeType));
            }
            QueryWrapper<PayReimburseEntity> wrapper = changeToQueryWrapper(param);
            wrapper.eq("t.depend_on_project", dependOnProject);
            if (CollectionUtils.isNotEmpty(feeType)) {
                if (feeType.contains(null)) {
                    wrapper.in("t1.fee_type", feeType).or().isNull("t1.fee_type");
                }
            }
            listPage = service.payReimburseStatisticsList(page, wrapper, dependOnProject);
            List<PayReimburseStatisticsVO> records = listPage.getRecords();

            for (DefdocDetailVO defdoc : list) {
                //项目维度的数据插入子项目明细，根据费用类型维度，每种类型固定插入明细数据
                for (PayReimburseStatisticsVO record : records) {
                    List<PayReimburseStatisticsVO> children = record.getChildren();
                    if (CollectionUtils.isEmpty(children)) {
                        children = new ArrayList<>();
                    }
                    //判断没输入费用类型，或者匹配到费用类型
                    if(feeTypeMap.isEmpty() || feeTypeMap.containsKey(defdoc.getId())){
                        PayReimburseStatisticsVO newVO = new PayReimburseStatisticsVO();
                        newVO.setId(IdWorker.getId());
                        newVO.setProjectId(record.getProjectId());
                        newVO.setOrgId(record.getOrgId());
                        newVO.setFeeType(defdoc.getId());
                        newVO.setFeeTypeName(defdoc.getName());

                        newVO.setThisMonthApplyMny(BigDecimal.ZERO);//本月申请金额
                        newVO.setThisMonthInvoiceMny(BigDecimal.ZERO);//本月发票金额
                        newVO.setThisMonthPayMny(BigDecimal.ZERO);//本月支付金额
                        newVO.setThisMonthShareMny(BigDecimal.ZERO);//本月分摊金额

                        newVO.setThisYearApplyMny(BigDecimal.ZERO);//本年申请金额
                        newVO.setThisYearInvoiceMny(BigDecimal.ZERO);//本年发票金额
                        newVO.setThisYearPayMny(BigDecimal.ZERO);//本年支付金额
                        newVO.setThisYearShareMny(BigDecimal.ZERO);//本年分摊金额

                        newVO.setSumApplyMny(BigDecimal.ZERO);//累计申请金额
                        newVO.setSumInvoiceMny(BigDecimal.ZERO);//累计发票金额
                        newVO.setSumPayMny(BigDecimal.ZERO);//累计支付金额
                        newVO.setSumShareMny(BigDecimal.ZERO);//累计分摊金额
                        children.add(newVO);
                        record.setChildren(children);
                    }
                }
            }

            for (PayReimburseStatisticsVO record : records) {
                List<PayReimburseStatisticsVO> children = record.getChildren();
                //根据项目查询金额明细
                List<PayReimburseStatisticsVO> detailList = service.payReimburseStatisticsDetailList(record.getProjectId(), record.getOrgId(), wrapper);
                //循环明细
                for (PayReimburseStatisticsVO detail : children) {
                    for (PayReimburseStatisticsVO detailData : detailList) {
                        //循环查询到的金额明细，如果查到的费用类型匹配预制的费用类型，则插入金额字段
                        Long detailId = detail.getProjectId() != null ? detail.getProjectId() : detail.getOrgId();
                        Long detailDataId = detailData.getProjectId() != null ? detailData.getProjectId() : detailData.getOrgId();
                        if (detailId.equals(detailDataId)) {
                            if ((detail.getFeeType() == null && detailData.getFeeType() == null) || (detail.getFeeType() != null && detail.getFeeType().equals(detailData.getFeeType()))) {
                                detail.setThisMonthApplyMny(detailData.getThisMonthApplyMny());//本月申请金额
                                detail.setThisMonthInvoiceMny(detailData.getThisMonthInvoiceMny());//本月发票金额
                                detail.setThisMonthPayMny(detailData.getThisMonthPayMny());//本月支付金额
                                detail.setThisMonthShareMny(detailData.getThisMonthShareMny());//本月分摊金额

                                detail.setThisYearApplyMny(detailData.getThisYearApplyMny());//本年申请金额
                                detail.setThisYearInvoiceMny(detailData.getThisYearInvoiceMny());//本年发票金额
                                detail.setThisYearPayMny(detailData.getThisYearPayMny());//本年支付金额
                                detail.setThisYearShareMny(detailData.getThisYearShareMny());//本年分摊金额

                                detail.setSumApplyMny(detailData.getSumApplyMny());//累计申请金额
                                detail.setSumInvoiceMny(detailData.getSumInvoiceMny());//累计发票金额
                                detail.setSumPayMny(detailData.getSumPayMny());//累计支付金额
                                detail.setSumShareMny(detailData.getSumShareMny());//累计分摊金额
                            }
                        }
                    }
                }
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listPage.getRecords());
        String exitsName = "org";
        if("1".equals(dependOnProject)){
            exitsName = "project";
        }
        ExcelExport.getInstance().export("ReimburseStatistics-"+exitsName+"-export.xlsx", beans, response);
    }
}
