package com.ejianc.business.finance.service.impl;

import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
@Service("bondUpBack")
public class BondUpBackBpmServiceImpl  implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBondUpBackService service;
    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBankFlowService bankFlowService;

    @Autowired
    private IBankAcctService bankAcctService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    };

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
        //TODO
        return CommonResponse.success();
    }


    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
        return CommonResponse.success();
    };

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    };

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("进入终审后回写--- billId:"+billId+"  state:"+state);
        BondUpBackEntity entity = service.selectById(billId);
        //==================推送收支流水
        BondUpEntity bondUpEntity = bondUpService.selectById(entity.getBondId());
        BankAcctEntity bankAcctEntity = bankAcctService.selectById(entity.getAccountId());
        BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.对上保证金退还);
        flowVO.setBillDate(entity.getBackTime());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getId());
        flowVO.setReceiveMoney(entity.getBackMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(bondUpEntity.getOrgId());
        flowVO.setOrgName(bondUpEntity.getOrgName());
        if (null!=bankAcctEntity) {
            flowVO.setAccountOrgId(bankAcctEntity.getOrgId());
            flowVO.setAccountOrgName(bankAcctEntity.getOrgName());
        }
        flowVO.setAccountId(entity.getAccountId());
        flowVO.setAccountName(entity.getAccountName());
        flowVO.setAccountBank(entity.getAccountBank());
        flowVO.setAccountNum(entity.getAccountNum());

        flowVO.setTradeOrgId(entity.getCustomerId());
        flowVO.setTradeOrgName(entity.getCustomerName());
        flowVO.setMemo(entity.getMemo());
        bankFlowService.saveFlowVO(flowVO);
        //===============推送收支流水结束
        return CommonResponse.success();
    }



    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
        BondUpBackEntity entity = service.selectById(billId);
        //删除流水记录
        bankFlowService.delFlowBySource(entity.getId(),entity.getId());
        return CommonResponse.success();
    }




    /**
     * 有审批流的撤回前回调
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }
    /**
     * 弃审前事件回调
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        BondUpBackEntity entity = service.selectById(billId);
        if (entity == null) {
            return CommonResponse.error("查询不到该单据信息！");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bond_id", new Parameter(QueryParam.EQ, entity.getBondId()));
        param.getOrderMap().put("create_time", QueryParam.DESC);
        List<BondUpBackEntity> bondUpBackEntities = service.queryList(param);
        if (CollectionUtils.isNotEmpty(bondUpBackEntities) && null != bondUpBackEntities.get(0)){
            BondUpBackEntity backEntity = bondUpBackEntities.get(0);
            if (!entity.getId().equals(billId)){
                return CommonResponse.error("当前单据已有新的对上保证金退还，不能弃审/撤回！");
            }
        }
        return CommonResponse.success("弃审/撤回前校验回调成功！");

    }

    }
