package com.ejianc.business.finance.controller;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.ZczbVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.FilterOrgIdVo;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * BI
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@RestController
@RequestMapping("/bi")
public class BiController {
  private final Logger logger = LoggerFactory.getLogger(this.getClass());
  @Resource private IProjectApi projectApi;
  @Resource private IPayContractService payContractService;
  @Resource private IPaySporadicService paySporadicService;
  @Resource private IPayReimburseService payReimburseService;
  @Resource private ILoadReimburseService loadReimburseService;

  /**
   * 支出占比
   *
   * @param orgId 组织id
   * @param dateIn 时间
   * @param projectStatus 项目状态
   * @return {@link CommonResponse}<{@link JSONObject}>
   */
  @GetMapping("/zczb")
  public CommonResponse<JSONObject> getZczb(
      @RequestParam("orgId") Long orgId,
      @RequestParam("dateIn") String dateIn,
      @RequestParam("projectStatus") String projectStatus) {
    JSONObject js = new JSONObject();
    List<ZczbVO> zczbVOS = new LinkedList<>();
    FilterOrgIdVo filterOrgIdVo = new FilterOrgIdVo();
    filterOrgIdVo.setOrgId(orgId);
    filterOrgIdVo.setDateIn(dateIn);
    filterOrgIdVo.setProjectStatus(projectStatus);
    CommonResponse<List<Long>> response = projectApi.queryFilterOrgIds(filterOrgIdVo);
    if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
      logger.error(
          "BI大屏查询组织ids失败, orgId={}, dateIn={}, projectStatus={}", orgId, dateIn, projectStatus);
      zczbVOS.add(ZczbVO.builder().name("人工费").value(BigDecimal.ZERO).build());
      zczbVOS.add(ZczbVO.builder().name("材料费").value(BigDecimal.ZERO).build());
      zczbVOS.add(ZczbVO.builder().name("机械费").value(BigDecimal.ZERO).build());
      zczbVOS.add(ZczbVO.builder().name("专业分包费").value(BigDecimal.ZERO).build());
      zczbVOS.add(ZczbVO.builder().name("间接费").value(BigDecimal.ZERO).build());
      js.put("zczb", zczbVOS);
      return CommonResponse.success(js);
    }
    List<Long> orgIds = response.getData();
    QueryWrapper<PayContractEntity> query = Wrappers.query();
    query
        .select("contract_type_extend as contractTypeExtend, ifnull(sum(pay_mny), 0) as totalMny")
        .eq("dr", 0)
        .in("bill_state", 1, 3)
        .in("org_id", orgIds)
        .groupBy("contract_type_extend")
        .last("order by null");
    List<Map<String, Object>> resultMap = payContractService.listMaps(query);
    //    合同类型扩展：0-劳务分包,1-专业分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
    BigDecimal lwfb = BigDecimal.ZERO;
    BigDecimal zyfb = BigDecimal.ZERO;
    BigDecimal sbcg = BigDecimal.ZERO;
    BigDecimal sbzl = BigDecimal.ZERO;
    BigDecimal wzcg = BigDecimal.ZERO;
    BigDecimal zzczl = BigDecimal.ZERO;
    BigDecimal qtzc = BigDecimal.ZERO;

    if (CollectionUtils.isNotEmpty(resultMap)) {
      lwfb =
          resultMap.stream()
              .filter(e -> "0".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      zyfb =
          resultMap.stream()
              .filter(e -> "1".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      sbcg =
          resultMap.stream()
              .filter(e -> "2".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      sbzl =
          resultMap.stream()
              .filter(e -> "3".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      wzcg =
          resultMap.stream()
              .filter(e -> "4".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      zzczl =
          resultMap.stream()
              .filter(e -> "5".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      qtzc =
          resultMap.stream()
              .filter(e -> "6".equals(String.valueOf(e.get("contractTypeExtend"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    QueryWrapper<PaySporadicEntity> query1 = Wrappers.query();
    query1
        .select("sporadic_payment_type as sporadicPaymentType, ifnull(sum(pay_mny), 0) as totalMny")
        .eq("dr", 0)
        .in("bill_state", 1, 3)
        .in("org_id", orgIds)
        .groupBy("sporadic_payment_type")
        .last("order by null");
    List<Map<String, Object>> resultMap1 = paySporadicService.listMaps(query1);
    // 零星费用类型：1:零星材料、2:零星机械、3:其他
    BigDecimal lxcl = BigDecimal.ZERO;
    BigDecimal lxjx = BigDecimal.ZERO;
    BigDecimal qt = BigDecimal.ZERO;

    if (CollectionUtils.isNotEmpty(resultMap1)) {
      lxcl =
          resultMap1.stream()
              .filter(e -> "1".equals(String.valueOf(e.get("sporadicPaymentType"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      lxjx =
          resultMap1.stream()
              .filter(e -> "2".equals(String.valueOf(e.get("sporadicPaymentType"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);

      qt =
          resultMap1.stream()
              .filter(e -> "3".equals(String.valueOf(e.get("sporadicPaymentType"))))
              .map(e -> new BigDecimal(String.valueOf(e.get("totalMny"))))
              .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    QueryWrapper<PayReimburseEntity> query2 = Wrappers.query();
    query2
        .select("ifnull(sum(pay_mny), 0) as totalMny")
        .eq("dr", 0)
        .in("bill_state", 1, 3)
        .in("org_id", orgIds);
    Map<String, Object> map = payReimburseService.getMap(query2);
    BigDecimal fybx = new BigDecimal(String.valueOf(map.get("totalMny")));

    QueryWrapper<LoadReimburseEntity> query3 = Wrappers.query();
    query3
        .select("ifnull(sum(reimburse_mny), 0) as totalMny")
        .eq("dr", 0)
        .in("bill_state", 1, 3)
        .in("org_id", orgIds);
    Map<String, Object> map1 = loadReimburseService.getMap(query3);
    BigDecimal byjbx = new BigDecimal(String.valueOf(map1.get("totalMny")));

    /*
    人工费 = 【合同类型】=劳务分包 的分包合同付款金额合计值；
    材料费 = 物资采购合同付款金额合计值 + 周转材租赁合同付款金额合计值 + 零星付款(费用类型=零星材料) 付款金额合计值；
    机械费 = 设备采购合同付款金额合计值 + 设备租赁合同付款金额合计值 + 零星付款(费用类型=零星机械) 付款金额合计值；
    专业分包费 = 【合同类型】=专业分包 的分包合同付款金额合计值；
    间接费 = 零星付款(费用类型=其他) 付款金额合计值 + 费用报销付款金额合计值 + 备用金报销金额合计值；
    */
    zczbVOS.add(ZczbVO.builder().name("人工费").value(lwfb).build());
    zczbVOS.add(ZczbVO.builder().name("材料费").value(NumberUtil.add(wzcg, zzczl, lxcl)).build());
    zczbVOS.add(ZczbVO.builder().name("机械费").value(NumberUtil.add(sbcg, sbzl, lxjx)).build());
    zczbVOS.add(ZczbVO.builder().name("专业分包费").value(zyfb).build());
    zczbVOS.add(ZczbVO.builder().name("间接费").value(NumberUtil.add(qtzc, qt, fybx, byjbx)).build());
    js.put("zczb", zczbVOS);
    return CommonResponse.success(js);
  }
}
