package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.foundation.share.service.IPSRMDataService;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IPayContractService extends IBaseService<PayContractEntity> , IPSRMDataService<PayContractVO> {

    PayContractVO insertOrUpdate(PayContractVO payContractVO);

    PayContractVO queryDetail(Long id);

    List<PayContractVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    JSONObject querySettleRefer(QueryParam param, Integer contractType);

    /**
     * @description:
     *
     * @param contractId
     * @param orgId
     * @param applyMnyContainFree 截止上期已申请金额是否包含自由态的applyMnyContainFreeFlag
     * @return {@link SumPayMnyVO}
     * @author songlx
     * @date: 2022/12/28
     */
    SumPayMnyVO getSumPayMny(Long contractId, Long orgId, Boolean applyMnyContainFree);

    SumPayMnyVO getSumPayMnyVOList(Long contractId, Long orgId);

    JSONObject queryPendingPageJson(QueryParam param, boolean isEs);

    JSONObject queryAllList(QueryParam param);

    List<PayApplyPubVO> queryExportPendingList(QueryParam param);

    String batchConfirm(List<PayApplyPubVO> vos);

    boolean writeBackSumPayMny(Long billId, PayContractEntity entity, boolean flag);

    ManageDetailVO getManageDetail(Long projectId);

    SumMnyStatisticVO getStatisticsMny();

    /**
     * 根据条件统计合同付款的支付金额总数
     *
     * @param tenantId 租户Id
     * @param projectIds 带过滤项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds);

    List<FinanceMonthVO> getMonthInfo(Long projectId, String timeRange);

    List<FinanceCostVO> getCostInfo(Long projectId, String year);

    Map<String, BigDecimal> getSubSettlePay(PubContractSubQueryVO pubContractSubQueryVO);

    Map<String, PayMnyWarnVO> getPayMnyByTenantIds(PubWarnQueryVO pubWarnQueryVO);

    Map<Long, PayAndReceiveMnyWarnVO> getSumPayMnyMap(List<Long> tenantIds);

    Map<Long, PayAndReceiveMnyWarnVO> getSumReceiveMnyMap(List<Long> tenantIds);

    Map<Long, PayAndReceiveMnyWarnVO> getSumReimburseMnyMap(List<Long> tenantIds);

    List<Map<String, Object>> queryBondExpireWarn(List<SqlParam> sqlParamList);

    JSONObject projectProgress(Long projectId, Date startDate, Date endDate);

    JSONObject projectIncome(Long projectId);

    JSONObject projectOut(Long projectId);

    Map<String, PayMnyWarnVO> warnPayMny(PubWarnQueryVO pubWarnQueryVO);

    Map<String, PayMnyWarnVO> warnMaterialPayMny(PubWarnQueryVO pubWarnQueryVO);

    Map<String, PayMnyWarnVO> warnMaterialPrePayMny(PubWarnQueryVO pubWarnQueryVO);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs, String type);

    ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny, BigDecimal proSurplusApplyMny, Long orgId);

    ProjectFinanceVO getProFinance(Long projectId);

    List<ProjectReimburseVO> getProjectReimburse(List<Long> projectIds);

    List<FinanceWarnV0> getProjectPayMny();

    JSONObject queryLaborSalaryApplyPageJson(QueryParam param, boolean b);

    List<PayContractVO> queryLaborSalaryApplyExportList(QueryParam queryParam);

    /**
     * 付款关闭
     *
     * @param id 付款申请id
     */
    void closePayment(Long id);

    ProjectFinancePayVO getProjectApplyPayInfo(Long projectId);

    Map<Long, BigDecimal> getApplyMnyHasFree(List<Long> settleIds, Long id);

    ParamsCheckVO checkParamsToLabor(PayContractVO vo);

    // 查询完成入库物资明细
    List<InstoreMaterialVO> queryInstoreMaterialById(Long id);

    BigDecimal queryWeeklyProgressByProjectId(Long projectId);

    BigDecimal queryTotalAmountByContractIds(List<Long> contractIds);
}
