package com.ejianc.business.finance.service.impl;

import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.service.ILoadBackService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("loadBack")
public class LoadBackBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ILoadBackService loadBackService;

	@Autowired
	private IBankFlowService bankFlowService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		LoadBackEntity entity = loadBackService.getById(billId);
		BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.备用金退还, "备用金退还");
		bankFlowVO.setTradeOrgId(entity.getApplyEmployeeId());
		bankFlowVO.setTradeOrgName(entity.getApplyEmployeeName());

		bankFlowVO.setOrgId(entity.getOrgId());
		bankFlowVO.setOrgName(entity.getOrgName());
		bankFlowVO.setSourceId(entity.getId());
		bankFlowVO.setBillId(entity.getId());
		bankFlowVO.setBillCode(entity.getBillCode());
		bankFlowVO.setAccountId(entity.getAccountId());
		bankFlowVO.setAccountName(entity.getAccountName());
		bankFlowVO.setAccountNum(entity.getBankAccount());
		bankFlowVO.setAccountBank(entity.getBankName());
		bankFlowVO.setReceiveMoney(entity.getBackMny());
		bankFlowVO.setMemo(entity.getMemo());
		bankFlowService.saveFlowVO(bankFlowVO);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		bankFlowService.delFlowBySource(null, billId);
		return CommonResponse.success();
	}

}
