package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.equipment.vo.SettlementVO;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.consts.EJCDateUtil;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
@Service
public class PayReimburseServiceImpl extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity> implements IPayReimburseService {
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";//【项目可用资金】控制项目【申请金额	】

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IPayRecordService payRecordService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private FeignUtil feignUtil;

    @Autowired
    private PayContractApi payContractApi;

    @Autowired
    private ISettlementApi iSettlementApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPaySporadicService paySporadicService; //零星付款申请
    @Autowired
    private ILoadReimburseService loadReimburseService;//备用金
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】

    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private PaySporadicMapper paySporadicMapper;
    @Autowired
    private LoadReimburseMapper loadReimburseMapper;

    @Autowired
    private IReimburseShareService reimburseShareService;

    @Autowired
    private IBankFlowService bankFlowService;

    @Autowired
    private ICustomBusinessDataService customBusinessDataService;

    @Value("${extend.field.mode:false}")
    private Boolean extFieldsMode;

    @Autowired
    private IPayInfoService payInfoService;

    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        //放入费用类别汇总(子表)
        List<PayInfoVO> payInfoList = vo.getPayInfoList();
        if (CollectionUtils.isNotEmpty(payInfoList)) {
            String feeTypeNames = payInfoList.stream().filter(s -> !"del".equals(s.getRowState())).map(PayInfoVO::getFeeTypeName).distinct().collect(Collectors.joining(","));
            String feeTypeIds =  payInfoList.stream().filter(s -> !"del".equals(s.getRowState())).map(e->e.getFeeType().toString()).distinct().collect(Collectors.joining(","));
            vo.setSubFeeTypeNames(StringUtils.isBlank(feeTypeNames) ? null : feeTypeNames);
            vo.setSubFeeTypeIds(feeTypeIds);
        } else {
            vo.setSubFeeTypeNames(null);
        }

        PayReimburseEntity entity = BeanMapper.map(vo, PayReimburseEntity.class);
        // 自动生成编码
        this.autoSetBillCode(entity);
        //设置默认值
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        entity.setQuoteFlag(0);
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty(voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                // 保存时校验version是否一致
                if (!ValidateUtil.validateUpstreamVersion(String.valueOf(invoiceVO.getInvoiceId()),
                        BillTypeCodeEnum.税务收票.getBillTypeCode(), invoiceVO.getInvoiceVersion())) {
                    throw new BusinessException("发票已被更新，请刷新后重做！");
                }
            }
        }
        CommonResponse<String> usedMnyRes = invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);//存放发票确认标识
        // 保存主表
        super.saveOrUpdateNoES(entity);

        Long id = entity.getId();
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        PayReimburseEntity byId = super.selectById(id);
        // 返回VO
        PayReimburseVO backVO = BeanMapper.map(byId, PayReimburseVO.class);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
            wrapper.eq("payapply_id", entity.getId());
            invoiceVOList = invoiceService.list(wrapper);
        }
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));// 发票列表
        ProjectFinanceVO v = BeanMapper.map(byId, ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    /**
     * 更新发票
     * @param vo
     * @param id
     * @return
     */
    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        List<InvoiceReceiveFlagVO> flagVOS = new ArrayList<>();
        List<Long> receiveIds = new ArrayList<>();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(1);
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        // 删除
        List<PayInvoiceEntity> dataList = invoiceService.list(new QueryWrapper<PayInvoiceEntity>().eq("payapply_id", id));
        List<Long> dataIds = dataList.stream().map(PayInvoiceEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(voList)) {
            List<Long> voIds = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
            dataIds.removeAll(voIds);
        }
        List<Long> delIds = dataIds;
        if (!delIds.isEmpty()) {
            invoiceService.remove(new QueryWrapper<PayInvoiceEntity>().in("id", delIds), false);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        // 查询主表
        PayReimburseEntity entity = this.selectById(id);
        PayReimburseVO vo = BeanMapper.map(entity, PayReimburseVO.class);
        // 查询关联发票
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        // 查询付款记录
        List<PayRecordEntity> recordList = payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList(recordList, PayRecordVO.class));

        //项目资金详情
        vo.setProjectFinanceVO(BeanMapper.map(vo, ProjectFinanceVO.class));

        if (null != vo.getPayMny()) {
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PayReimburseVO> resVos =(List<PayReimburseVO>) querySubExcelList(param, false).get("records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); i++) {
                PayReimburseVO vo = resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setIsShareFlagName(vo.getIsShareFlag() != null && vo.getIsShareFlag() == 1 ? "是" : "否");
            }
            ;
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PayReimburseEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(entityList)) {
            // 逆回写收票占用金额
            CommonResponse<String> res = invoiceService.updateInvoiceUsedMnyByDel(ids);
            if (res.isSuccess()) {
                super.removeByIds(ids, false);
                // 删除发票
                QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>().in("payapply_id", ids);
                List<PayInvoiceEntity> invoiceList = invoiceService.list(wrapper);
                invoiceService.remove(wrapper, false);
            }
        }
        return "删除成功！";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("bearDept");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //页面跳转携带的orgId 没用使用本下
        if (!param.getParams().containsKey("orgId")) {
            //移动端和pc端权限处理
            UserContext userContext = sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);

            if (StringUtils.isNotEmpty(authOrgIds)) {
                CommonResponse<List<OrgVO>> authResponse =
                        orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                                collect(Collectors.toList()));
                logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page<PayReimburseVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        String feeType = null;
        if (param.getParams().containsKey("feeType")) {
            feeType = param.getParams().get("feeType").getValue().toString();
            param.getParams().remove("feeType");
            param.getParams().put("sub_fee_type_ids",new Parameter(QueryParam.LIKE,feeType));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("a.id");
        List<PayReimburseVO> list = baseMapper.queryPageList(pages, wrapper, flag);

        /** 找出要查询的扩展单据id*/
        List<Long> businessIdList = new ArrayList<>();
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            businessIdList.add(vo.getId());
        });

        if(extFieldsMode && ListUtil.isNotEmpty(businessIdList)){
            /** 根据单据id查询出这些单据的扩展字段集合 */
            CommonResponse<Map<Long, CustomBusinessDataVO>> customBusinessDataResponse = customBusinessDataService.queryCustomBusinessData(businessIdList);
            if(customBusinessDataResponse.isSuccess()) {
                Map<Long, CustomBusinessDataVO> customBusinessDataMap = customBusinessDataResponse.getData();
                for (PayReimburseVO payReimburseVO : list) {
                    CustomBusinessDataVO subCustomBusinessDataVo = customBusinessDataMap.get(payReimburseVO.getId());
                    if(subCustomBusinessDataVo != null) {
                        Map<String, Object> subCustomField = JSONObject.parseObject(subCustomBusinessDataVo.getBusinessData());
                        /** 将扩展字段的值赋值给相应的单据 */
                        payReimburseVO.setCustomField(subCustomField);
                    }
                }
            }
        }
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }
    @Override
    public JSONObject querySubExcelList(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("bearDept");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payReason");

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //页面跳转携带的orgId 没用使用本下
        if (!param.getParams().containsKey("orgId")) {
            //移动端和pc端权限处理
            UserContext userContext = sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);

            if (StringUtils.isNotEmpty(authOrgIds)) {
                CommonResponse<List<OrgVO>> authResponse =
                        orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                                collect(Collectors.toList()));
                logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
                param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        // 组织本下
        //param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PayReimburseVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        String feeType = null;
        if (param.getParams().containsKey("feeType")) {
            feeType = param.getParams().get("feeType").getValue().toString();
            param.getParams().remove("feeType");
            param.getParams().put("sub_fee_type_ids",new Parameter(QueryParam.LIKE,feeType));
        }
        boolean feeTypeIsNull = param.getParams().containsKey("feeTypeIsNull");
        if (feeTypeIsNull) {
            param.getParams().remove("feeTypeIsNull");
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.eq(StringUtils.isNotBlank(feeType), "a.pft", feeType);
        wrapper.isNull(feeTypeIsNull, "a.pft");
        List<PayReimburseVO> list = baseMapper.querySubExcelList(pages, wrapper, flag);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }


    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<PayReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(pay_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        付款类型：1-组织付款 2-项目付款
        queryWrapper.eq("pay_type", 2);
//        支付状态：1-未支付 2-已支付
        queryWrapper.eq("pay_status", 2);

        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        } else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = baseMapper.selectById(payReimburseVO.getId());
        payReimburseEntity.setPayInfoList(BeanMapper.mapList(payReimburseVO.getPayInfoList(), PayInfoEntity.class));
        super.saveOrUpdate(payReimburseEntity, false);
        //推送数据
        costPush(payReimburseEntity);
        return CommonResponse.success(BeanMapper.map(payReimburseEntity, PayReimburseVO.class));
    }

    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        logger.info("推送开始:{}", JSONObject.toJSONString(payReimburseEntity.getId()));

        if ("0".equals(payReimburseEntity.getDependOnProject())) {
            return;
        }

        boolean newRelationFlag = true;

        // 1、删除成本中心之前的数据
        List<PayInfoEntity> payInfoList = payReimburseEntity.getPayInfoList();
        costDetailApi.deleteSubject(payReimburseEntity.getId());

        if (CollectionUtils.isNotEmpty(payInfoList)) {
            for (PayInfoEntity payInfoEntity : payInfoList) {
                if (payInfoEntity.getSubjectId() == null) {
                    newRelationFlag = false;
                    break;
                }
            }
        }

        // 推送成本
        saveCost(payReimburseEntity);

        //更新是否关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(PayReimburseEntity::getId, payReimburseEntity.getId());
        updateWrapper.set(PayReimburseEntity::getRelationFlag, newRelationFlag ? "1" : "0");//(1:是，0：否)
        super.update(updateWrapper);


    }

    private void saveCost(PayReimburseEntity entity) {

        logger.info("推送转换:{}", JSON.toJSONString(entity.getId()));

        // 明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<PayInfoEntity> payInfoList = entity.getPayInfoList();
        if (CollectionUtils.isNotEmpty(payInfoList)) {
            BigDecimal payMny = entity.getPayMny();
            BigDecimal applyMny = entity.getApplyMny();
            BigDecimal payedMny = BigDecimal.ZERO;
            // 是否是部分支付
            boolean partPayFlag = ComputeUtil.isLessThan(payMny, applyMny);
            int i = 0;
            for (PayInfoEntity payInfoEntity : payInfoList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(payInfoEntity.getSubjectId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(payInfoEntity.getId());
                i++;
                if (partPayFlag) {
                    // 部分支付的话按申请金额占比拆分
                    if (i == payInfoList.size()) {
                        BigDecimal surPayMny = ComputeUtil.safeSub(payMny, payedMny);
                        costDetailVO.setHappenTaxMny(surPayMny);
                        costDetailVO.setHappenMny(surPayMny);
                    } else {
                        BigDecimal feeTaxMny = payInfoEntity.getFeeTaxMny();
                        BigDecimal ratio = ComputeUtil.safeDiv(feeTaxMny, applyMny);
                        BigDecimal happenTaxMny = ComputeUtil.scaleTwo(ComputeUtil.safeMultiply(ratio, payMny));
                        costDetailVO.setHappenTaxMny(happenTaxMny);
                        costDetailVO.setHappenMny(happenTaxMny);
                        payedMny = ComputeUtil.safeAdd(payedMny, happenTaxMny);
                    }
                } else {
                    costDetailVO.setHappenTaxMny(payInfoEntity.getFeeTaxMny());
                    costDetailVO.setHappenMny(payInfoEntity.getFeeTaxMny());
                }

                costDetailVO.setHappenDate(payInfoEntity.getFeeHappenDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
                costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate=LocalDate.now();
                if (ObjectUtil.isNotNull(entity.getApplyTime())){
                     settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                }else {
                    settlementDate = entity.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                }
                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
                costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
                costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
                costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
                costDetailVO.setSourceBillName("费用报销"); // 来源单据名称 说明：材料验收单
                costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/reimbursePro/reimburseProCard?id=" + entity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }


//        CostDetailVO costDetailVO = new CostDetailVO();
//        costDetailVO.setSubjectId(entity.getSubjectId());
//        costDetailVO.setSourceId(entity.getId());
//        costDetailVO.setSourceDetailId(entity.getId());
//        costDetailVO.setHappenTaxMny(entity.getPayMny());
//        costDetailVO.setHappenMny(entity.getPayMny());
//        costDetailVO.setHappenDate(entity.getApplyTime());
//        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
//        costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
//        costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
//        costDetailVO.setProjectId(entity.getProjectId());
//
//        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
//        LocalDate settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
//        costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
//        costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
//        costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
//        costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
//        costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
//        costDetailVO.setSourceBillName("费用报销"); // 来源单据名称 说明：材料验收单
//        costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/reimburse?id=" + entity.getId());
//        costDetailVOList.add(costDetailVO);
        // 推送至成本中心
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
//            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送返回结果:{}", JSON.toJSONString(stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    /**
     * 自动生成编码
     * @param entity
     */
    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<PayReimburseEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, entity.getBillCode());
        lambda.eq(PayReimburseEntity::getTenantId, tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0, PayReimburseEntity::getId, entity.getId());
        List<PayReimburseEntity> entityList = super.list(lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }

    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PayReimburseEntity::getId, id);
        updateWrapper.set(PayReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //页面跳转携带的orgId 没用使用本下
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().remove("createUserCode");
        }
        if (param.getParams().containsKey("projectId")) {
            param.getParams().remove("createUserCode");
        }

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("a.id");
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id", new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.groupBy("a.id");
        List<PayReimburseVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    /**
     *  报销单参照
     * @param page
     * @param wrapper
     * @return
     */
    @Override
    public List<PayReimburseVO> queryReferData(Page<PayReimburseVO> page, QueryWrapper wrapper) {
        return baseMapper.queryReferData(page, wrapper);
    }

    @Override
    public CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject) {
        String lastMonthLastDayOfPreviousYear = EJCDateUtil.format(new Date(), "yyyy") + "-12-31";
        String firstDayOfCurrentYear = EJCDateUtil.getFirstDayOfCurrentYear(EJCDateUtil.DATE);
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        } else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        QueryWrapper<PayReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),count_share_mny,0)),0) AS countShareMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny");
        queryWrapper.eq("depend_on_project", dependOnProject);
        queryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds), "org_id", orgIds);
        queryWrapper.between("apply_time", firstDayOfCurrentYear, lastMonthLastDayOfPreviousYear);
        PayReimburseEntity one = baseMapper.selectOne(queryWrapper);
        PayReimburseStatisticsVO payReimburseStatisticsVO = new PayReimburseStatisticsVO();
        payReimburseStatisticsVO.setThisYearApplyMny(one.getApplyMny());
        payReimburseStatisticsVO.setThisYearPayMny(one.getPayMny());
        payReimburseStatisticsVO.setThisYearOrgShareMny(one.getCountShareMny());
        payReimburseStatisticsVO.setThisYearInvoiceMny(one.getInvoiceMny());
        String month = EJCDateUtil.getCurrentDay(EJCDateUtil.MONTH);
        String startMonth = month + "-" + "01";
        String endMonth = month + "-" + "31";
        QueryWrapper<PayReimburseEntity> thisMonthQueryWrapper = new QueryWrapper<>();
        thisMonthQueryWrapper.select("IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),count_share_mny,0)),0) AS countShareMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny");
        thisMonthQueryWrapper.eq("depend_on_project", dependOnProject);
        thisMonthQueryWrapper.in("bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        thisMonthQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds), "org_id", orgIds);
        thisMonthQueryWrapper.between("apply_time", startMonth, endMonth);
        PayReimburseEntity thisMonthInfo = baseMapper.selectOne(thisMonthQueryWrapper);
        payReimburseStatisticsVO.setThisMonthApplyMny(thisMonthInfo.getApplyMny());
        payReimburseStatisticsVO.setThisMonthPayMny(thisMonthInfo.getPayMny());
        payReimburseStatisticsVO.setThisMonthOrgShareMny(thisMonthInfo.getCountShareMny());
        payReimburseStatisticsVO.setThisMonthInvoiceMny(thisMonthInfo.getInvoiceMny());
        return CommonResponse.success("获取报销信息成功！", payReimburseStatisticsVO);
    }

    @Override
    public IPage<PayReimburseStatisticsVO> payReimburseStatisticsList(Page<PayReimburseStatisticsVO> page, QueryWrapper wrapper, String dependOnProject) {
        return baseMapper.payReimburseStatisticsList(page, wrapper, dependOnProject);
    }

    @Override
    public List<PayReimburseStatisticsVO> payReimburseStatisticsDetailList(Long projectId, Long orgId, QueryWrapper wrapper) {
        return baseMapper.payReimburseStatisticsDetailList(projectId, orgId, wrapper);
    }

    @Override
    public BigDecimal totalBudgetMny(PayReimburseVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
//      费用报销(是否项目=是)【本期申请金额】合计值
        QueryWrapper<PayReimburseEntity> reimburseQuery = new QueryWrapper<>();
        reimburseQuery.eq("project_Id", vo.getProjectId());
        reimburseQuery.eq("depend_on_project", 1);
        if (vo.getId() != null) {
            reimburseQuery.ne("id", vo.getId());
        }
        if (vo.getApplyMny() != null) {
            applyMny = applyMny.add(vo.getApplyMny());
        }
        reimburseQuery.select("sum(apply_mny) as applyMny");
        PayReimburseEntity payReimburseEntity = super.getOne(reimburseQuery);
        if (payReimburseEntity != null && null != payReimburseEntity.getApplyMny() && !"0".equals(payReimburseEntity.getApplyMny())) {
            applyMny = applyMny.add(payReimburseEntity.getApplyMny());
        }
        logger.info("applyMny:{}", applyMny);
        return applyMny;
    }

    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *           【项目可用资金】控制项目【申请金额	】
     *
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckSpreadVO checkBudgetParams(PayReimburseVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (vo.getCheckExceedFlag() == null) {
            //获取 预算间接费总金额
            BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
            requestVo.setProjectId(vo.getProjectId());
            requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
            CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
            logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
            if (!res.isSuccess()) {
                throw new BusinessException("网络错误" + res.getMsg());
            }
            // 没有预算不控制，预算不包含不控制
            if (null != res.getData()) {
                BudgetProjectProQuantityAndMnyVO data = res.getData();
                //预算间接费总金额
                BigDecimal budgetTaxMny = data.getIndirectionTaxMny() == null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);

                if (!response.isSuccess()) {
                    throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    BigDecimal totalContractMny = totalBudgetMny(vo);
                    //获取其他三项金额
                    CommonResponse<BigDecimal> bigDecimalCommonResponse = otherContractApi.budgetControlTotal(vo.getProjectId());
                    logger.info("预算间接费 其他合同总金额 返回内容:{}", JSONObject.toJSONString(bigDecimalCommonResponse));
                    if (!bigDecimalCommonResponse.isSuccess()) {
                        throw new BusinessException(bigDecimalCommonResponse.getMsg());
                    }
                    totalContractMny = totalContractMny.add(bigDecimalCommonResponse.getData());
                    PaySporadicVO paySporadic = new PaySporadicVO();
                    paySporadic.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(paySporadicService.totalBudgetMny(paySporadic));
                    LoadReimburseVO loadReimburse = new LoadReimburseVO();
                    loadReimburse.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(loadReimburseService.totalBudgetMny(loadReimburse));
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                            BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                            //备用金报销总金额
                            logger.info("备用金报销总金额:{} 间接费用:{}", JSONObject.toJSONString(totalContractMny), JSONObject.toJSONString(budgetTaxMnyResult));
                            // 【预算间接费总金额】控 【实际间接费总金额】
                            if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                                // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                                BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                                paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                                paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该项目实际间接费总金额：")
                                        .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                        .append("元， 预算间接费总金额 * ")
                                        .append(roleValue).append("%：")
                                        .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                        .append("元，超出金额：")
                                        .append(over.setScale(2, RoundingMode.HALF_UP))
                                        .append("元。");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }

                    }
                }
            }
            CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId);
            if (!response1.isSuccess()) {
                logger.info(response1.getMsg());
                throw new BusinessException("获取控制参数失败");
            }
            List<BillParamVO> billParamVOS1 = response1.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS1)) {
                for (BillParamVO billParamVO : billParamVOS1) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal surplusApplyMny = ComputeUtil.safeMultiply(roleValue.divide(BigDecimal.valueOf(100)),vo.getProSurplusApplyMny());
                    BigDecimal payMny=vo.getApplyMny();
                    if (ComputeUtil.isGreaterThan(payMny,surplusApplyMny)) {
                        ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                        paramsCheckDsVO.setWarnItem("付款申请额超项目可用资金");
                        paramsCheckDsVO.setWarnName("本期申请金额大于剩余可申请金额");
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次申请金额：").append(payMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元，剩余可申请金额*").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP)).append("%:").append(surplusApplyMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：").append(payMny.subtract(surplusApplyMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        //reimburseMmy 报销费用=付款申请中的报销费用+备用金报销
        // 管理费
        BigDecimal costbudgetMny = BigDecimal.ZERO;
        List<Long> projectIds = new ArrayList<>();
        projectIds.add(vo.getProjectId());
        BigDecimal payReimburseMny = BigDecimal.ZERO;
        BigDecimal loadReimburseMny = BigDecimal.ZERO;
        CommonResponse<List<ProjectReimburseVO>> projectReimburse = payContractApi.getProjectReimburse(projectIds);
        CommonResponse<List<SettlementVO>> settleMny = iSettlementApi.getSettleMny(projectIds);
       /* CommonResponse<BudgetTemVO> budget = iBudgetPlanApi.getBudget(vo.getProjectId());
        if (projectReimburse.isSuccess() && null != projectReimburse.getData() && projectReimburse.getData().size() > 0) {
            payReimburseMny = projectReimburse.getData().get(0).getPayReimburseMny();
            loadReimburseMny = projectReimburse.getData().get(0).getLoadReimburseMny();
        }
        if (budget.isSuccess() && null != budget.getData()) {
            costbudgetMny = budget.getData().getManageMny();
        }*/
        //reimburseMmy 报销费用=付款申请中的报销费用+备用金报销
        BigDecimal reimburseMmy = ComputeUtil.safeAdd(payReimburseMny, loadReimburseMny, vo.getApplyMny());
        //manageMmy  管理费
        BigDecimal manageMmy = costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);


        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getApplyMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }


        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        BigDecimal fybx = baseMapper.fetchSjzcje(projectId, id);
        BigDecimal lx = paySporadicMapper.fetchSjzcje(projectId, null);
        BigDecimal yj = loadReimburseMapper.fetchSjzcje(projectId, null);
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }


    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    /**
     * 付款关闭
     *
     * @param payapplyId 付款申请id
     */
    @Override
    public void closePayment(Long payapplyId) {
        if(payapplyId != null){
            PayReimburseEntity entity = super.selectById(payapplyId);
            LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayReimburseEntity::getId, payapplyId);
            // 【本期申请金额】修改为【已支付金额】
            updateWrapper.set(PayReimburseEntity::getApplyMnyBeforeClose, entity.getApplyMny());
            updateWrapper.set(PayReimburseEntity::getApplyMny, entity.getPayMny());
            updateWrapper.set(PayReimburseEntity::getApplyMnyCn,NumberToCN.number2CN(entity.getPayMny()));
            // 付款关闭确认后 【关闭状态】=已关闭；【关闭人】=当前登录人；【关闭时间】=当前时间；
            updateWrapper.set(PayReimburseEntity::getCloseState, "已关闭");
            updateWrapper.set(PayReimburseEntity::getCloseFlag, Boolean.TRUE);
            updateWrapper.set(PayReimburseEntity::getCloseTime, DateUtil.getCurrentDay(DateUtil.DATE_TIME));
            updateWrapper.set(PayReimburseEntity::getCloseUser, sessionManager.getUserContext().getUserName());
            super.update(updateWrapper);
        }

    }

    /**
     * 付款退回
     *
     * @param vo 付款申请记录
     *
     * @return {@link PayRecordVO}
     */
    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        Long payapplyId = vo.getPayapplyId();
        if(payapplyId != null){
            PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
            // 增加一个负数的付款记录单；
            entity.setThisPayMny(ComputeUtil.convertToMinusNumber(entity.getThisPayMny()));
            PayReimburseEntity reimburse = this.selectById(payapplyId);
            entity.setBillCode(reimburse.getBillCode());// 单据编号
            entity.setProjectId(reimburse.getProjectId());// 项目
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());// 组织
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());// 申请人
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());// 申请时间
            entity.setApplyMny(reimburse.getApplyMny());// 申请金额
            entity.setFeeType(reimburse.getFeeType());;//付款类型
            entity.setExplanation(reimburse.getPayReason()); // 付款事由
            payRecordService.saveOrUpdate(entity);

            // 退回后回写申请单
            // 【已付款金额】修改为【已付款金额】-【退回金额】 即：【已付款金额】=【已付款金额】+ （-【退回金额】）
            BigDecimal payMny = MathUtil.safeAdd(reimburse.getPayMny(), entity.getThisPayMny());
            LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayReimburseEntity::getId, payapplyId);
            updateWrapper.set(PayReimburseEntity::getPayMny, payMny);
            super.update(updateWrapper);
            // 付款关闭
            if (vo.getClosed()) {
               this.closePayment(payapplyId);
            }
            // 付款退回后按新的支付金额重新推送成本
            reimburse.setPayMny(payMny);
            costPush(reimburse);

            BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.付款退还, "费用报销付款退回");
            bankFlowVO.setTradeOrgId(reimburse.getApplyUserId());
            bankFlowVO.setTradeOrgName(reimburse.getApplyUserName());
            bankFlowVO.setOrgId(entity.getOrgId());
            bankFlowVO.setOrgName(entity.getOrgName());
            bankFlowVO.setSourceId(entity.getId());
            bankFlowVO.setBillId(entity.getPayapplyId());
            bankFlowVO.setBillCode(entity.getBillCode());
            bankFlowVO.setBillDate(entity.getConfirmTime());
            bankFlowVO.setAccountId(entity.getAccountId());
            bankFlowVO.setAccountName(entity.getAccountName());
            bankFlowVO.setAccountNum(entity.getAccountNum());
            bankFlowVO.setAccountBank(entity.getAccountBank());
            bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
            bankFlowVO.setMemo(entity.getMemo());
            bankFlowService.saveFlowVO(bankFlowVO);
        }
        return vo;
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null);
    }

    /**
     * @description: 更新被分摊的组织费用报销单的分摊金额
     * @date: 2024/1/17
     * @param shareId 分摊单id
     * @param addFlag
     */
    @Override
    public void updateShareMoneyByShareId(Long shareId, boolean addFlag) {
        ReimburseShareEntity reimburseShareEntity = reimburseShareService.selectById(shareId);
        if (reimburseShareEntity != null) {
            List<ReimburseShareCostDetailEntity> reimburseShareCostDetailList = reimburseShareEntity.getReimburseShareCostDetailList();
            List<Long> orgReimburseIds = reimburseShareCostDetailList.stream().map(ReimburseShareCostDetailEntity::getReimburseId).collect(Collectors.toList());
            // 获取组织报销累计分摊合计，不包含当前单据
            Map<Long, BigDecimal> sumOrgReimburseMnyMap = reimburseShareService.getSumOrgReimburseMny(shareId, orgReimburseIds);
            if (addFlag) {
                for (ReimburseShareCostDetailEntity reimburseShareCostDetailEntity : reimburseShareCostDetailList) {
                    Long reimburseId = reimburseShareCostDetailEntity.getReimburseId();
                    BigDecimal sumReimburseShareMny = sumOrgReimburseMnyMap.get(reimburseId);
                    BigDecimal bodyReimburseShareMny = reimburseShareCostDetailEntity.getBodyReimburseShareMny();
                    sumReimburseShareMny = ComputeUtil.safeAdd(sumReimburseShareMny, bodyReimburseShareMny);
                    sumOrgReimburseMnyMap.put(reimburseId, sumReimburseShareMny);
                }
            }
            for (Long reimburseId : orgReimburseIds) {
                //更新组织费用报销单已分摊费用
                BigDecimal countShareMny = sumOrgReimburseMnyMap.get(reimburseId);
                LambdaUpdateWrapper<PayReimburseEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.eq(PayReimburseEntity::getId, reimburseId);
                wrapper.set(PayReimburseEntity::getCountShareMny, countShareMny);
                this.update(wrapper);
            }
        }
    }

    @Override
    public BigDecimal queryFeeMny(Long projectId, Long feeTypeId) {
        LambdaQueryWrapper<PayReimburseEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(PayReimburseEntity::getProjectId, projectId);
        queryWrapper.in(PayReimburseEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PayReimburseEntity> entities = list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            List<Long> idList = entities.stream().map(PayReimburseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<PayInfoEntity> query = Wrappers.lambdaQuery();
            query.eq(PayInfoEntity::getFeeType, feeTypeId);
            query.in(PayInfoEntity::getPayapplyId, idList);
            List<PayInfoEntity> infoEntities = payInfoService.list(query);
            if (CollectionUtils.isNotEmpty(infoEntities)) {
                return infoEntities.stream().map(PayInfoEntity::getFeeTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return BigDecimal.ZERO;
    }
}
