/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="LoadReimburseService")
public class LoadReimburseServiceImpl
extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity>
implements ILoadReimburseService {
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IOtherContractApi otherContractApi;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IloadInvoiceService loadInvoiceService;
    @Autowired
    private PayContractApi payContractApi;
    @Autowired
    private ISettlementApi iSettlementApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private PayReimburseMapper payReimburseMapper;
    @Autowired
    private PaySporadicMapper paySporadicMapper;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadReimburseVO && com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)loadReimburseVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadReimburseVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LoadReimburseEntity entity = (LoadReimburseEntity)((Object)BeanMapper.map((Object)loadReimburseVO, LoadReimburseEntity.class));
        BigDecimal surplusMny = this.loadApplyService.querySurplusMny(entity.getId(), null, entity.getOrgId(), 0, String.valueOf(entity.getApplyEmployeeId()));
        BigDecimal reimburseMny = entity.getReimburseMny();
        if (reimburseMny.compareTo(surplusMny) > 0) {
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("\u672c\u6b21\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u53ef\u62a5\u9500\u91d1\u989d\u3010" + df1.format(surplusMny) + "\u3011\u5143");
        }
        List voList = loadReimburseVO.getInvoiceVOList();
        CommonResponse<String> usedMnyRes = this.loadInvoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate((Object)entity, false);
        return (LoadReimburseVO)BeanMapper.map((Object)((Object)entity), LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(reimburse_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"depend_on_project", (Object)"1");
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = (LoadReimburseEntity)((Object)((LoadReimburseMapper)this.baseMapper).selectById(loadReimburseVO.getId()));
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate((Object)loadReimburseEntity, false);
        this.costPush(loadReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)loadReimburseEntity), LoadReimburseVO.class));
    }

    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())) {
            return;
        }
        boolean newRelationFlag = true;
        Long subjectId = loadReimburseEntity.getSubjectId();
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{loadReimburseEntity.getId()});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        if (oldRelationFlag.equals("1")) {
            if (newRelationFlag) {
                this.saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag) {
                this.costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        if (oldRelationFlag.equals("0")) {
            this.saveCost(loadReimburseEntity);
        }
    }

    private void saveCost(LoadReimburseEntity entity) {
        this.logger.info("\u63a8\u9001\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)entity.getId()));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getSubjectId());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getReimburseMny());
        costDetailVO.setHappenMny(entity.getReimburseMny());
        costDetailVO.setHappenDate(entity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(entity.getProjectId());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
        costDetailVO.setPeriod(settlementDate.format(df));
        costDetailVO.setShareFlag(Integer.valueOf(0));
        costDetailVO.setSourceBillCode(entity.getBillCode());
        costDetailVO.setSourceBillName("\u5907\u7528\u91d1\u8d39\u7528\u62a5\u9500");
        costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/loadList/loadReimburseCard?id=" + entity.getId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public BigDecimal totalBudgetMny(LoadReimburseVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
        QueryWrapper loadReimburseQuery = new QueryWrapper();
        loadReimburseQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        loadReimburseQuery.eq((Object)"depend_on_project", (Object)1);
        if (vo.getId() != null) {
            loadReimburseQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getReimburseMny() != null) {
            applyMny = applyMny.add(vo.getReimburseMny());
        }
        loadReimburseQuery.select(new String[]{"sum(reimburse_mny) as reimburseMny"});
        LoadReimburseEntity loadReimburseEntity = (LoadReimburseEntity)((Object)super.getOne((Wrapper)loadReimburseQuery));
        if (loadReimburseEntity != null && null != loadReimburseEntity.getReimburseMny() && !"0".equals(loadReimburseEntity.getReimburseMny())) {
            applyMny = applyMny.add(loadReimburseEntity.getReimburseMny());
        }
        return applyMny;
    }

    @Override
    public ParamsCheckSpreadVO checkBudgetParams(LoadReimburseVO vo) {
        List billParamVOS;
        CommonResponse sghtkzc;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsSpreadVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (vo.getCheckExceedFlag() == null) {
            BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
            requestVo.setProjectId(vo.getProjectId());
            requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
            CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
            this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
            }
            if (null != res.getData()) {
                BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
                BigDecimal budgetTaxMny = data.getIndirectionTaxMny() == null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
                if (!response.isSuccess()) {
                    throw new BusinessException(" \u3010\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS2 = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                    BigDecimal totalContractMny = this.totalBudgetMny(vo);
                    CommonResponse bigDecimalCommonResponse = this.otherContractApi.budgetControlTotal(vo.getProjectId());
                    this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39 \u5176\u4ed6\u5408\u540c\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)bigDecimalCommonResponse));
                    if (!bigDecimalCommonResponse.isSuccess()) {
                        throw new BusinessException(bigDecimalCommonResponse.getMsg());
                    }
                    totalContractMny = totalContractMny.add((BigDecimal)bigDecimalCommonResponse.getData());
                    PayReimburseVO payReimburse = new PayReimburseVO();
                    payReimburse.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(this.payReimburseService.totalBudgetMny(payReimburse));
                    PaySporadicVO paySporadic = new PaySporadicVO();
                    paySporadic.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(this.paySporadicService.totalBudgetMny(paySporadic));
                    for (BillParamVO billParamVO : billParamVOS2) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d:{},\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d:{}", (Object)JSONObject.toJSONString((Object)totalContractMny), (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult));
                        if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                        BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                        ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u8d85\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        LoadReimburseServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
        }
        if ((sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, InvocationInfoProxy.getOrgId())).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getReimburseMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                LoadReimburseServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        BigDecimal fybx = this.payReimburseMapper.fetchSjzcje(projectId, null);
        BigDecimal lx = this.paySporadicMapper.fetchSjzcje(projectId, null);
        BigDecimal yj = ((LoadReimburseMapper)this.baseMapper).fetchSjzcje(projectId, id);
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LoadReimburseMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }
}

