package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.*;

/**
 * 扣款单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_deduction")
public class DeductionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="subject_name")
    private java.lang.String subjectName; // 主题
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="penalty_money")
    private java.math.BigDecimal penaltyMoney; // 扣款金额
    @TableField(value="deal_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dealDate; // 办理日期
    @TableField(value="deal_person_id")
    private java.lang.Long dealPersonId; // 经办人id
    @TableField(value="deal_person_name")
    private java.lang.String dealPersonName; // 经办人
    @TableField(value="total_penalty_money")
    private java.math.BigDecimal totalPenaltyMoney; // 累计扣款金额
    @TableField(value="deduction_reason")
    private java.lang.String deductionReason; // 扣款事由
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织id
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="cash_id")
    private java.lang.Long cashId; // 备用金id
    @TableField(value="cash_bill_code")
    private java.lang.String cashBillCode; // 备用金的申请编号
    @TableField(value="cash_apply_money")
    private java.math.BigDecimal cashApplyMoney; // 用款金额
    @TableField(value="cash_surplus_money")
    private java.math.BigDecimal cashSurplusMoney; // 剩余借款
    @TableField(value="cash_apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date cashApplyTime; // 申请时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="cash_use_time")
    private java.util.Date cashUseTime; // 用款时间
    @TableField(value="is_settle")
    private java.lang.Integer isSettle; // 是否计入结算,1计入计算，2不进入计算
    @TableField(value="cash_apply_employee_name")
    private java.lang.String cashApplyEmployeeName; // 申请人名称
    @TableField(value="cash_aply_memo")
    private java.lang.String cashAplyMemo; // 申请原因
    @TableField(value="is_use")
    private java.lang.Integer isUse; // 扣款是否使用
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名字
    @TableField(value="supplier_code")
    private java.lang.String supplierCode; // 供应商的code
    @TableField(value="supplier_total_penalty_money")
    private java.math.BigDecimal supplierTotalPenaltyMoney; // 供应商总罚款金额

    @TableField(value="contract_type")
    private String contractType; // 合同类型sub分包material物资other其他
    @TableField(value="contract_id")
    private Long contractId; // 合同名称
    @TableField(value="contract_name")
    private String contractName; // 合同名称

    @TableField(value = "depend_on_project")
    private String dependOnProject;
    @TableField(value="settle_flag")
    private Integer settleFlag; // 是否被结算引用：0、否； 1、是

    // 2025-08-14 新增
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_manager")
    private String projectManager; // 项目经理id
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理name
    @TableField(value="project_director")
    private String projectDirector; // 项目总监id
    @TableField(value="project_director_name")
    private String projectDirectorName; // 项目总监name
    @TableField(value="middleground_id")
    private String middlegroundId; // 工程中台id
    @TableField(value="middleground_name")
    private String middlegroundName; // 工程中台name
    @TableField(value="file_date")
    private Date fileDate; // 文件日期
    @TableField(value="management_type")
    private String managementType; // 管理类别
    @TableField(value="handler_person")
    private String handlerPerson; // 办理人员
    @TableField(value="team_confirm_flag")
    private String teamConfirmFlag; // 班组是否确认
    @TableField(value="matter_subject")
    private String matterSubject; // 事项主题

    @TableField(exist=false)
    @SubEntity(serviceName="deductionDeductionService")
    private List<DeductionDeductionEntity> deductionDeductionList = new ArrayList<>(); // 扣款单-扣款详情


    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 主题
     */
    public java.lang.String getSubjectName() {
        return subjectName;
    }

    /**
     * 主题
     */
    public void setSubjectName(java.lang.String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 扣款金额
     */
    public java.math.BigDecimal getPenaltyMoney() {
        return penaltyMoney;
    }

    /**
     * 扣款金额
     */
    public void setPenaltyMoney(java.math.BigDecimal penaltyMoney) {
        this.penaltyMoney = penaltyMoney;
    }
    /**
     * 办理日期
     */
    public java.util.Date getDealDate() {
        return dealDate;
    }

    /**
     * 办理日期
     */
    public void setDealDate(java.util.Date dealDate) {
        this.dealDate = dealDate;
    }
    /**
     * 经办人id
     */
    public java.lang.Long getDealpersonId() {
        return dealPersonId;
    }

    public Long getDealPersonId() {
        return dealPersonId;
    }

    /**
     * 经办人id
     */


    public void setDealPersonId(Long dealPersonId) {
        this.dealPersonId = dealPersonId;
    }
    /**
     * 经办人
     */
    public String getDealPersonName() {
        return dealPersonName;
    }

    public void setDealPersonName(String dealPersonName) {
        this.dealPersonName = dealPersonName;
    }
    /**
     * 经办人
     */

    /**
     * 累计扣款金额
     */
    public java.math.BigDecimal getTotalPenaltyMoney() {
        return totalPenaltyMoney;
    }

    /**
     * 累计扣款金额
     */
    public void setTotalPenaltyMoney(java.math.BigDecimal totalPenaltyMoney) {
        this.totalPenaltyMoney = totalPenaltyMoney;
    }
    /**
     * 扣款事由
     */
    public java.lang.String getDeductionReason() {
        return deductionReason;
    }

    /**
     * 扣款事由
     */
    public void setDeductionReason(java.lang.String deductionReason) {
        this.deductionReason = deductionReason;
    }
    /**
     * 组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 备用金id
     */
    public java.lang.Long getCashId() {
        return cashId;
    }

    /**
     * 备用金id
     */
    public void setCashId(java.lang.Long cashId) {
        this.cashId = cashId;
    }
    /**
     * 备用金的申请编号
     */
    public java.lang.String getCashBillCode() {
        return cashBillCode;
    }

    /**
     * 备用金的申请编号
     */
    public void setCashBillCode(java.lang.String cashBillCode) {
        this.cashBillCode = cashBillCode;
    }
    /**
     * 用款金额
     */
    public java.math.BigDecimal getCashApplyMoney() {
        return cashApplyMoney;
    }

    /**
     * 用款金额
     */
    public void setCashApplyMoney(java.math.BigDecimal cashApplyMoney) {
        this.cashApplyMoney = cashApplyMoney;
    }
    /**
     * 剩余借款
     */
    public java.math.BigDecimal getCashSurplusMoney() {
        return cashSurplusMoney;
    }

    /**
     * 剩余借款
     */
    public void setCashSurplusMoney(java.math.BigDecimal cashSurplusMoney) {
        this.cashSurplusMoney = cashSurplusMoney;
    }
    /**
     * 申请时间
     */
    public java.util.Date getCashApplyTime() {
        return cashApplyTime;
    }

    /**
     * 申请时间
     */
    public void setCashApplyTime(java.util.Date cashApplyTime) {
        this.cashApplyTime = cashApplyTime;
    }
    /**
     * 用款时间
     */
    public java.util.Date getCashUseTime() {
        return cashUseTime;
    }

    /**
     * 用款时间
     */
    public void setCashUseTime(java.util.Date cashUseTime) {
        this.cashUseTime = cashUseTime;
    }
    /**
     * 是否计入结算,1计入计算，2不进入计算
     */
    public java.lang.Integer getIsSettle() {
        return isSettle;
    }

    /**
     * 是否计入结算,1计入计算，2不进入计算
     */
    public void setIsSettle(java.lang.Integer isSettle) {
        this.isSettle = isSettle;
    }
    /**
     * 申请人名称
     */
    public java.lang.String getCashApplyEmployeeName() {
        return cashApplyEmployeeName;
    }

    /**
     * 申请人名称
     */
    public void setCashApplyEmployeeName(java.lang.String cashApplyEmployeeName) {
        this.cashApplyEmployeeName = cashApplyEmployeeName;
    }
    /**
     * 申请原因
     */
    public java.lang.String getCashAplyMemo() {
        return cashAplyMemo;
    }

    /**
     * 申请原因
     */
    public void setCashAplyMemo(java.lang.String cashAplyMemo) {
        this.cashAplyMemo = cashAplyMemo;
    }
    /**
     * 扣款是否使用
     */
    public java.lang.Integer getIsUse() {
        return isUse;
    }

    /**
     * 扣款是否使用
     */
    public void setIsUse(java.lang.Integer isUse) {
        this.isUse = isUse;
    }
    /**
     * 供应商id
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名字
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名字
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商的code
     */
    public java.lang.String getSupplierCode() {
        return supplierCode;
    }

    /**
     * 供应商的code
     */
    public void setSupplierCode(java.lang.String supplierCode) {
        this.supplierCode = supplierCode;
    }
    /**
     * 供应商总罚款金额
     */
    public java.math.BigDecimal getSupplierTotalPenaltyMoney() {
        return supplierTotalPenaltyMoney;
    }

    /**
     * 供应商总罚款金额
     */
    public void setSupplierTotalPenaltyMoney(java.math.BigDecimal supplierTotalPenaltyMoney) {
        this.supplierTotalPenaltyMoney = supplierTotalPenaltyMoney;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getProjectDirector() {
        return projectDirector;
    }

    public void setProjectDirector(String projectDirector) {
        this.projectDirector = projectDirector;
    }
    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }
    public String getMiddlegroundId() {
        return middlegroundId;
    }

    public void setMiddlegroundId(String middlegroundId) {
        this.middlegroundId = middlegroundId;
    }
    public String getMiddlegroundName() {
        return middlegroundName;
    }

    public void setMiddlegroundName(String middlegroundName) {
        this.middlegroundName = middlegroundName;
    }
    public Date getFileDate() {
        return fileDate;
    }

    public void setFileDate(Date fileDate) {
        this.fileDate = fileDate;
    }
    public String getManagementType() {
        return managementType;
    }

    public void setManagementType(String managementType) {
        this.managementType = managementType;
    }
    public String getHandlerPerson() {
        return handlerPerson;
    }

    public void setHandlerPerson(String handlerPerson) {
        this.handlerPerson = handlerPerson;
    }
    public String getTeamConfirmFlag() {
        return teamConfirmFlag;
    }

    public void setTeamConfirmFlag(String teamConfirmFlag) {
        this.teamConfirmFlag = teamConfirmFlag;
    }
    public String getMatterSubject() {
        return matterSubject;
    }

    public void setMatterSubject(String matterSubject) {
        this.matterSubject = matterSubject;
    }


    public List<DeductionDeductionEntity> getDeductionDeductionList() {
        return deductionDeductionList;
    }

    public void setDeductionDeductionList(List<DeductionDeductionEntity> deductionDeductionList) {
        this.deductionDeductionList = deductionDeductionList;
    }
    
}
