package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BidBondDealEntity;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.BidBondBackEntity;
import com.ejianc.business.finance.service.IBidBondBackService;
import com.ejianc.business.finance.vo.BidBondBackVO;

/**
 * 投标保证金退还
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("bidBondBack")
public class BidBondBackController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BIDBOND_DEL";//此处需要根据实际修改

    @Autowired
    private IBidBondBackService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBidBondService bidBondService;

    @Autowired
    private IBankFlowService bankFlowService;

    @Autowired
    private IBankAcctService bankAcctService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BidBondBackVO> saveOrUpdate(@RequestBody BidBondBackVO saveOrUpdateVO) {
    	BidBondBackEntity entity = BeanMapper.map(saveOrUpdateVO, BidBondBackEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
    	    if(saveOrUpdateVO.getBillCode() != null){
                LambdaQueryWrapper<BidBondBackEntity> lambda = new LambdaQueryWrapper<>();
                lambda.eq(BidBondBackEntity::getBillCode, saveOrUpdateVO.getBillCode());
                lambda.eq(BidBondBackEntity::getTenantId, InvocationInfoProxy.getTenantid());
                List<BidBondBackEntity> list = service.list(lambda);
                if(list != null && list.size() > 0 ) {
                    throw new BusinessException("存在相同编码，不允许保存!");
                }
            }else{
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
            }
        }
        Long bondId = entity.getBondId();
        BidBondEntity bidBondEntity = bidBondService.selectById(bondId);

        BigDecimal backMny = entity.getBackMny();
        UpdateWrapper<BidBondEntity> wrapper = new UpdateWrapper<>();
        wrapper.set("back_mny",backMny.add(bidBondEntity.getBackMny() == null ? BigDecimal.ZERO : bidBondEntity.getBackMny()));
        wrapper.set("backed_state", 1);
        wrapper.eq("id",bondId);
        bidBondService.update(wrapper);
        service.saveOrUpdate(entity, false);
        //==================推送收支流水
        BankAcctEntity bankAcctEntity = bankAcctService.selectById(entity.getAccountId());
        BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.投标保证金退还);
        flowVO.setBillDate(entity.getBackTime());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getBondId());
        flowVO.setReceiveMoney(entity.getBackMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(bidBondEntity.getOrgId());
        flowVO.setOrgName(bidBondEntity.getOrgName());
        if (null!=bankAcctEntity) {
            flowVO.setAccountOrgId(bankAcctEntity.getOrgId());
            flowVO.setAccountOrgName(bankAcctEntity.getOrgName());
        }
        flowVO.setAccountId(entity.getAccountId());
        flowVO.setAccountName(entity.getAccountName());
        flowVO.setAccountBank(entity.getAccountBank());
        flowVO.setAccountNum(entity.getAccountNum());

        flowVO.setTradeOrgId(bidBondEntity.getCustomerId());
        flowVO.setTradeOrgName(bidBondEntity.getCustomerName());

        flowVO.setMemo(entity.getMemo());
        bankFlowService.saveFlowVO(flowVO);
        //===============推送收支流水结束
    	BidBondBackVO vo = BeanMapper.map(entity, BidBondBackVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BidBondVO> queryDetail(Long id) {
        BidBondEntity bidBondEntity = bidBondService.selectById(id);
        LambdaQueryWrapper<BidBondBackEntity> lambda =new LambdaQueryWrapper<>();
        lambda.eq(BidBondBackEntity::getBondId, id);
        List<BidBondBackEntity> list = service.list(lambda);
        bidBondEntity.setBidBondBackList(list);
        BidBondVO vo = BeanMapper.map(bidBondEntity, BidBondVO.class);
        BigDecimal applyMny = vo.getApplyMny() == null ? BigDecimal.ZERO : vo.getApplyMny();
        BigDecimal backMny = vo.getBackMny() == null ? BigDecimal.ZERO : vo.getBackMny();
        vo.setSurplusMny(applyMny.subtract(backMny));
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidBondBackVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BidBondBackVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BidBondBackVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BidBondBackVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BidBondBackEntity> page = service.queryPage(param,false);
        IPage<BidBondBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidBondBackVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BidBondBackEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BidBondBack-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refBidBondBackData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BidBondBackVO>> refBidBondBackData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BidBondBackEntity> page = service.queryPage(param,false);
        IPage<BidBondBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BidBondBackVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
