/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.service.IPayRecordSalaryGrantService;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payRecordSalaryGrant"})
public class PayRecordSalaryGrantController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPayRecordSalaryGrantService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IProjectTeamApi projectTeamApi;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> saveOrUpdate(@RequestBody PayRecordSalaryGrantVO saveOrUpdateVO) {
        PayRecordSalaryGrantEntity entity = (PayRecordSalaryGrantEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayRecordSalaryGrantEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PayRecordSalaryGrantVO vo = (PayRecordSalaryGrantVO)BeanMapper.map((Object)((Object)entity), PayRecordSalaryGrantVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> queryDetail(Long id) {
        PayRecordSalaryGrantEntity entity = (PayRecordSalaryGrantEntity)((Object)this.service.selectById(id));
        PayRecordSalaryGrantVO vo = (PayRecordSalaryGrantVO)BeanMapper.map((Object)((Object)entity), PayRecordSalaryGrantVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordSalaryGrantVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PayRecordSalaryGrantVO> list = this.service.querySalaryGrantVOPage(wrapper, salaryMonth, (Page<PayRecordSalaryGrantVO>)page);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : list) {
                payRecordSalaryGrantVO.setBaseImgUrl(this.baseImgUrl);
            }
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayRecordSalaryGrantVO> list = this.service.querySalaryGrantVOPage(wrapper, salaryMonth, null);
        if (CollectionUtils.isNotEmpty(list)) {
            for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : list) {
                payRecordSalaryGrantVO.setBaseImgUrl(this.baseImgUrl);
                if (payRecordSalaryGrantVO.getAckFlag() == 1) {
                    payRecordSalaryGrantVO.setAckFlagName("\u5df2\u786e\u8ba4");
                    continue;
                }
                payRecordSalaryGrantVO.setAckFlagName("\u672a\u786e\u8ba4");
            }
        }
        HashMap<String, List<PayRecordSalaryGrantVO>> beans = new HashMap<String, List<PayRecordSalaryGrantVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PayRecordSalaryGrant-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPayRecordSalaryGrantData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> refPayRecordSalaryGrantData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayRecordSalaryGrantVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProjectSalaryGrantList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryProjectSalaryGranList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        String salaryMonth = null;
        Map params = param.getParams();
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        Long projectId = null;
        if (!params.containsKey("projectId")) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        projectId = Long.parseLong((String)((Parameter)params.get("projectId")).getValue());
        param.getParams().remove("projectId");
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        param.getParams().put("project_id", new Parameter("eq", (Object)projectId));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.isNotNull((Object)"worker_id");
        List<PayRecordSalaryGrantVO> list = this.service.querySalaryGrantVOPage(wrapper, salaryMonth, (Page<PayRecordSalaryGrantVO>)page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryTeamSalarySlipList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryTeamSalarySlipList(@RequestBody QueryParam param) {
        List workerIds;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        String phone = null;
        Long userId = this.sessionManager.getUserContext().getUserId();
        CommonResponse commonResponse = this.employeeApi.getById(userId);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            EmployeeVO employeeVO = (EmployeeVO)commonResponse.getData();
            phone = employeeVO.getMobilePhone();
        }
        Map params = param.getParams();
        Long projectId = null;
        if (params.containsKey("projectId")) {
            projectId = Long.parseLong(((Parameter)params.get("projectId")).getValue().toString());
            param.getParams().remove("projectId");
        }
        String salaryMonth = null;
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        CommonResponse listCommonResponse = this.projectTeamApi.queryTeamWorkerIdByPhone(phone, projectId);
        if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null && CollectionUtils.isNotEmpty((Collection)(workerIds = (List)listCommonResponse.getData()))) {
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<PayRecordSalaryGrantVO> list = this.service.queryTeamSalaryGrantList(wrapper, salaryMonth, (Page<PayRecordSalaryGrantVO>)page, workerIds);
            page.setTotal(page.getTotal());
            page.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryWorkerSalaryGranList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryWorkerSalaryGranList(@RequestBody QueryParam param) {
        List workerIds;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        Map params = param.getParams();
        String phone = null;
        if (params.containsKey("phone")) {
            phone = ((Parameter)params.get("phone")).getValue().toString();
            param.getParams().remove("phone");
        }
        String salaryMonth = null;
        if (params.containsKey("salaryMonth")) {
            salaryMonth = (String)((Parameter)params.get("salaryMonth")).getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth = split[0] + "-" + split[1];
            param.getParams().remove("salaryMonth");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        CommonResponse listCommonResponse = this.projectTeamApi.queryWorkerIdByPhone(phone);
        if (listCommonResponse.isSuccess() && listCommonResponse.getData() != null && CollectionUtils.isNotEmpty((Collection)(workerIds = (List)listCommonResponse.getData()))) {
            param.getParams().put("worker_id", new Parameter("in", (Object)workerIds));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<PayRecordSalaryGrantVO> list = this.service.querySalaryGrantVOPage(wrapper, salaryMonth, (Page<PayRecordSalaryGrantVO>)page);
            page.setTotal(page.getTotal());
            page.setRecords(list);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/ackSalary"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> ackSalary(@RequestBody PayRecordSalaryGrantVO vo) {
        PayRecordSalaryGrantEntity payRecordSalaryGrantEntity = (PayRecordSalaryGrantEntity)((Object)this.service.selectById(vo.getId()));
        LambdaUpdateWrapper salarySlipAckWrapper = new LambdaUpdateWrapper();
        salarySlipAckWrapper.eq(BaseEntity::getId, (Object)vo.getId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getAckFlag, (Object)1);
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getAckTime, (Object)new Date());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getLogonPeopleId, (Object)payRecordSalaryGrantEntity.getWorkerId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getLogonPeople, (Object)payRecordSalaryGrantEntity.getWorkerName());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getFacePhotoId, (Object)vo.getFacePhotoId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getFacePhoto, (Object)vo.getFacePhoto());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getSignPhotoId, (Object)vo.getSignPhotoId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getSignPhoto, (Object)vo.getSignPhoto());
        this.service.update((Wrapper)salarySlipAckWrapper);
        PayRecordSalaryGrantEntity entity = (PayRecordSalaryGrantEntity)((Object)this.service.selectById(vo.getId()));
        PayRecordSalaryGrantVO payRecordSalaryGrantVO = (PayRecordSalaryGrantVO)BeanMapper.map((Object)((Object)entity), PayRecordSalaryGrantVO.class);
        return CommonResponse.success((String)"\u5de5\u8d44\u53d1\u653e\u786e\u8ba4\u6210\u529f\uff01", (Object)payRecordSalaryGrantVO);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"payRecordSalaryGrant-import.xlsx", (String)"\u5de5\u8d44\u53d1\u653e\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }
}

