package com.ejianc.business.finance.service;

import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
public interface IPayInvoiceService extends IBaseService<PayInvoiceEntity> {

    /**
     * @param voList
     * @param id
     * @description: 保存编辑回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    CommonResponse<String> updateInvoiceUsedMnyBySave(List<PayInvoiceVO> voList, Long id);

    /**
     * @param ids
     * @description: 申请删除 回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    CommonResponse<String> updateInvoiceUsedMnyByDel(List<Long> ids);

    /**
     * @description: 查询使用此发票的合同付款、零星付款、费用报销列表
     *
     * @param invoiceId
     * @return {@link java.util.List<com.ejianc.business.finance.vo.PayInvoiceUseVO>}
     * @author songlx
     * @date: 2022/12/30
     */
    List<PayInvoiceUseVO> queryUseList(Long invoiceId);

    /**
     * @description: 查询使用此发票数量数据成功- 收票
     *
     * @param invoiceIds
     * @return {@link java.util.List<com.ejianc.business.finance.vo.PayInvoiceUseVO>}
     * @author songlx
     * @date: 2022/12/30
     */
    List<PayInvoiceUseVO> countUseNum(List<Long> invoiceIds);


    /**
     * @description: 查询使用此发票数量数据成功- 开票
     *
     * @param invoiceIds
     * @return {@link java.util.List<com.ejianc.business.finance.vo.PayInvoiceUseVO>}
     * @author songlx
     * @date: 2022/12/30
     */
    List<PayInvoiceUseVO> countOpenUseNum(List<Long> invoiceIds);

    /**
     * @description: 查询使用此发票(开票)的收款登记列表
     *
     * @return {@link com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.finance.vo.PayRecordVO>>}
     * @author songlx
     * @date: 2022/12/30
     */
    List<PayInvoiceUseVO> queryOpenUseList(Long invoiceId);
}
