package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public interface IPaySporadicService extends IBaseService<PaySporadicEntity> {

    PaySporadicVO insertOrUpdate(PaySporadicVO paySporadicVO);

    PaySporadicVO queryDetail(Long id);

    List<PaySporadicVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    /**
     * 统计匹配的零星材料付款申请支付金额总数（属于项目的单据）
     *
     * @param tenantId 租户Id
     * @param projectIds 项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds);

    CommonResponse<PaySporadicVO> pushCost(PaySporadicVO paySporadicVO);

    void costPush(PaySporadicEntity loadReimburseEntity);

    //成本改造
    void pullCost(Long id);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);

    /**
     *  预算控制 金额查询
     * @param vo
     * @return
     */
    BigDecimal totalBudgetMny(PaySporadicVO vo);
    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckSpreadVO checkBudgetParams(PaySporadicVO vo);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    /**
     * 关闭付款
     *
     * @param id ({
     *           applyMnyBeforeClose: 关闭前的本期申请金额
     *
     * })
     * @return
     */
    void closePayRecord(Long id);

    void returnPayRecord(PayRecordVO vo);


	BigDecimal fetchSjzcje(Long projectId);
}
