package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.ParamsCheckVO;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 借款报销
 *
 * @author generator
 *
 */
@Service("LoadReimburseService")
public class LoadReimburseServiceImpl extends BaseServiceImpl<LoadReimburseMapper, LoadReimburseEntity> implements ILoadReimburseService{
    private static final String BONDUP_BILL_CODE = "LOAD_REIMBURSE";
    //系统是否开启专业分包预算标志
    private static final String SYS_IS_PROBUDGET_CODE = "P-D76yn127";
    //预算单据管理费控制
    private static final String CHECK_PARAM_PROBUDGET_CODE = "P-V4416932";

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPayReimburseService payReimburseService;//费用报销
    @Autowired
    private IPaySporadicService paySporadicService; //零星付款申请
    @Autowired
    private IOtherContractApi otherContractApi;
//    @Autowired
//    private ILoadReimburseService loadReimburseService;//备用金
    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IloadInvoiceService loadInvoiceService;

    @Autowired
    private PayContractApi payContractApi;

    @Autowired
    private ISettlementApi iSettlementApi;


    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi orgApi;

    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private PayReimburseMapper payReimburseMapper;
    @Autowired
    private PaySporadicMapper paySporadicMapper;

    @Override
    public LoadReimburseVO insertOrUpdate(LoadReimburseVO loadReimburseVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadReimburseVO&&StringUtils.isEmpty(loadReimburseVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadReimburseVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LoadReimburseEntity entity = BeanMapper.map(loadReimburseVO, LoadReimburseEntity.class);
        BigDecimal surplusMny =  loadApplyService.querySurplusMny(entity.getId(),null,entity.getOrgId(),0, String.valueOf(entity.getApplyEmployeeId()));
        BigDecimal reimburseMny = entity.getReimburseMny();
        if(reimburseMny.compareTo(surplusMny)>0){
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("本次报销金额不能超过剩余可报销金额【"+df1.format(surplusMny)+"】元");
        }
        List<LoadInvoiceVO> voList = loadReimburseVO.getInvoiceVOList();

        CommonResponse<String> usedMnyRes = loadInvoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }

        entity.setSurplusMny(surplusMny);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, LoadReimburseVO.class);
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<LoadReimburseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(reimburse_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
        //属于项目
        queryWrapper.eq("depend_on_project", "1");

        if(CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang.StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<LoadReimburseVO> pushCost(LoadReimburseVO loadReimburseVO) {
        LoadReimburseEntity loadReimburseEntity = baseMapper.selectById(loadReimburseVO.getId());
        loadReimburseEntity.setSubjectId(loadReimburseVO.getSubjectId());
        loadReimburseEntity.setSubjectName(loadReimburseVO.getSubjectName());
        super.saveOrUpdate(loadReimburseEntity,false);
        //推送数据
        costPush(loadReimburseEntity);
        return CommonResponse.success(BeanMapper.map(loadReimburseEntity, LoadReimburseVO.class));
    }
    @Override
    public void costPush(LoadReimburseEntity loadReimburseEntity) {
        if (!"1".equals(loadReimburseEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        boolean newRelationFlag = true;
        Long subjectId = loadReimburseEntity.getSubjectId();
        if(null == subjectId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, loadReimburseEntity.getId());
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);
        //判断之前的单据是否关联
        String oldRelationFlag = loadReimburseEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(loadReimburseEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(loadReimburseEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
                saveCost(loadReimburseEntity);
        }


    }

    private void saveCost(LoadReimburseEntity entity) {
        logger.info("推送开始:{}",JSONObject.toJSONString(entity.getId()));

        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getSubjectId());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getReimburseMny());
        costDetailVO.setHappenMny(entity.getReimburseMny());
        costDetailVO.setHappenDate(entity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(BONDUP_BILL_CODE);
        costDetailVO.setSourceTabType(BONDUP_BILL_CODE);
        costDetailVO.setProjectId(entity.getProjectId());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
        costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
        costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
        costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
        costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
        costDetailVO.setSourceBillName("备用金费用报销"); // 来源单据名称 说明：材料验收单
        costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/loadList/loadReimburseCard?id=" + entity.getId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送返回结果:{}",JSONObject.toJSONString(stringCommonResponse));

            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<LoadReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(LoadReimburseEntity::getId, id);
        updateWrapper.set(LoadReimburseEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }
    @Override
    public BigDecimal totalBudgetMny(LoadReimburseVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
        //备用金报销(是否项目=是)【本期报销金额】合计值
        QueryWrapper<LoadReimburseEntity> loadReimburseQuery = new QueryWrapper<>();
        loadReimburseQuery.eq("project_Id", vo.getProjectId());
        loadReimburseQuery.eq("depend_on_project",1);
        if (vo.getId()!=null){
            loadReimburseQuery.ne("id",vo.getId());
        }
        if (vo.getReimburseMny()!=null){
            applyMny = applyMny.add(vo.getReimburseMny());
        }
        loadReimburseQuery.select("sum(reimburse_mny) as reimburseMny");
        LoadReimburseEntity loadReimburseEntity = super.getOne(loadReimburseQuery);
        if(loadReimburseEntity!=null &&null != loadReimburseEntity.getReimburseMny()
                &&!"0".equals(loadReimburseEntity.getReimburseMny())) {
            applyMny = applyMny.add(loadReimburseEntity.getReimburseMny());
        }
        return applyMny;
    }

    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckSpreadVO checkBudgetParams(LoadReimburseVO vo) {
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (vo.getCheckExceedFlag()==null){
            //获取 预算间接费总金额
            BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
            requestVo.setProjectId(vo.getProjectId());
            requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
            CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
            logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
            if (!res.isSuccess()){
                throw new BusinessException("网络错误"+res.getMsg());
            }
            // 没有预算不控制，预算不包含不控制
            if (null != res.getData()) {
                BudgetProjectProQuantityAndMnyVO data = res.getData();
                //预算间接费总金额
                BigDecimal budgetTaxMny =  data.getIndirectionTaxMny()==null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
                CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());

                if (!response.isSuccess()) {
                    throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
                }
                List<BillParamVO> billParamVOS = response.getData();
                if (CollectionUtils.isNotEmpty(billParamVOS)) {
                    //备用金报销总金额
                    BigDecimal  totalContractMny= totalBudgetMny(vo);

                    //获取其他三项金额
                    CommonResponse<BigDecimal> bigDecimalCommonResponse = otherContractApi.budgetControlTotal(vo.getProjectId());
                    logger.info("预算间接费 其他合同总金额 返回内容:{}", JSONObject.toJSONString(bigDecimalCommonResponse));
                    if (!bigDecimalCommonResponse.isSuccess()){
                        throw new BusinessException(bigDecimalCommonResponse.getMsg());
                    }
                    totalContractMny = totalContractMny.add(bigDecimalCommonResponse.getData());
                    PayReimburseVO payReimburse = new PayReimburseVO();
                    payReimburse.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(payReimburseService.totalBudgetMny(payReimburse));
                    PaySporadicVO paySporadic = new PaySporadicVO();
                    paySporadic.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(paySporadicService.totalBudgetMny(paySporadic));
                    for (BillParamVO billParamVO : billParamVOS) {
                        if (0 != billParamVO.getControlType()) {
                            BigDecimal roleValue = billParamVO.getRoleValue();
                            BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                            BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                            // 【预算间接费总金额】控 【实际间接费总金额】
                            logger.info("预算间接费总金额:{},实际间接费总金额:{}",JSONObject.toJSONString(totalContractMny),JSONObject.toJSONString(budgetTaxMnyResult));

                            if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                                // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                                BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);

                                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
//                        设备合同总金额：{}元，预算机械费总金额
                                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

                                paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                                paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                                StringBuffer stringBuffer = new StringBuffer();
                                stringBuffer.append("该项目实际间接费总金额：")
                                        .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                        .append("元， 预算间接费总金额 * ")
                                        .append(roleValue).append("%：")
                                        .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                        .append("元，超出金额：")
                                        .append(over.setScale(2, RoundingMode.HALF_UP))
                                        .append("元。");
                                paramsCheckDsVO.setContent(stringBuffer.toString());
                                updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                            }
                        }
                    }
                }
            }
        }

        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, InvocationInfoProxy.getOrgId());
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getReimburseMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
//                            controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
//                            checkDsVOS.add(paramsCheckDsVO);
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }

        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll(paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        BigDecimal fybx = payReimburseMapper.fetchSjzcje(projectId, null);
        BigDecimal lx = paySporadicMapper.fetchSjzcje(projectId, null);
        BigDecimal yj = baseMapper.fetchSjzcje(projectId, id);
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null);
    }
}
