package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.ReimburseShareCostDetailEntity;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IReimburseShareCostDetailService;
import com.ejianc.business.finance.vo.ReimburseShareCostDetailVO;
import com.ejianc.business.income.vo.MonthESDataVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.service.IReimburseShareService;
import com.ejianc.business.finance.vo.ReimburseShareVO;

/**
 * 报销费用分摊
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("reimburseShare")
public class ReimburseShareController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "REIMBURSE_SHARE";//此处需要根据实际修改

    @Autowired
    private IReimburseShareService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private IReimburseShareCostDetailService reimburseShareCostDetailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReimburseShareVO> saveOrUpdate(@RequestBody ReimburseShareVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null || saveOrUpdateVO.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<ReimburseShareCostDetailVO> vos = saveOrUpdateVO.getReimburseShareCostDetailList();
        if (CollectionUtils.isNotEmpty(vos)) {
            //其他组织费用分摊金额合计
            BigDecimal otherBodyReimburseShareMnyMny = new BigDecimal("0");
            for (int i = 0; i < vos.size(); i++) {
                ReimburseShareCostDetailVO vo=vos.get(i);
                LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.eq(PayReimburseEntity::getId, vo.getReimburseId());
                if ("del".equals(vo.getRowState())) {
                    updateWrapper.set(PayReimburseEntity::getQuoteFlag, 0);
                } else {
                    updateWrapper.set(PayReimburseEntity::getQuoteFlag, 1);
                    //最后一笔组织费用分摊采取分摊金额合计-其他组织已分摊金额
                    if (i!=vos.size()-1){
                    //有多个组织费用分摊时，按占比分摊
                    BigDecimal bodyReimburseMny = vo.getBodyReimburseMny();
                    BigDecimal div = ComputeUtil.safeDiv(bodyReimburseMny, saveOrUpdateVO.getReimburseMny());
                    BigDecimal bodyReimburseShareMny = ComputeUtil.safeMultiply(div, saveOrUpdateVO.getSumShareMny()).setScale(2, BigDecimal.ROUND_HALF_UP);
                    vo.setBodyReimburseShareMny(bodyReimburseShareMny);
                    otherBodyReimburseShareMnyMny=ComputeUtil.safeAdd(otherBodyReimburseShareMnyMny,bodyReimburseShareMny);
                }else {
                        vo.setBodyReimburseShareMny(ComputeUtil.safeSub(saveOrUpdateVO.getSumShareMny(),otherBodyReimburseShareMnyMny).setScale(2, BigDecimal.ROUND_HALF_UP));
                    }

                }
                payReimburseService.update(updateWrapper);
            }
        }

        ReimburseShareEntity entity = BeanMapper.map(saveOrUpdateVO, ReimburseShareEntity.class);
        service.saveOrUpdate(entity, false);
        ReimburseShareVO vo = BeanMapper.map(entity, ReimburseShareVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReimburseShareVO> queryDetail(Long id) {
    	ReimburseShareEntity entity = service.selectById(id);
    	ReimburseShareVO vo = BeanMapper.map(entity, ReimburseShareVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReimburseShareVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ReimburseShareVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> ids = vos.stream().map(ReimburseShareVO::getId).collect(Collectors.toList());
        QueryWrapper<ReimburseShareCostDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("share_id",ids);
        List<ReimburseShareCostDetailEntity> list = reimburseShareCostDetailService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)){
            List<Long> reimburseIds = list.stream().filter(s -> s.getReimburseId() != null).map(ReimburseShareCostDetailEntity::getReimburseId).collect(Collectors.toList());
            LambdaUpdateWrapper<PayReimburseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(PayReimburseEntity::getId,reimburseIds);
            updateWrapper.set(PayReimburseEntity::getQuoteFlag,0);
            payReimburseService.update(updateWrapper);
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReimburseShareVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("reimburseCode");
        fuzzyFields.add("reimburseReason");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("org_id",new Parameter("in", iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ReimburseShareEntity> page = service.queryPage(param,false);
        IPage<ReimburseShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReimburseShareVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("reimburseCode");
        fuzzyFields.add("reimburseReason");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ReimburseShareEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<ReimburseShareVO> reimburseShareVOS = BeanMapper.mapList(list, ReimburseShareVO.class);
        for (ReimburseShareVO reimburseShareVO : reimburseShareVOS) {
            reimburseShareVO.setBillStateName(BillStateEnum.getEnumByStateCode(reimburseShareVO.getBillState()).getDescription());
        }
        beans.put("records", reimburseShareVOS);
        ExcelExport.getInstance().export("ReimburseShare-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refReimburseShareData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ReimburseShareVO>> refReimburseShareData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ReimburseShareEntity> page = service.queryPage(param,false);
        IPage<ReimburseShareVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReimburseShareVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 校验一个报销单下自能有一个报销分摊单
     */
    @RequestMapping(value = "/checkReimburseShareOnly", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> checkReimburseShareOnly(Long reimburseId) {
        QueryWrapper<ReimburseShareEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("reimburse_id",reimburseId);
        queryWrapper.eq("bill_state",0);
        List<ReimburseShareEntity> list = service.list(queryWrapper);
        if (list.size()>1){
            CommonResponse.error("一个费用报销下报销费用分摊自能存在一个自由态的！");
        }
        return CommonResponse.success("查询详情数据成功！");
    }
}
