package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.ReimburseShareDetailEntity;
import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IReimburseShareDetailService;
import com.ejianc.business.finance.service.IReimburseShareService;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("reimburseShare")
public class ReimburseShareBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IPayReimburseService payReimburseService;
	@Autowired
	private IReimburseShareService service;
	@Autowired
	private IReimburseShareDetailService reimburseShareDetailService;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private ICostDetailApi costDetailApi;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReimburseShareEntity reimburseShareEntity = service.selectById(billId);
		if (reimburseShareEntity!=null){
			payReimburseService.updateShareMoneyByShareId(reimburseShareEntity.getId(), true);
			List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
			if (CollectionUtils.isNotEmpty(reimburseShareDetailList)){
				for (ReimburseShareDetailEntity entity : reimburseShareDetailList) {
					PayReimburseEntity payReimburseEntity = new PayReimburseEntity();
					payReimburseEntity.setDependOnProject("1");
					payReimburseEntity.setOrgId(entity.getOrgId());
					payReimburseEntity.setOrgName(entity.getOrgName());
					payReimburseEntity.setOrgCode(entity.getOrgCode());
					payReimburseEntity.setProjectId(entity.getProjectId());
					payReimburseEntity.setProjectName(entity.getProjectName());
					payReimburseEntity.setApplyMny(entity.getBodyShareMny());
					payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
					payReimburseEntity.setApplyMnyCn(entity.getBodyShareMnyCn());
					//申请日期
					payReimburseEntity.setApplyTime(reimburseShareEntity.getBliDate());
					payReimburseEntity.setIsShareFlag(1);
					payReimburseEntity.setPayMny(entity.getBodyShareMny());
					payReimburseEntity.setBillState(1);
					payReimburseEntity.setCreateUserCode(reimburseShareEntity.getCreateUserCode());
//					payReimburseEntity.setFeeType(reimburseShareEntity.getFeeType());
					payReimburseEntity.setPayType(2);
					payReimburseEntity.setPayStatus(2);
					//设置默认值
					payReimburseEntity.setProportionFlag("0");
					payReimburseEntity.setRelationFlag("0");
					payReimburseEntity.setPayReason(reimburseShareEntity.getReimburseReason());
					payReimburseEntity.setApproveTime(new Date());
					payReimburseEntity.setApplyUserId(entity.getReimburseId());
					payReimburseEntity.setApplyUserName(reimburseShareEntity.getEmployeeName());
					payReimburseEntity.setEmployeeId(reimburseShareEntity.getEmployeeId());
					payReimburseEntity.setEmployeeName(reimburseShareEntity.getEmployeeName());
					payReimburseEntity.setQuoteFlag(0);
					Long tenantId = InvocationInfoProxy.getTenantid();
					CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
					if(billCode.isSuccess()) {
							payReimburseEntity.setBillCode(billCode.getData());
					}else{
							throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
					logger.info(" 推送信息参数:"+JSONObject.toJSONString(payReimburseEntity));
					//推送字表
					List<PayInfoEntity> payInfoList = new ArrayList<>();
					PayInfoEntity payInfoEntity = new PayInfoEntity();
					payInfoEntity.setFeeTaxMny(entity.getBodyShareMny());
					payInfoEntity.setFeeHappenDate(reimburseShareEntity.getBliDate());
					payInfoList.add(payInfoEntity);
					payReimburseEntity.setPayInfoList(payInfoList);
					boolean b = payReimburseService.saveOrUpdate(payReimburseEntity,false);
					//推送成本
					payReimburseService.costPush(payReimburseEntity);
					logger.info(" 推送信息结果:"+b);
					Long reimburseId = payReimburseEntity.getId();
					LambdaUpdateWrapper<ReimburseShareDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
					updateWrapper.eq(ReimburseShareDetailEntity::getId,entity.getId());
					updateWrapper.set(ReimburseShareDetailEntity::getReimburseId,reimburseId);
					reimburseShareDetailService.update(updateWrapper);
			}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReimburseShareEntity reimburseShareEntity = service.selectById(billId);
		List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
		if (CollectionUtils.isNotEmpty(reimburseShareDetailList)) {
			for (ReimburseShareDetailEntity entity : reimburseShareDetailList) {
				Long id = entity.getReimburseId();
				//        弃审前校验该结算单是否已经分摊，已分摊不允许撤回
				CommonResponse<String> commonResponse = costDetailApi.checkShareFlag(id);
				if (!commonResponse.isSuccess()) {
					return CommonResponse.error(commonResponse.getMsg());
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ReimburseShareEntity reimburseShareEntity = service.selectById(billId);
		payReimburseService.updateShareMoneyByShareId(reimburseShareEntity.getId(), false);

		List<ReimburseShareDetailEntity> reimburseShareDetailList = reimburseShareEntity.getReimburseShareDetailList();
        if (CollectionUtils.isNotEmpty(reimburseShareDetailList)){
			List<Long> reimburseIds = new ArrayList<>();
			for (ReimburseShareDetailEntity entity : reimburseShareDetailList) {
				Long id = entity.getReimburseId();
				payReimburseService.pullCost(id);
				reimburseIds.add(id);
			}
			payReimburseService.removeByIds(reimburseIds);
		}
		return CommonResponse.success();
	}

}
