package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 付款申请记录实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payRecord")
public class PayRecordController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPayRecordService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordVO> saveOrUpdate(@RequestBody PayRecordVO saveorUpdateVO) {
        PayRecordVO vo = service.insertOrUpdate(saveorUpdateVO, false);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayRecordVO> queryDetail(Long id) {
        PayRecordEntity entity = service.selectById(id);
        PayRecordVO vo = BeanMapper.map(entity, PayRecordVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordVO> vos) {
        service.removeByIds(vos.stream().map(PayRecordVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<PayRecordEntity> page = service.queryPage(param, false);
        IPage<PayRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @description: 导出
     * @param saveorUpdateVO
     * @param response
     * @return
     * @author songlx
     * @date: 2022/12/8
     */
    @RequestMapping(value = "/excelExportSalary", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody PayRecordVO payRecordVO, HttpServletResponse response) {
        List<PayRecordSalaryGrantVO> payRecordSalaryGrantList = payRecordVO.getPayRecordSalaryGrantList();
        for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : payRecordSalaryGrantList) {
            Integer sex = payRecordSalaryGrantVO.getSex();
            if(2 == sex){
                payRecordSalaryGrantVO.setSexName("女");
            } else {
                payRecordSalaryGrantVO.setSexName("男");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", payRecordSalaryGrantList);
        ExcelExport.getInstance().export("pay-record-salary.xlsx", beans, response);
    }


    /**
     * 付款退回
     *
     * @param payRecordVO 付款申请记录
     *
     * @return {@link CommonResponse}<{@link PayRecordVO}>
     */
    @RequestMapping(value = "/returnPayment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordVO> returnPayment(@RequestBody PayRecordVO payRecordVO) {
        return CommonResponse.success("付款退回成功！", service.returnPayment(payRecordVO));
    }

}
