package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.mapper.PayMayReportMapper;
import com.ejianc.business.finance.service.PayMayReportService;
import com.ejianc.business.finance.vo.payMnyReportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Service("payMayReportService")
public class PayMayReportServiceImpl implements PayMayReportService {
    @Autowired
    private PayMayReportMapper payMayReportMapper;

    @Override
    public IPage<payMnyReportVo> queryPayReport(Map<String, Object> params) {

        List<payMnyReportVo> voList = new ArrayList<>();
        IPage<payMnyReportVo> page = new Page<>();
        page.setCurrent(Integer.valueOf(params.get("pageIndex").toString()));
        page.setSize(Integer.valueOf(params.get("pageSize").toString()));
        long total = payMayReportMapper.count(params);
        page.setTotal(total);
        if (total == 0) {
            page.setRecords(voList);
            return page;
        }
        long startLine = (page.getCurrent() < 1 ? 0 : page.getCurrent() - 1) * page.getSize();
        params.put("startLine", startLine);
        params.put("pageSize", page.getSize());
        voList = payMayReportMapper.queryPayReport(params);
        page.setRecords(voList);
        return page;
    }
}
