package com.ejianc.business.bank.service.impl;

import com.ejianc.business.bank.bean.BankIncomeEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.service.IBankIncomeService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service("bankIncome") 
public class BankIncomeBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IBankIncomeService service;

	@Autowired
	private IBankFlowService bankFlowService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		BankIncomeEntity entity = service.selectById(billId);
		BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.账户收入);
		flowVO.setBillDate(entity.getBillDate());
		flowVO.setSourceId(entity.getId());
		flowVO.setBillId(entity.getId());
		flowVO.setReceiveMoney(entity.getMoney());
		flowVO.setBillCode(entity.getCode());
		flowVO.setOrgId(entity.getOrgId());
		flowVO.setOrgName(entity.getOrgName());
		flowVO.setAccountId(entity.getAccountId());
		flowVO.setAccountName(entity.getAccountName());
		flowVO.setAccountBank(entity.getAccountBank());
		flowVO.setAccountNum(entity.getAccountNum());

		flowVO.setTradeOrgName(entity.getTradeName());
		flowVO.setTradeAccountName(entity.getTradeAccountName());
		flowVO.setTradeAccountBank(entity.getTradeAccountBank());
		flowVO.setTradeAccountNum(entity.getTradeAccountNum());
		flowVO.setMemo(entity.getMemo());
		bankFlowService.saveFlowVO(flowVO);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		bankFlowService.delFlowBySource(null, billId);
		return CommonResponse.success();
	}

}
