package com.ejianc.business.finance.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@Mapper
public interface PayContractMapper extends BaseCrudMapper<PayContractEntity> {

    List<PayContractVO> queryPageList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("flag") String flag);

    List<PayApplyPubVO> queryPendingList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper);

    List<FinanceMonthVO> getMonthReceiveMny(@Param("projectId")Long projectId,@Param("startDate")String startDate,@Param("endDate")String endDate);

    List<FinanceMonthVO> getMonthOutMny(@Param("projectId")Long projectId,@Param("startDate")String startDate,@Param("endDate")String endDate);

    List<FinanceCostVO> getCostInfo(@Param("projectId") Long projectId,@Param("year") String year);

    BigDecimal selectSubThisPay(@Param("contractId")Long contractId, @Param("projectId")Long projectId, @Param("settleId")Long settleId);

    BigDecimal selectSubSumPay(@Param("contractId")Long contractId, @Param("projectId")Long projectId,@Param("settleDate") String settleDate, @Param("settleIdList") List<Long> settleIdList);

    List<PayMnyWarnVO> getPayMnyByTenantIds(@Param(value = "pubWarnQueryVO") PubWarnQueryVO pubWarnQueryVO);

    List<Map<String, Object>> queryBondUpExpireWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<Map<String, Object>> queryBondDownExpireWarn(@Param(value = "sqlParamList") List<SqlParam> sqlParamList);

    List<ProjectAppVo> getReceiveMny(@Param(value = "projectId") Long projectId,@Param(value = "lastDay")  Integer lastDay);

    List<ProjectAppVo> getMonthCostMny(@Param(value = "projectId")Long projectId,@Param(value = "lastDay") Integer lastDay);

    BigDecimal projectCollection(@Param(value = "projectId")Long projectId);

    List<PayMnyWarnVO> warnPayMny(@Param(value = "pubWarnQueryVO") PubWarnQueryVO pubWarnQueryVO);

    List<PayMnyWarnVO> warnMaterialPayMny(@Param(value = "pubWarnQueryVO")PubWarnQueryVO pubWarnQueryVO);

    List<PayMnyWarnVO> warnMaterialPrePayMny(@Param(value = "pubWarnQueryVO")PubWarnQueryVO pubWarnQueryVO);

    ProjectFinancePayVO getProjectApplyPayInfo(@Param("projectId")Long projectId);

    List<ProjectReimburseVO> getProjectReimburse(@Param("projectIds") List<Long> projectIds);

    List<FinanceWarnV0> getProjectPayMny();

    List<Map<String, Object>> queryLaborSalaryApplyPageList(Page pages, @Param(Constants.WRAPPER) QueryWrapper queryWrapper, @Param("flag") String flag);

    List<PayContractSettleVO> getApplyMnyHasFree(@Param("settleIds") List<Long> settleIds,@Param("id") Long id);

    List<InstoreMaterialVO> queryInstoreMaterialById(@Param(value = "contractId")Long contractId);

    BigDecimal queryWeeklyProgressByProjectId(@Param("projectId") Long projectId);

    BigDecimal queryTotalAmountByContractIds(@Param("contractIds") List<Long> contractIds);

    BigDecimal queryCertificateSupplierId(@Param("supplierId")Long supplierId,@Param("projectId")Long projectId);

    Integer  queryMaxSerialNumber(@Param("code") String code);

    Integer isCodeExists(@Param("code") String code);
}
