/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayReportedEntity;
import com.ejianc.business.finance.enums.PaymentStatusEnum;
import com.ejianc.business.finance.service.IPayReportedService;
import com.ejianc.business.finance.utils.ParamUtil;
import com.ejianc.business.finance.vo.PayReportedVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"payReported"})
public class PayReportedController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FKBB";
    @Autowired
    private IPayReportedService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReportedVO> saveOrUpdate(@RequestBody PayReportedVO saveOrUpdateVO) {
        PayReportedEntity entity;
        if (saveOrUpdateVO.getPaymentState() == null) {
            saveOrUpdateVO.setPaymentState(Integer.valueOf(PaymentStatusEnum.REPORTING.getCode()));
        }
        if ((entity = (PayReportedEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PayReportedEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PayReportedVO vo = (PayReportedVO)BeanMapper.map((Object)((Object)entity), PayReportedVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"payToCompleted"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> payToCompleted(@RequestBody PayReportedVO vo) {
        PayReportedEntity entity = (PayReportedEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setPaymentPersonId(vo.getPaymentPersonId());
        entity.setPaymentPersonName(vo.getPaymentPersonName());
        entity.setPaymentDate(vo.getPaymentDate());
        entity.setPaymentState(PaymentStatusEnum.PAID.getCode());
        entity.setRefundReason(vo.getRefundReason());
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u786e\u8ba4\u6536\u6599\u6210\u529f\uff01");
    }

    @RequestMapping(value={"payToReturn"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> payToReturn(@RequestBody PayReportedVO vo) {
        PayReportedEntity entity = (PayReportedEntity)((Object)this.service.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6ca1\u6709\u627e\u5230\u8be5\u5355\u636e\uff01");
        }
        entity.setPaymentPersonId(vo.getPaymentPersonId());
        entity.setPaymentPersonName(vo.getPaymentPersonName());
        entity.setPaymentDate(vo.getPaymentDate());
        entity.setPaymentState(PaymentStatusEnum.REFUNDED.getCode());
        entity.setRefundReason(vo.getRefundReason());
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u56de\u9000\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReportedVO> queryDetail(Long id) {
        PayReportedEntity entity = (PayReportedEntity)((Object)this.service.selectById(id));
        PayReportedVO vo = (PayReportedVO)BeanMapper.map((Object)((Object)entity), PayReportedVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReportedVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PayReportedVO payReportedVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayReportedVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("paymentCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("paymentState", new Parameter("ne", (Object)PaymentStatusEnum.PAID.getCode()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PayReportedVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("paymentCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("PayReported-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPayData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayReportedVO>> refPayReportedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject search;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("paymentCode");
        param.getFuzzyFields().add("projectCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("supplierCode");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("feeKindName");
        param.getFuzzyFields().add("contractCode");
        param.getFuzzyFields().add("feeKindName");
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            search = JSONObject.parseObject((String)condition);
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        String sql = ParamUtil.getSqlBuild(param, "A1");
        List<PayReportedVO> list = this.service.queryRefPayData((Page<PayReportedVO>)page, sql);
        page.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }
}

