package com.ejianc.business.finance.bean;

import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 付款申请关联扣款单实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_contract_deduction")
public class PayContractDeductionEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="payapply_id")
    private Long payapplyId; // 付款申请主键ID
    @TableField(value="deduction_bill_code")
    private String deductionBillCode; // 扣款单单据编号
    @TableField(value="deduction_id")
    private Long deductionId; // 扣款单ID
    @TableField(value="subject_name")
    private String subjectName; // 主题
    @TableField(value="penalty_money")
    private java.math.BigDecimal penaltyMoney; // 扣款金额

    @TableField(value="deal_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dealDate; // 办理日期

    @TableField(value="deduction_reason")
    private java.lang.String deductionReason; // 扣款事由


    public Date getDealDate() {
        return dealDate;
    }

    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }

    public String getDeductionReason() {
        return deductionReason;
    }

    public void setDeductionReason(String deductionReason) {
        this.deductionReason = deductionReason;
    }

    /**
     * 付款申请主键ID
     */
    public Long getPayapplyId() {
        return payapplyId;
    }

    /**
     * 付款申请主键ID
     */
    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    /**
     * 扣款单单据编号
     */
    public String getDeductionBillCode() {
        return deductionBillCode;
    }

    /**
     * 扣款单单据编号
     */
    public void setDeductionBillCode(String deductionBillCode) {
        this.deductionBillCode = deductionBillCode;
    }
    /**
     * 扣款单ID
     */
    public Long getDeductionId() {
        return deductionId;
    }

    /**
     * 扣款单ID
     */
    public void setDeductionId(Long deductionId) {
        this.deductionId = deductionId;
    }
    /**
     * 主题
     */
    public String getSubjectName() {
        return subjectName;
    }

    /**
     * 主题
     */
    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    /**
     * 扣款金额
     */
    public java.math.BigDecimal getPenaltyMoney() {
        return penaltyMoney;
    }

    /**
     * 扣款金额
     */
    public void setPenaltyMoney(java.math.BigDecimal penaltyMoney) {
        this.penaltyMoney = penaltyMoney;
    }
    
}
