package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * <p>
 * 保证金退还表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondUpBack")
public class BondUpBackController {
    @Autowired
    private IBondUpBackService service;

    @Autowired
    private IOrgApi orgApi;
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondUpBackVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondUpBackVO> saveOrUpdate(@RequestBody BondUpBackVO bondUpBackVO) {
        BondUpBackVO backVO = service.insertOrUpdate(bondUpBackVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpDealRentVO> queryDetail(Long id) {
        BondUpDealRentVO backVO = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

    @RequestMapping(value = "/queryDetailByNew", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpBackVO> queryDetailByNew(Long id) {
        BondUpBackEntity entity = service.selectById(id);
        BondUpBackVO map = BeanMapper.map(entity, BondUpBackVO.class);
        return CommonResponse.success("查询详情数据成功！", map);
    }

    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BondUpBackVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("bondCode");

        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        IPage<BondUpBackEntity> page = service.queryPage(param, false);
        IPage<BondUpBackVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BondUpBackVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondUpBackVO> vos) {
        service.deleteNew(vos);
        return CommonResponse.success("删除成功");
    }
    @RequestMapping(value = "/totalAlreadyBackMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId){
        return service.totalAlreadyBackMny(bondId,null);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List<BondUpBackVO> list = new ArrayList<>();
        CommonResponse<IPage<BondUpBackVO>> iPageCommonResponse = queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            list = iPageCommonResponse.getData().getRecords();
        }
        Map<String, Object> beans = new HashMap<>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (BondUpBackVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            vo.setCreateTimeName(dateFormat.format(vo.getCreateTime()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("bondUpBack-export.xlsx", beans, response);
    }
}
