package com.ejianc.business.bank.service.impl;

import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankAllocateEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankAllocateService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;
import java.util.Map;

@Service("bankAllocate") 
public class BankAllocateBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBankAllocateService service;

	@Autowired
	private IBankFlowService bankFlowService;

	@Autowired
	private IBankAcctService bankAcctService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("进入终审后回写--- billId:"+billId+"  state:"+state);
		BankAllocateEntity entity = service.selectById(billId);
		//==================推送收支流水
		//账户调入流水
		BankAcctEntity OutAccEntity = bankAcctService.selectById(entity.getAccountOutId());
		BankAcctEntity InAccEntity = bankAcctService.selectById(entity.getAccountInId());

		BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.账户调入);
		flowVO.setBillDate(entity.getAllocateDate());
		flowVO.setSourceId(entity.getId());
		flowVO.setBillId(entity.getId());
		flowVO.setReceiveMoney(entity.getAllocateMny());
		flowVO.setBillCode(entity.getBillCode());
		flowVO.setOrgId(entity.getOrgId());
		flowVO.setOrgName(entity.getOrgName());
		flowVO.setAccountId(entity.getAccountInId());
		flowVO.setAccountName(entity.getAccountInName());
		flowVO.setAccountBank(entity.getAccountInBank());
		flowVO.setAccountNum(entity.getAccountInNum());

		flowVO.setTradeOrgId(OutAccEntity.getOrgId());
		flowVO.setTradeOrgName(OutAccEntity.getOrgName());
		flowVO.setTradeAccountId(entity.getAccountOutId());
		flowVO.setTradeAccountName(entity.getAccountOutName());
		flowVO.setTradeAccountBank(entity.getAccountOutBank());
		flowVO.setTradeAccountNum(entity.getAccountOutNum());
		flowVO.setMemo(entity.getMemo());
		bankFlowService.saveFlowVO(flowVO);

		//账户调出流水
		BankFlowVO flowOutVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.账户调出);
		flowOutVO.setBillDate(entity.getAllocateDate());
		flowOutVO.setSourceId(entity.getId());
		flowOutVO.setBillId(entity.getId());
		flowOutVO.setPayMoney(entity.getAllocateMny());
		flowOutVO.setBillCode(entity.getBillCode());
		flowOutVO.setOrgId(entity.getOrgId());
		flowOutVO.setOrgName(entity.getOrgName());
		flowOutVO.setAccountId(entity.getAccountOutId());
		flowOutVO.setAccountName(entity.getAccountOutName());
		flowOutVO.setAccountBank(entity.getAccountOutBank());
		flowOutVO.setAccountNum(entity.getAccountOutNum());

		flowOutVO.setTradeOrgId(InAccEntity.getOrgId());
		flowOutVO.setTradeOrgName(InAccEntity.getOrgName());
		flowOutVO.setTradeAccountId(entity.getAccountInId());
		flowOutVO.setTradeAccountName(entity.getAccountInName());
		flowOutVO.setTradeAccountBank(entity.getAccountInBank());
		flowOutVO.setTradeAccountNum(entity.getAccountInNum());
		flowOutVO.setMemo(entity.getMemo());
		bankFlowService.saveFlowVO(flowOutVO);
		//===============推送收支流水结束
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
		BankAllocateEntity entity = service.selectById(billId);
		//删除流水记录
		bankFlowService.delFlowBySource(entity.getId(),entity.getId());
		return CommonResponse.success();
	}

}
