package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondReportVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.business.finance.vo.BondVO;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * <p>
 * 保证金对上申请表 前端控制器
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@RestController
@RequestMapping("/bondUp")
public class BondUpController {
    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBondUpDealService bondUpDealService;

    @Autowired
    private IOrgApi orgApi;

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param bondUpVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondUpVO> saveOrUpdate(@RequestBody BondUpVO bondUpVO) {
        return bondUpService.insertOrUpdate(bondUpVO);
    }
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpVO> queryDetail(Long id) {
        BondUpVO backVO = bondUpService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }

    /**
     * 查询收款账户信息
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BondUpVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<BondUpEntity> entityList = bondUpService.queryList(queryParam,false);
        BondUpVO backVO = !entityList.isEmpty() ? BeanMapper.map( entityList.get(0), BondUpVO.class) : new BondUpVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }
    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BondUpEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter aa = param.getParams().get("backType");
        Parameter bb = param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=aa&&"1".equals(aa.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=aa&&"2".equals(aa.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bb&&"1".equals(bb.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) <= 0");
        }else if(null!=bb&&"2".equals(bb.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) > 0");
        }
        IPage<BondUpEntity> pageData = bondUpService.selectPage(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records",BeanMapper.mapList(pageData.getRecords(), BondUpVO.class));
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListManage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListManage(@RequestBody QueryParam param) {
        List<BondUpVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondUpEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bondState&&"1".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() <= end_date");
        }else if(null!=bondState&&"2".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BondUpEntity> pageData = bondUpService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            list = BeanMapper.mapList(pageData.getRecords(), BondUpVO.class);
            list.forEach(vo -> {
                if(new Date().after(vo.getEndDate())){
                    vo.setDealStatus("已到期");
                }else{
                    vo.setDealStatus("有效");
                }
            });
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }


    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询待处理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryUnDealList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryUnDealList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BondVO> list = bondUpService.queryUnDealList(page,wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询待处理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryBondMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BondReportVO> queryBondMny(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        BondReportVO reportVO = bondUpService.queryBondReport(wrapper);
        return CommonResponse.success("查询列表数据成功！", reportVO);
    }

    /**
     * @Author sunyj
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondUpVO> vos) {
        List<Long> ids = vos.stream().map(BondUpVO::getId).collect(Collectors.toList());
        bondUpService.removeByIds(ids,false);
        return CommonResponse.success("删除成功");
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BondUpVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BondUpEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter aa = param.getParams().get("backType");
        Parameter bb = param.getParams().get("payType");
        param.getParams().remove("backType");
        param.getParams().remove("payType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=aa&&"1".equals(aa.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=aa&&"2".equals(aa.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bb&&"1".equals(bb.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) <= 0");
        }else if(null!=bb&&"2".equals(bb.getValue())){
            wrapper.apply("IFNULL(pay_mny,0) > 0");
        }
        IPage<BondUpEntity> pageData = bondUpService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), BondUpVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if(new Date().after(vo.getEndDate())){
                vo.setDealStatus("已到期");
            }else{
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondUpExport.xlsx", beans, response);
//        }
    }

    @RequestMapping(value = "/excelExports", method = RequestMethod.POST)
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BondUpVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondUpEntity> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if(null!=backType&&"1".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        }else if(null!=backType&&"2".equals(backType.getValue())){
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if(null!=bondState&&"1".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() <= end_date");
        }else if(null!=bondState&&"2".equals(bondState.getValue())){
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BondUpEntity> pageData = bondUpService.selectPage(page,wrapper);
        if(CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), BondUpVO.class);
        }
        list.forEach(vo -> {
            if(new Date().after(vo.getEndDate())){
                vo.setDealStatus("已到期");
            }else{
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bondUpManageExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportUn", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportsUn(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state",new Parameter(QueryParam.IN,billstate));
        Page<BondVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BondVO> list = bondUpService.queryUnDealList(page,wrapper);
        List<BondVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            listExport = BeanMapper.mapList(list, BondVO.class);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("bondUpUnManageExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/refPayBondUpData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BondUpVO>> refPayBondUpData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                     String condition,
                                                                                     String searchObject,
                                                                                     String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        param.getParams().put("bond_status",new Parameter(QueryParam.EQ,1));

        param.getOrderMap().put("deal_time",QueryParam.DESC);
        IPage<BondUpEntity> page = bondUpService.queryPage(param,false);
        IPage<BondUpVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BondUpVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
