package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/finance/")
public class PayContractApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IPayContractService contractService;


	@Autowired
	private IPayInvoiceService payInvoiceService;


	/**
	 * 获取结算单申请金额（包含自由态）
	 */
	@RequestMapping(value = "getApplyMnyHasFree", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<Long, BigDecimal>> getApplyMnyHasFree(@RequestBody List<Long> settleIds) {
		Map<Long, BigDecimal> map = contractService.getApplyMnyHasFree(settleIds, null);
		return CommonResponse.success("查询成功！", map);
	}



	@RequestMapping(value = "getSumPayMny", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SumPayMnyVO> getSumPayMny(
			@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam(value="orgId", required=false) Long orgId) {
		try {
			SumPayMnyVO vo = contractService.getSumPayMny(contractId, orgId, false);
			return CommonResponse.success(vo);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	@RequestMapping(value = "getSumPayMnyVOList", method=RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SumPayMnyVO> getSumPayMnyVOList(
			@RequestParam(value="contractId", required=true) Long contractId,
			@RequestParam(value="orgId", required=false) Long orgId) {
		try {
			SumPayMnyVO vo = contractService.getSumPayMnyVOList(contractId, orgId);
			return CommonResponse.success(vo);
		} catch (Exception e) {
			logger.error("系统异常："+e.getMessage());
			e.printStackTrace();
		}
		return CommonResponse.error("查询失败");
	}

	/**
	 * @Description  分包过程结算付款取数
	 */
	@RequestMapping(value = "getSubSettlePay", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, BigDecimal>> getSubSettlePay(@RequestBody PubContractSubQueryVO pubContractSubQueryVO) {
		Map<String, BigDecimal> map = contractService.getSubSettlePay(pubContractSubQueryVO);
		return CommonResponse.success("查询成功！", map);
	}


	/**
	 * @Description  根据租户id集合查询付款信息
	 */
	@RequestMapping(value = "getPayMnyByTenantIds", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, PayMnyWarnVO>> getPayMnyByTenantIds(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
		Map<String, PayMnyWarnVO> map = contractService.getPayMnyByTenantIds(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}
	/**
	 * @Description  根据租户id集合查询付款信息()
	 */
	@RequestMapping(value = "warnPayMny", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, PayMnyWarnVO>> warnPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
		Map<String, PayMnyWarnVO> map = contractService.warnPayMny(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}
	/**
	 * @Description  根据租户id集合查询付款信息(付款信息,物资合同专用)
	 */
	@RequestMapping(value = "warnMaterialPayMny", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
		Map<String, PayMnyWarnVO> map = contractService.warnMaterialPayMny(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}
	/**
	 * @Description  根据租户id集合查询付款信息(预付款信息,物资合同专用)
	 */
	@RequestMapping(value = "warnMaterialPrePayMny", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPrePayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
		Map<String, PayMnyWarnVO> map = contractService.warnMaterialPrePayMny(pubWarnQueryVO);
		return CommonResponse.success("查询成功！", map);
	}

	@RequestMapping(value = "getProjectReimburse", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<ProjectReimburseVO>> getProjectReimburse(@RequestParam("projectIds") List<Long> projectIds) {
		return CommonResponse.success("查询成功！", contractService.getProjectReimburse(projectIds));
	}
	/**
	 * 项目维度累计付款金额
	 * @return
	 */
	@RequestMapping(value = "getProjectPayMny", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<FinanceWarnV0>> getProjectPayMny() {
		List<FinanceWarnV0> list=contractService.getProjectPayMny();
		return CommonResponse.success("查询成功！",list);
	}



	/**
	 * @description: 查询使用此发票数量数据
	 *
	 * @return {@link com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.business.finance.vo.PayRecordVO>>}
	 * @author songlx
	 * @date: 2022/12/30
	 */
	@RequestMapping(value = "/countUseNum", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<List<PayInvoiceUseVO>> countUseNum(@RequestBody PayInvoiceUseVO payInvoiceUseVO) {
		List<PayInvoiceUseVO> list = payInvoiceService.countUseNum(payInvoiceUseVO.getInvoiceIds());
		return CommonResponse.success("查询使用此发票数量数据成功！", list);
	}
	/**
	 * 查询项目资金情况
	 * @return
	 */
	@RequestMapping(value = "getProFinance", method=RequestMethod.POST)
	@ResponseBody
	public CommonResponse<ProjectFinanceVO> getProFinance(Long projectId) {
		ProjectFinanceVO vo = contractService.getProFinance(projectId);
		return CommonResponse.success("查询成功！",vo);
	}

}
