package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.LoadBackVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.LoadBackMapper;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.service.ILoadBackService;

import java.math.BigDecimal;
import java.text.DecimalFormat;

/**
 * 借款退还
 *
 * @author generator
 *
 */
@Service
public class LoadBackServiceImpl extends BaseServiceImpl<LoadBackMapper, LoadBackEntity> implements ILoadBackService{
    private static final String BONDUP_BILL_CODE = "LOAD_BACK";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadApplyService loadApplyService;

    @Override
    public LoadBackVO insertOrUpdate(LoadBackVO loadBackVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(null!=loadBackVO&&StringUtils.isEmpty(loadBackVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                loadBackVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        LoadBackEntity entity = BeanMapper.map(loadBackVO, LoadBackEntity.class);
        BigDecimal surplusMny =  loadApplyService.querySurplusMny(null,entity.getId(),entity.getOrgId(),0, String.valueOf(loadBackVO.getApplyEmployeeId()));
        BigDecimal backMny = entity.getBackMny();
        if(backMny.compareTo(surplusMny)>0){
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            throw new BusinessException("本次退还金额不能超过剩余可退还金额【"+df1.format(surplusMny)+"】元");
        }
        entity.setSurplusMny(surplusMny);
        super.saveOrUpdate(entity,false);
        return BeanMapper.map(entity, LoadBackVO.class);
    }
}
