package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.ejianc.business.finance.enums.PaymentStatusEnum;
import com.ejianc.business.finance.utils.ParamUtil;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.PayReportedEntity;
import com.ejianc.business.finance.service.IPayReportedService;
import com.ejianc.business.finance.vo.PayReportedVO;

/**
 * 内部付款报备表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payReported")
public class PayReportedController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FKBB";//此处需要根据实际修改

    @Autowired
    private IPayReportedService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayReportedVO> saveOrUpdate(@RequestBody PayReportedVO saveOrUpdateVO) {
        if(saveOrUpdateVO.getPaymentState() == null){
            saveOrUpdateVO.setPaymentState(PaymentStatusEnum.REPORTING.getCode()); // 默认状态 1 = 报备中
        }
    	PayReportedEntity entity = BeanMapper.map(saveOrUpdateVO, PayReportedEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PayReportedVO vo = BeanMapper.map(entity, PayReportedVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @RequestMapping(value = "payToCompleted", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> payToCompleted(@RequestBody PayReportedVO vo) {
        PayReportedEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        entity.setPaymentPersonId(vo.getPaymentPersonId()); // 付款人ID
        entity.setPaymentPersonName(vo.getPaymentPersonName()); // 付款人名称
        entity.setPaymentDate(vo.getPaymentDate()); // 付款日期
        entity.setPaymentState(PaymentStatusEnum.PAID.getCode()); // 状态 4 = 已付款
        entity.setRefundReason(vo.getRefundReason()); // 退回原因
        service.saveOrUpdate(entity);
        return CommonResponse.success("确认收料成功！");
    }

    /**
     * description：回退付款报备单
     *
     * @param vo
     * @return {@code CommonResponse<String> }
     * @author niexiang
     * @date 2025/11/19
     */
    @RequestMapping(value = "payToReturn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> payToReturn(@RequestBody PayReportedVO vo) {
        PayReportedEntity entity = service.selectById(vo.getId());
        if (entity == null) {
            return CommonResponse.error("没有找到该单据！");
        }
        entity.setPaymentPersonId(vo.getPaymentPersonId()); // 付款人ID
        entity.setPaymentPersonName(vo.getPaymentPersonName()); // 付款人名称
        entity.setPaymentDate(vo.getPaymentDate()); // 付款日期
        entity.setPaymentState(PaymentStatusEnum.REFUNDED.getCode()); // 状态 4 = 退回
        entity.setRefundReason(vo.getRefundReason()); // 退回原因
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()); // 单据状态 0 = 自由态
        service.saveOrUpdate(entity);
        return CommonResponse.success("回退成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayReportedVO> queryDetail(Long id) {
    	PayReportedEntity entity = service.selectById(id);
    	PayReportedVO vo = BeanMapper.map(entity, PayReportedVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReportedVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayReportedVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayReportedVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayReportedVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("paymentCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PayReportedEntity> page = service.queryPage(param,false);
        IPage<PayReportedVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayReportedVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("paymentCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractCode");

        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PayReportedEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("PayReported-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPayData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayReportedVO>> refPayReportedData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        param.getFuzzyFields().add("paymentCode");
        param.getFuzzyFields().add("projectCode");
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("supplierCode");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("feeKindName");
        param.getFuzzyFields().add("contractCode");
        param.getFuzzyFields().add("feeKindName");

        // 搜索条件复制
        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter(QueryParam.LIKE, search.get(key).toString()));
            }
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        Page<PayReportedVO> page = new Page<>(pageNumber, pageSize);

        String sql = ParamUtil.getSqlBuild(param, "A1");

        List<PayReportedVO> list = service.queryRefPayData(page,sql);

        page.setRecords(list);

        return CommonResponse.success("查询参照数据成功！",page);
     }

}
