/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayReportedEntity;
import com.ejianc.business.finance.enums.PaymentStatusEnum;
import com.ejianc.business.finance.mapper.PayReportedMapper;
import com.ejianc.business.finance.service.IPayReportedService;
import com.ejianc.business.finance.service.impl.PayReportedBpmServiceImpl;
import com.ejianc.business.finance.vo.PayReportedVO;
import com.ejianc.business.finance.vo.RequestPaymentReportVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payReportedService")
public class PayReportedServiceImpl
extends BaseServiceImpl<PayReportedMapper, PayReportedEntity>
implements IPayReportedService {
    private static final ExecutorService executor = Executors.newFixedThreadPool(10);
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    private static final String BILL_CODE = "FKBB";
    private static final String BILL_TYPE_CODE = "BT251118000000001";
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private PayReportedBpmServiceImpl payReportedBpmService;

    @Override
    public List<PayReportedVO> queryRefPayData(Page<PayReportedVO> page, String sql) {
        return ((PayReportedMapper)this.baseMapper).queryRefPayData(page, sql);
    }

    @Override
    public void batchSaveReport(List<RequestPaymentReportVO> vo) {
        CommonResponse billTypeVOCommonResponse = this.billTypeApi.getByCode(BILL_TYPE_CODE);
        String billName = ((BillTypeVO)billTypeVOCommonResponse.getData()).getBillName();
        CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid(), vo.size());
        if (codeBatchByRuleCode.isSuccess()) {
            AtomicInteger codeIndex = new AtomicInteger(1);
            AtomicInteger entityIndex = new AtomicInteger(1);
            Map<Integer, String> codeMap = ((List)codeBatchByRuleCode.getData()).stream().collect(Collectors.toMap(item -> codeIndex.getAndIncrement(), item -> item));
            List<PayReportedEntity> payReportedEntityList = vo.stream().map(item -> {
                String billCode = (String)codeMap.get(entityIndex.getAndIncrement());
                PayReportedEntity payReportedEntity = PayReportedServiceImpl.ofPayReportedEntity(item);
                payReportedEntity.setBillCode(billCode);
                return payReportedEntity;
            }).collect(Collectors.toList());
            super.saveBatch(payReportedEntityList);
            this.batchDoSubmit(payReportedEntityList, billName);
        }
    }

    private static PayReportedEntity ofPayReportedEntity(RequestPaymentReportVO vo) {
        PayReportedEntity payReportedEntity = new PayReportedEntity();
        payReportedEntity.setOrgId(vo.getCashOutOrgId() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutOrgId())));
        payReportedEntity.setPaymentId(vo.getCashOutPaymentId() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutPaymentId())));
        payReportedEntity.setPaymentCode(vo.getCashOutPaymentCode());
        payReportedEntity.setProjectId(vo.getCashOutProjectId() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutProjectId())));
        payReportedEntity.setProjectCode(vo.getCashOutProjectCode());
        payReportedEntity.setProjectName(vo.getCashOutProjectName());
        payReportedEntity.setSupplierId(vo.getCashOutSupplierId() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutSupplierId())));
        payReportedEntity.setSupplierCode(vo.getCashOutSupplierCode());
        payReportedEntity.setSupplierName(vo.getCashOutSupplierName());
        payReportedEntity.setContractId(vo.getCashOutContractId() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutContractId())));
        payReportedEntity.setContractCode(vo.getCashOutContractCode());
        payReportedEntity.setContractName(vo.getCashOutContractName());
        payReportedEntity.setContractMny(vo.getCashOutContractAmount() == null ? null : new BigDecimal(vo.getCashOutContractAmount()));
        payReportedEntity.setProductName(vo.getCashOutLaborServiceName());
        payReportedEntity.setApproveTime(vo.getCashOutApproveTime());
        payReportedEntity.setApplyMny(vo.getCashOutApplyPaymentAmount() == null ? null : new BigDecimal(vo.getCashOutApplyPaymentAmount()));
        payReportedEntity.setFeeKind(vo.getCashOutFeeKind() == null ? null : Long.valueOf(Long.parseLong(vo.getCashOutFeeKind())));
        payReportedEntity.setFeeKindName(vo.getCashOutFeeKindName());
        payReportedEntity.setReportedPaymentTime(vo.getCashOutReportPaymentTime());
        payReportedEntity.setReason(vo.getCashOutUrgentReason());
        payReportedEntity.setEmployeeId(InvocationInfoProxy.getUserid());
        payReportedEntity.setEmployeeName(vo.getCashOutPayerName());
        payReportedEntity.setPaymentState(PaymentStatusEnum.REPORTING.getCode());
        return payReportedEntity;
    }

    private void batchDoSubmit(List<PayReportedEntity> payReportedEntityList, String billName) {
        Long userid = InvocationInfoProxy.getUserid();
        payReportedEntityList.forEach(item -> {
            String billInstanceName = this.generateBillInstanceName((PayReportedEntity)((Object)item), billName);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userId", userid);
            params.put("billtypeId", BILL_TYPE_CODE);
            params.put("businessKey", item.getId());
            params.put("formurl", "/ejc-finance-frontend/#/payReported");
            params.put("billOrgId", item.getOrgId());
            params.put("procInstName", billInstanceName);
            CompletableFuture.runAsync(() -> this.bpmApi.doSubmit(params), executor);
        });
    }

    private String generateBillInstanceName(PayReportedEntity payReportedEntity, String billName) {
        String now = DateUtil.now().replaceAll("-", "").replaceAll(":", "");
        return billName + "_" + payReportedEntity.getBillCode() + "_" + now;
    }

    @Override
    public List<PayReportedVO> queryRequestPaymentReportList(List<Long> paymentIds) {
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (Long paymentId : paymentIds) {
            if (paymentId == null) continue;
            sj.add(paymentId.toString());
        }
        String sql = "AND A1.paymentId IN " + sj;
        return ((PayReportedMapper)this.baseMapper).queryRefPayData(null, sql);
    }
}

