package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;

/**
 * 工人工资发放记录子表
 *
 * @author generator
 *
 */
public interface IPayRecordSalaryGrantService extends IBaseService<PayRecordSalaryGrantEntity> {

    /**
     * @description: 工资发放完后更新 申请工资汇总已支付金额
     *
     * @param payRecordSalaryGrantList
     * @param b
     * @return
     * @author songlx
     * @date: 2022/12/2
     */
    void writeBackLaborSalarySumPayMny(Long payapplyId, PayRecordEntity entity, List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList, boolean b);

    List<PayRecordSalaryGrantVO> querySalaryGrantVOPage(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page);

    List<PayRecordSalaryGrantVO> queryTeamSalaryGrantList(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page, List<Long> workerIds);

    /**
     * @description: 有合同
     * @return
     * @author songlx
     * @date: 2022/12/3
     */
    boolean payForGrant(PayRecordEntity entity, boolean hasContract, boolean isBatchPay);

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    boolean payForGrantNoCantract(PayRecordEntity entity, boolean b, boolean isBatchPay);
}
