/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractSummaryEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.bean.PaySporadicSummaryEntity;
import com.ejianc.business.finance.mapper.PayRecordSalaryGrantMapper;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSummaryService;
import com.ejianc.business.finance.service.IPayRecordSalaryGrantService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IPaySporadicSummaryService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="payRecordSalaryGrantService")
public class PayRecordSalaryGrantServiceImpl
extends BaseServiceImpl<PayRecordSalaryGrantMapper, PayRecordSalaryGrantEntity>
implements IPayRecordSalaryGrantService {
    @Autowired
    IPayContractSummaryService summaryService;
    @Autowired
    IPaySporadicSummaryService paySporadicSummaryService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayContractSummaryService payContractSummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";
    private final String SALARY_GRANT = "SALARY_GRANT";

    @Override
    public void writeBackLaborSalarySumPayMny(Long payapplyId, PayRecordEntity entity, List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList, boolean b) {
        for (PayRecordSalaryGrantEntity payRecordSalaryGrantEntity : payRecordSalaryGrantList) {
            Long salarySummaryId = payRecordSalaryGrantEntity.getSalarySummaryId();
            PayContractSummaryEntity payContractSummaryEntity = (PayContractSummaryEntity)((Object)this.summaryService.selectById(salarySummaryId));
            BigDecimal payMny = BigDecimal.ZERO;
            if (payContractSummaryEntity != null) {
                BigDecimal _payMny = payContractSummaryEntity.getPayMny();
                payMny = b ? MathUtil.safeAdd((BigDecimal)_payMny, (BigDecimal)payRecordSalaryGrantEntity.getPayMny()) : MathUtil.safeSub((BigDecimal)_payMny, (BigDecimal)payRecordSalaryGrantEntity.getPayMny());
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)salarySummaryId);
            updateWrapper.set(PayContractSummaryEntity::getPayMny, (Object)payMny);
            this.summaryService.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public List<PayRecordSalaryGrantVO> querySalaryGrantVOPage(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page) {
        return ((PayRecordSalaryGrantMapper)this.baseMapper).querySalaryGrantVOPage(wrapper, salaryMonth, page);
    }

    @Override
    public List<PayRecordSalaryGrantVO> queryTeamSalaryGrantList(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page, List<Long> workerIds) {
        return ((PayRecordSalaryGrantMapper)this.baseMapper).queryTeamSalaryGrantList(wrapper, salaryMonth, page, workerIds);
    }

    @Override
    public boolean payForGrant(PayRecordEntity entity, boolean hasContract, boolean isBatchPay) {
        this.fullGrantInfo(entity, 1, isBatchPay);
        this.recordService.saveOrUpdateNoES((Object)entity);
        this.writeBackLaborSalarySumPayMny(entity.getPayapplyId(), entity, entity.getPayRecordSalaryGrantList(), true);
        return true;
    }

    private void fullGrantInfo(PayRecordEntity entity, Integer source, boolean isBatchPay) {
        List<Object> payRecordSalaryGrantList = new ArrayList();
        if (!isBatchPay) {
            payRecordSalaryGrantList = entity.getPayRecordSalaryGrantList();
        } else {
            Long payapplyId = entity.getPayapplyId();
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.eq(PayContractSummaryEntity::getPayapplyId, (Object)payapplyId);
            List list = this.summaryService.list((Wrapper)wrapper);
            for (PayContractSummaryEntity summary : list) {
                PayRecordSalaryGrantEntity payRecordSalaryGrantEntity = new PayRecordSalaryGrantEntity();
                payRecordSalaryGrantEntity.setPayapplyId(payapplyId);
                payRecordSalaryGrantEntity.setSalarySummaryId(summary.getId());
                payRecordSalaryGrantEntity.setSalaryMonth(summary.getSalaryMonth());
                payRecordSalaryGrantEntity.setWorkerId(summary.getWorkerId());
                payRecordSalaryGrantEntity.setWorkerName(summary.getWorkerName());
                payRecordSalaryGrantEntity.setSex(summary.getSex());
                payRecordSalaryGrantEntity.setPhone(summary.getPhone());
                payRecordSalaryGrantEntity.setIdCard(summary.getIdCard());
                payRecordSalaryGrantEntity.setTeamId(summary.getTeamId());
                payRecordSalaryGrantEntity.setTeamName(summary.getTeamName());
                payRecordSalaryGrantEntity.setWorkType(summary.getWorkType());
                payRecordSalaryGrantEntity.setWorkTypeName(summary.getWorkTypeName());
                payRecordSalaryGrantEntity.setBankCard(summary.getBankCard());
                payRecordSalaryGrantEntity.setBankName(summary.getBankName());
                payRecordSalaryGrantEntity.setShouldSalaryMny(summary.getShouldSalaryMny());
                payRecordSalaryGrantEntity.setApplyMny(summary.getApplyMny());
                payRecordSalaryGrantEntity.setPayMny(ComputeUtil.safeSub((BigDecimal)summary.getApplyMny(), (BigDecimal)summary.getPayMny()));
                payRecordSalaryGrantEntity.setPayRatio(ComputeUtil.bigDecimalPercent((BigDecimal)payRecordSalaryGrantEntity.getPayMny(), (BigDecimal)payRecordSalaryGrantEntity.getApplyMny(), (int)2));
                payRecordSalaryGrantEntity.setMemo("\u6279\u91cf\u652f\u4ed8");
                payRecordSalaryGrantEntity.setRowState("add");
                payRecordSalaryGrantList.add((Object)payRecordSalaryGrantEntity);
            }
            entity.setPayRecordSalaryGrantList(payRecordSalaryGrantList);
        }
        if (CollectionUtils.isNotEmpty(payRecordSalaryGrantList)) {
            payRecordSalaryGrantList.removeIf(grantEntity -> ComputeUtil.equals((BigDecimal)grantEntity.getPayMny(), (BigDecimal)BigDecimal.ZERO));
            if (CollectionUtils.isNotEmpty(payRecordSalaryGrantList)) {
                Long tenantId = InvocationInfoProxy.getTenantid();
                List billCodeData = null;
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode("SALARY_GRANT", tenantId, payRecordSalaryGrantList.size());
                if (billCode.isSuccess()) {
                    billCodeData = (List)billCode.getData();
                }
                int i = 0;
                for (PayRecordSalaryGrantEntity payRecordSalaryGrantEntity : payRecordSalaryGrantList) {
                    payRecordSalaryGrantEntity.setBillCode((String)billCodeData.get(i));
                    payRecordSalaryGrantEntity.setContractId(entity.getContractId());
                    payRecordSalaryGrantEntity.setContractName(entity.getContractName());
                    payRecordSalaryGrantEntity.setAckFlag(0);
                    payRecordSalaryGrantEntity.setOrgId(entity.getOrgId());
                    payRecordSalaryGrantEntity.setOrgName(entity.getOrgName());
                    payRecordSalaryGrantEntity.setProjectId(entity.getProjectId());
                    payRecordSalaryGrantEntity.setProjectName(entity.getProjectName());
                    payRecordSalaryGrantEntity.setSupplierId(entity.getReceiveUnitId());
                    payRecordSalaryGrantEntity.setSupplierName(entity.getReceiveUnitName());
                    payRecordSalaryGrantEntity.setPayTime(new Date());
                    payRecordSalaryGrantEntity.setSource(source);
                    ++i;
                }
            }
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Long id = Long.parseLong(request.getParameter("sourceId"));
        String sourceType = request.getParameter("sourceType").toString();
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PayRecordSalaryGrantVO> successList = new ArrayList<PayRecordSalaryGrantVO>();
        ArrayList<PayRecordSalaryGrantVO> errorList = new ArrayList<PayRecordSalaryGrantVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 5) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            if (result.size() >= 10000) {
                throw new BusinessException("\u6587\u4ef6\u6570\u636e\u4e0d\u80fd\u8d85\u8fc710000\u884c\uff0c\u8d85\u8fc7\u8bf7\u5206\u6279\u6b21\u591a\u6b21\u5bfc\u5165");
            }
            HashMap<String, Integer> idCardMap = new HashMap<String, Integer>();
            HashMap<String, Integer> nameMap = new HashMap<String, Integer>();
            HashMap<String, Integer> bankCardMap = new HashMap<String, Integer>();
            HashMap<Long, Integer> payMap = new HashMap<Long, Integer>();
            StringBuilder errMsg = new StringBuilder();
            for (int i = 1; i < result.size(); ++i) {
                int rowNum = i + 2;
                List datas = (List)result.get(i);
                PayRecordSalaryGrantVO salaryDetailVO = new PayRecordSalaryGrantVO();
                if (datas.get(0) != null && StringUtils.isNotBlank((String)((String)datas.get(0)))) {
                    String name = ((String)datas.get(0)).trim();
                    if (!nameMap.containsKey(name)) {
                        nameMap.put(name, rowNum);
                    } else {
                        errMsg.append("`\u8868\u683c\u5185" + nameMap.get(name) + "\u884c\u4e0e" + rowNum + "\u884c\u59d3\u540d\u91cd\u590d`");
                    }
                    salaryDetailVO.setWorkerName(name);
                }
                if (datas.get(1) != null && StringUtils.isNotBlank((String)((String)datas.get(1)))) {
                    String idCard = ((String)datas.get(1)).trim();
                    if (!idCardMap.containsKey(idCard)) {
                        if (!idCard.matches(IdCardRegex)) {
                            errMsg.append("`\u586b\u5199\u8eab\u4efd\u8bc1\u53f7\u9519\u8bef`");
                        }
                        idCardMap.put(idCard, rowNum);
                    } else {
                        errMsg.append("`\u8868\u683c\u5185" + idCardMap.get(idCard) + "\u884c\u4e0e" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d`");
                    }
                    salaryDetailVO.setIdCard(idCard);
                }
                if (StringUtils.isNotBlank((String)((String)datas.get(2)))) {
                    String bankCard = ((String)datas.get(2)).trim();
                    if (!bankCardMap.containsKey(bankCard)) {
                        if (!bankCard.matches(regex)) {
                            errMsg.append("`\u94f6\u884c\u5361\u53f7\u586b\u5199\u9519\u8bef`");
                        }
                        bankCardMap.put(bankCard, rowNum);
                    } else {
                        errMsg.append("`\u8868\u683c\u5185" + bankCardMap.get(bankCard) + "\u884c\u4e0e" + rowNum + "\u884c\u94f6\u884c\u5361\u53f7\u91cd\u590d`");
                    }
                    salaryDetailVO.setBankCard(bankCard);
                }
                salaryDetailVO.setMemo((String)datas.get(3));
                if (StringUtils.isNotBlank((String)((String)datas.get(4)))) {
                    try {
                        salaryDetailVO.setPayMny(new BigDecimal((String)datas.get(4)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u672c\u671f\u652f\u4ed8\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u672c\u671f\u652f\u4ed8\u4e3a\u5fc5\u586b\u9879`");
                }
                if (StringUtils.isNotBlank((String)salaryDetailVO.getWorkerName()) || StringUtils.isNotBlank((String)salaryDetailVO.getIdCard()) || StringUtils.isNotBlank((String)salaryDetailVO.getBankCard())) {
                    BigDecimal surplusPayMny;
                    List list;
                    QueryWrapper objectQueryWrapper;
                    if (StringUtils.isBlank((String)sourceType)) {
                        objectQueryWrapper = new QueryWrapper();
                        objectQueryWrapper.eq((Object)"payapply_id", (Object)id);
                        objectQueryWrapper.eq(salaryDetailVO.getWorkerName() != null, (Object)"worker_name", (Object)salaryDetailVO.getWorkerName());
                        objectQueryWrapper.eq(salaryDetailVO.getIdCard() != null, (Object)"id_card", (Object)salaryDetailVO.getIdCard());
                        objectQueryWrapper.eq(salaryDetailVO.getBankCard() != null, (Object)"bank_card", (Object)salaryDetailVO.getBankCard());
                        list = this.payContractSummaryService.list((Wrapper)objectQueryWrapper);
                        if (list.size() == 0) {
                            errMsg.append("`\u672c\u884c\u672a\u5339\u914d\u5b50\u8868\u6570\u636e`");
                        } else if (list.size() > 1) {
                            errMsg.append("`\u5339\u914d\u591a\u884c\u5b50\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165`");
                        } else if (list.size() == 1) {
                            if (!payMap.containsKey(((PayContractSummaryEntity)((Object)list.get(0))).getId())) {
                                payMap.put(((PayContractSummaryEntity)((Object)list.get(0))).getId(), rowNum);
                                salaryDetailVO.setId(((PayContractSummaryEntity)((Object)list.get(0))).getId());
                                surplusPayMny = ComputeUtil.safeSub((BigDecimal)((PayContractSummaryEntity)((Object)list.get(0))).getApplyMny(), (BigDecimal)((PayContractSummaryEntity)((Object)list.get(0))).getPayMny());
                                if (ComputeUtil.isGreaterThan((BigDecimal)salaryDetailVO.getPayMny(), (BigDecimal)surplusPayMny)) {
                                    salaryDetailVO.setPayMny(surplusPayMny);
                                }
                            } else {
                                errMsg.append("`\u8868\u683c\u5185" + rowNum + "\u884c\u4e0e" + payMap.get(((PayContractSummaryEntity)((Object)list.get(0))).getId()) + "\u884c\u5339\u914d\u91cd\u590d`");
                            }
                        }
                    } else {
                        objectQueryWrapper = new QueryWrapper();
                        objectQueryWrapper.eq((Object)"payapply_id", (Object)id);
                        objectQueryWrapper.eq(salaryDetailVO.getWorkerName() != null, (Object)"worker_name", (Object)salaryDetailVO.getWorkerName());
                        objectQueryWrapper.eq(salaryDetailVO.getIdCard() != null, (Object)"id_card", (Object)salaryDetailVO.getIdCard());
                        objectQueryWrapper.eq(salaryDetailVO.getBankCard() != null, (Object)"bank_card", (Object)salaryDetailVO.getBankCard());
                        list = this.paySporadicSummaryService.list((Wrapper)objectQueryWrapper);
                        if (list.size() == 0) {
                            errMsg.append("`\u672c\u884c\u672a\u5339\u914d\u5b50\u8868\u6570\u636e`");
                        } else if (list.size() > 1) {
                            errMsg.append("`\u5339\u914d\u591a\u884c\u5b50\u8868\uff0c\u65e0\u6cd5\u5bfc\u5165`");
                        } else if (list.size() == 1) {
                            if (!payMap.containsKey(((PaySporadicSummaryEntity)((Object)list.get(0))).getId())) {
                                payMap.put(((PaySporadicSummaryEntity)((Object)list.get(0))).getId(), rowNum);
                                salaryDetailVO.setId(((PaySporadicSummaryEntity)((Object)list.get(0))).getId());
                                surplusPayMny = ComputeUtil.safeSub((BigDecimal)((PaySporadicSummaryEntity)((Object)list.get(0))).getApplyMny(), (BigDecimal)((PaySporadicSummaryEntity)((Object)list.get(0))).getPayMny());
                                if (ComputeUtil.isGreaterThan((BigDecimal)salaryDetailVO.getPayMny(), (BigDecimal)surplusPayMny)) {
                                    salaryDetailVO.setPayMny(surplusPayMny);
                                }
                            } else {
                                errMsg.append("`\u8868\u683c\u5185" + rowNum + "\u884c\u4e0e\u3001" + payMap.get(((PaySporadicSummaryEntity)((Object)list.get(0))).getId()) + "\u884c\u5339\u914d\u91cd\u590d`");
                            }
                        }
                    }
                } else {
                    errMsg.append("`\u59d3\u540d,\u8eab\u4efd\u8bc1\u53f7,\u94f6\u884c\u5361\u53f7\u6700\u5c11\u586b\u5199\u4e00\u4e2a`");
                }
                salaryDetailVO.setErrorMessage(errMsg.toString());
                if (StringUtils.isBlank((String)salaryDetailVO.getErrorMessage())) {
                    successList.add(salaryDetailVO);
                    continue;
                }
                errorList.add(salaryDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public boolean payForGrantNoCantract(PayRecordEntity entity, boolean b, boolean isBatchPay) {
        this.fullGrantInfo(entity, 2, isBatchPay);
        this.recordService.saveOrUpdateNoES((Object)entity);
        this.writeBackLaborSalarySumPayMnyNoContract(entity.getPayapplyId(), entity, entity.getPayRecordSalaryGrantList(), true);
        return true;
    }

    public void writeBackLaborSalarySumPayMnyNoContract(Long payapplyId, PayRecordEntity entity, List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList, boolean b) {
        for (PayRecordSalaryGrantEntity payRecordSalaryGrantEntity : payRecordSalaryGrantList) {
            Long salarySummaryId = payRecordSalaryGrantEntity.getSalarySummaryId();
            PaySporadicSummaryEntity paySporadicSummaryEntity = (PaySporadicSummaryEntity)((Object)this.paySporadicSummaryService.selectById(salarySummaryId));
            BigDecimal payMny = BigDecimal.ZERO;
            if (paySporadicSummaryEntity != null) {
                BigDecimal _payMny = paySporadicSummaryEntity.getPayMny();
                payMny = b ? MathUtil.safeAdd((BigDecimal)_payMny, (BigDecimal)payRecordSalaryGrantEntity.getPayMny()) : MathUtil.safeSub((BigDecimal)_payMny, (BigDecimal)payRecordSalaryGrantEntity.getPayMny());
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)salarySummaryId);
            updateWrapper.set(PaySporadicSummaryEntity::getPayMny, (Object)payMny);
            this.paySporadicSummaryService.update((Wrapper)updateWrapper);
        }
    }
}

