package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayContractSummaryEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.bean.PaySporadicSummaryEntity;
import com.ejianc.business.finance.mapper.PayRecordSalaryGrantMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 工人工资发放记录子表
 *
 * @author generator
 *
 */
@Service("payRecordSalaryGrantService")
public class PayRecordSalaryGrantServiceImpl extends BaseServiceImpl<PayRecordSalaryGrantMapper, PayRecordSalaryGrantEntity> implements IPayRecordSalaryGrantService {

    @Autowired
    IPayContractSummaryService summaryService;

    @Autowired
    IPaySporadicSummaryService paySporadicSummaryService;

    @Autowired
    private IPayContractService contractService;

    @Autowired
    private IPayRecordService recordService;

    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayContractSummaryService payContractSummaryService;


    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String regex = "^\\d{16}|\\d{19}$";
    private static final String IdCardRegex = "/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";

    //工资发放流水好
    private final String SALARY_GRANT = "SALARY_GRANT";

    /**
     * @param payapplyId
     * @param entity
     * @param payRecordSalaryGrantList
     * @param b
     * @return
     * @description: 工资发放完后更新 申请工资汇总已支付金额
     * @author songlx
     * @date: 2022/12/2
     */
    @Override
    public void writeBackLaborSalarySumPayMny(Long payapplyId, PayRecordEntity entity, List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList, boolean b) {

        for (PayRecordSalaryGrantEntity payRecordSalaryGrantEntity : payRecordSalaryGrantList) {
            Long salarySummaryId = payRecordSalaryGrantEntity.getSalarySummaryId();
            PayContractSummaryEntity payContractSummaryEntity = summaryService.selectById(salarySummaryId);
            BigDecimal payMny = BigDecimal.ZERO;
            if (payContractSummaryEntity != null) {
                BigDecimal _payMny = payContractSummaryEntity.getPayMny();
                // 本期付款金额   true为回写，false为逆回写
                payMny = b ? MathUtil.safeAdd(_payMny, payRecordSalaryGrantEntity.getPayMny()) : MathUtil.safeSub(_payMny, payRecordSalaryGrantEntity.getPayMny());
            }

            LambdaUpdateWrapper<PayContractSummaryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PayContractSummaryEntity::getId, salarySummaryId);
            updateWrapper.set(PayContractSummaryEntity::getPayMny, payMny);
            summaryService.update(updateWrapper);
        }
    }

    @Override
    public List<PayRecordSalaryGrantVO> querySalaryGrantVOPage(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page) {
        return baseMapper.querySalaryGrantVOPage(wrapper, salaryMonth, page);
    }

    @Override
    public List<PayRecordSalaryGrantVO> queryTeamSalaryGrantList(QueryWrapper wrapper, String salaryMonth, Page<PayRecordSalaryGrantVO> page, List<Long> workerIds) {
        return baseMapper.queryTeamSalaryGrantList(wrapper, salaryMonth, page, workerIds);
    }

    /**
     * @param entity
     * @param hasContract
     * @return
     * @description: 有合同
     * @author songlx
     * @date: 2022/12/3
     */
    @Override
    public boolean payForGrant(PayRecordEntity entity, boolean hasContract, boolean isBatchPay) {
        // 补充工资发放信息
        this.fullGrantInfo(entity, 1, isBatchPay);
        // 保存主表
        recordService.saveOrUpdateNoES(entity);
        // 确认支付 工资发放完后更新 申请工资汇总已支付金额
        this.writeBackLaborSalarySumPayMny(entity.getPayapplyId(), entity, entity.getPayRecordSalaryGrantList(), true);
        return true;
    }


    /**
     * @param entity
     * @param source     1工人工资合同付款 2工人工资零星付款
     * @param isBatchPay
     * @return
     * @description: 工资发放明细数据补充
     * @author songlx
     * @date: 2022/12/3
     */
    private void fullGrantInfo(PayRecordEntity entity, Integer source, boolean isBatchPay) {
        List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList = new ArrayList<>();
        if (!isBatchPay) {
            payRecordSalaryGrantList = entity.getPayRecordSalaryGrantList();
        } else {
            Long payapplyId = entity.getPayapplyId();
            LambdaUpdateWrapper<PayContractSummaryEntity> wrapper = new LambdaUpdateWrapper<>();
            wrapper.eq(PayContractSummaryEntity::getPayapplyId, payapplyId);
            List<PayContractSummaryEntity> list = summaryService.list(wrapper);

            for (PayContractSummaryEntity summary : list) {
                PayRecordSalaryGrantEntity grant = new PayRecordSalaryGrantEntity();
                grant.setPayapplyId(payapplyId);
                grant.setSalarySummaryId(summary.getId());
                grant.setSalaryMonth(summary.getSalaryMonth());
                grant.setWorkerId(summary.getWorkerId());
                grant.setWorkerName(summary.getWorkerName());
                grant.setSex(summary.getSex());
                grant.setPhone(summary.getPhone());
                grant.setIdCard(summary.getIdCard());
                grant.setTeamId(summary.getTeamId());
                grant.setTeamName(summary.getTeamName());
                grant.setWorkType(summary.getWorkType());
                grant.setWorkTypeName(summary.getWorkTypeName());
                grant.setBankCard(summary.getBankCard());
                grant.setBankName(summary.getBankName());
                grant.setShouldSalaryMny(summary.getShouldSalaryMny());
                grant.setApplyMny(summary.getApplyMny());
                grant.setPayMny(ComputeUtil.safeSub(summary.getApplyMny(), summary.getPayMny()));
                grant.setPayRatio(ComputeUtil.bigDecimalPercent(grant.getPayMny(), grant.getApplyMny(), 2));
                grant.setMemo("批量支付");
                grant.setRowState("add");
                payRecordSalaryGrantList.add(grant);
            }
            entity.setPayRecordSalaryGrantList(payRecordSalaryGrantList);
        }

        if (CollectionUtils.isNotEmpty(payRecordSalaryGrantList)) {
            //确认支付保存后，将子表本期支付金额不等于0的数据生成工资发放记录
            payRecordSalaryGrantList.removeIf(grantEntity -> ComputeUtil.equals(grantEntity.getPayMny(), BigDecimal.ZERO));
            if (CollectionUtils.isNotEmpty(payRecordSalaryGrantList)) {
                Long tenantId = InvocationInfoProxy.getTenantid();
                List<String> billCodeData = null;
                CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(SALARY_GRANT, tenantId, payRecordSalaryGrantList.size());
                if (billCode.isSuccess()) {
                    billCodeData = billCode.getData();
                }
                int i = 0;
                for (PayRecordSalaryGrantEntity grantEntity : payRecordSalaryGrantList) {
                    grantEntity.setBillCode(billCodeData.get(i));
                    grantEntity.setContractId(entity.getContractId());
                    grantEntity.setContractName(entity.getContractName());
                    // 确认标志，未确认
                    grantEntity.setAckFlag(0);
                    grantEntity.setOrgId(entity.getOrgId());
                    grantEntity.setOrgName(entity.getOrgName());
                    grantEntity.setProjectId(entity.getProjectId());
                    grantEntity.setProjectName(entity.getProjectName());
                    grantEntity.setSupplierId(entity.getReceiveUnitId());
                    grantEntity.setSupplierName(entity.getReceiveUnitName());
                    grantEntity.setPayTime(new Date());
                    //1工人工资合同付款 2工人工资零星付款
                    grantEntity.setSource(source);
                    i++;
                }
            }

        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Long id = Long.parseLong(request.getParameter("sourceId"));
        String sourceType = request.getParameter("sourceType").toString();
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PayRecordSalaryGrantVO> successList = new ArrayList<>();
            List<PayRecordSalaryGrantVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 5) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size() >= 10000) {
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                Map<String, Integer> idCardMap = new HashMap<>();
                Map<String, Integer> nameMap = new HashMap<>();
                Map<String, Integer> bankCardMap = new HashMap<>();
                //表数据中数据匹配相同一条
                Map<Long, Integer> payMap = new HashMap<>();
                StringBuilder errMsg = new StringBuilder();
                for (int i = 1; i < result.size(); i++) {
                    int rowNum = i + 2;
                    List<String> datas = result.get(i);
                    PayRecordSalaryGrantVO salaryDetailVO = new PayRecordSalaryGrantVO();
                    //姓名
                    if ((datas.get(0) != null) && (StringUtils.isNotBlank(datas.get(0)))) {
                        String name = datas.get(0).trim();
                        if (!nameMap.containsKey(name)) {
                            nameMap.put(name, rowNum);
                        } else {
                            errMsg.append("`表格内" + nameMap.get(name) + "行与" + rowNum + "行姓名重复`");
                        }
                        salaryDetailVO.setWorkerName(name);
                    }
                    //身份证号
                    if ((datas.get(1) != null) && (StringUtils.isNotBlank(datas.get(1)))) {
                        String idCard = datas.get(1).trim();
                        if (!idCardMap.containsKey(idCard)) {
                            if (!idCard.matches(IdCardRegex)) {
                                errMsg.append("`填写身份证号错误`");
                            }
                            idCardMap.put(idCard, rowNum);
                        } else {
                            errMsg.append("`表格内" + idCardMap.get(idCard) + "行与" + rowNum + "行身份证号重复`");
                        }
                        salaryDetailVO.setIdCard(idCard);
                    }

                    if (StringUtils.isNotBlank(datas.get(2))) {
                        String bankCard = datas.get(2).trim();
                        if (!bankCardMap.containsKey(bankCard)) {
                            if (!bankCard.matches(regex)) {
                                errMsg.append("`银行卡号填写错误`");
                            }
                            bankCardMap.put(bankCard, rowNum);
                        } else {
                            errMsg.append("`表格内" + bankCardMap.get(bankCard) + "行与" + rowNum + "行银行卡号重复`");
                        }
                        salaryDetailVO.setBankCard(bankCard);
                    }
                    //备注
                    salaryDetailVO.setMemo(datas.get(3));
                    //本期支付
                    if (StringUtils.isNotBlank(datas.get(4))) {
                        try {
                            salaryDetailVO.setPayMny(new BigDecimal(datas.get(4)));
                        } catch (Exception e) {
                            errMsg.append("`本期支付为必须为数字`");
                        }
                    } else {
                        errMsg.append("`本期支付为必填项`");
                    }
                    if (StringUtils.isNotBlank(salaryDetailVO.getWorkerName()) || StringUtils.isNotBlank(salaryDetailVO.getIdCard()) || StringUtils.isNotBlank(salaryDetailVO.getBankCard())) {
                        if (StringUtils.isBlank(sourceType)) {
                            QueryWrapper<PayContractSummaryEntity> objectQueryWrapper = new QueryWrapper<>();
                            objectQueryWrapper.eq("payapply_id", id);
                            objectQueryWrapper.eq(salaryDetailVO.getWorkerName() != null, "worker_name", salaryDetailVO.getWorkerName());
                            objectQueryWrapper.eq(salaryDetailVO.getIdCard() != null, "id_card", salaryDetailVO.getIdCard());
                            objectQueryWrapper.eq(salaryDetailVO.getBankCard() != null, "bank_card", salaryDetailVO.getBankCard());
                            List<PayContractSummaryEntity> list = payContractSummaryService.list(objectQueryWrapper);
                            if (list.size() == 0) {
                                errMsg.append("`本行未匹配子表数据`");
                            } else if (list.size() > 1) {
                                errMsg.append("`匹配多行子表，无法导入`");
                            } else if (list.size() == 1) {
                                if (!payMap.containsKey(list.get(0).getId())) {
                                    payMap.put(list.get(0).getId(), rowNum);
                                    salaryDetailVO.setId(list.get(0).getId());
                                    BigDecimal surplusPayMny = ComputeUtil.safeSub(list.get(0).getApplyMny(), list.get(0).getPayMny());
                                    if (ComputeUtil.isGreaterThan(salaryDetailVO.getPayMny(),surplusPayMny)){
                                        salaryDetailVO.setPayMny(surplusPayMny);
                                    }
                                } else {
                                    errMsg.append("`表格内" + rowNum + "行与" + payMap.get(list.get(0).getId()) + "行匹配重复`");
                                }
                            }
                        } else {
                            QueryWrapper<PaySporadicSummaryEntity> objectQueryWrapper = new QueryWrapper<>();
                            objectQueryWrapper.eq("payapply_id", id);
                            objectQueryWrapper.eq(salaryDetailVO.getWorkerName() != null, "worker_name", salaryDetailVO.getWorkerName());
                            objectQueryWrapper.eq(salaryDetailVO.getIdCard() != null, "id_card", salaryDetailVO.getIdCard());
                            objectQueryWrapper.eq(salaryDetailVO.getBankCard() != null, "bank_card", salaryDetailVO.getBankCard());
                            List<PaySporadicSummaryEntity> list = paySporadicSummaryService.list(objectQueryWrapper);
                            if (list.size() == 0) {
                                errMsg.append("`本行未匹配子表数据`");
                            } else if (list.size() > 1) {
                                errMsg.append("`匹配多行子表，无法导入`");
                            } else if (list.size() == 1) {
                                if (!payMap.containsKey(list.get(0).getId())) {
                                    payMap.put(list.get(0).getId(), rowNum);
                                    salaryDetailVO.setId(list.get(0).getId());
                                    BigDecimal surplusPayMny = ComputeUtil.safeSub(list.get(0).getApplyMny(), list.get(0).getPayMny());
                                    if (ComputeUtil.isGreaterThan(salaryDetailVO.getPayMny(),surplusPayMny)){
                                      salaryDetailVO.setPayMny(surplusPayMny);
                                    }
                                } else {
                                    errMsg.append("`表格内" + rowNum + "行与、" + payMap.get(list.get(0).getId()) + "行匹配重复`");
                                }
                            }
                        }

                    } else {
                        errMsg.append("`姓名,身份证号,银行卡号最少填写一个`");
                    }
                    salaryDetailVO.setErrorMessage(errMsg.toString());
                    if (StringUtils.isBlank(salaryDetailVO.getErrorMessage())) {
                        successList.add(salaryDetailVO);
                    } else {
                        errorList.add(salaryDetailVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }

    }

    @Override
    public boolean payForGrantNoCantract(PayRecordEntity entity, boolean b, boolean isBatchPay) {
        // 补充工资发放信息
        this.fullGrantInfo(entity, 2, isBatchPay);
        // 保存主表
        recordService.saveOrUpdateNoES(entity);
        // 确认支付 工资发放完后更新 申请工资汇总已支付金额
        this.writeBackLaborSalarySumPayMnyNoContract(entity.getPayapplyId(), entity, entity.getPayRecordSalaryGrantList(), true);
        return true;
    }


    /**
     * @description: 无合同支付金额回写
     *
     * @param payapplyId
     * @param entity
     * @param payRecordSalaryGrantList
     * @param b
     * @return
     * @author songlx
     * @date: 2022/12/7
     */
    public void writeBackLaborSalarySumPayMnyNoContract(Long payapplyId, PayRecordEntity entity, List<PayRecordSalaryGrantEntity> payRecordSalaryGrantList, boolean b) {

        for (PayRecordSalaryGrantEntity payRecordSalaryGrantEntity : payRecordSalaryGrantList) {
            Long salarySummaryId = payRecordSalaryGrantEntity.getSalarySummaryId();
            PaySporadicSummaryEntity paySporadicSummaryEntity = paySporadicSummaryService.selectById(salarySummaryId);
            BigDecimal payMny = BigDecimal.ZERO;
            if (paySporadicSummaryEntity != null) {
                BigDecimal _payMny = paySporadicSummaryEntity.getPayMny();
                // 本期付款金额   true为回写，false为逆回写
                payMny = b ? MathUtil.safeAdd(_payMny, payRecordSalaryGrantEntity.getPayMny()) : MathUtil.safeSub(_payMny, payRecordSalaryGrantEntity.getPayMny());
            }

            LambdaUpdateWrapper<PaySporadicSummaryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(PaySporadicSummaryEntity::getId, salarySummaryId);
            updateWrapper.set(PaySporadicSummaryEntity::getPayMny, payMny);
            paySporadicSummaryService.update(updateWrapper);
        }
    }
}
