package com.ejianc.business.finance.controller.api;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.vo.DeductionVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/deduction/")
public class DeductionApi {
    @Autowired
    private IDeductionService service;
    @RequestMapping(value = "/settleFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> settleFlag(@RequestBody List<DeductionVO> upList) {
        List<Long> collect = upList.stream().map(e -> e.getId()).collect(Collectors.toList());
        Integer settleFlag = upList.get(0).getSettleFlag();
        UpdateWrapper<DeductionEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.in("id", collect);
        updateWrapper.set("settle_flag", settleFlag);
        service.update(updateWrapper);
        return CommonResponse.success("修改成功");
    }
}
