package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;

/**
 * <p>
 * 保证金办理表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_deal")
public class BondDownDealEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    @TableField("bond_id")
    private Long bondId;

    /**
     * 保证函编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 保证金类型 0-投标保证金，1-履约保证金，2-质量保证金 
     */
    @TableField("bond_type")
    private Long bondType;

    /**
     * 保证金金额
     */
    @TableField("bond_mny")
    private BigDecimal bondMny;

    /**
     * 开具银行
     */
    @TableField("bank_names")
    private String bankNames;

    /**
     * 开立时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("begin_date")
    private Date beginDate;

    /**
     * 有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField("end_date")
    private Date endDate;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("deal_date")
    private Date dealDate;

    /**
     * 办理状态:1-生效，2-已作废
     */
    @TableField("deal_status")
    private String dealStatus;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("deal_time")
    private Date dealTime;
    @TableField(value="account_name")
    private String accountName; // 账户名
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="account_id")
    private Long accountId; // 账户名
    /**
     * 经办人
     */
    @TableField("employee_name")
    private String employeeName;

    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getBondType() {
        return bondType;
    }

    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }

    public BigDecimal getBondMny() {
        return bondMny;
    }

    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    public String getBankNames() {
        return bankNames;
    }

    public void setBankNames(String bankNames) {
        this.bankNames = bankNames;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getDealDate() {
        return dealDate;
    }

    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }
    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

}
