package com.ejianc.business.bank.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 账户调拨
 * 
 * @author generator
 * 
 */
 @TableName("ejc_bank_allocate")
public class BankAllocateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="title")
    private String title; // 标题
    @TableField(value="account_out_id")
    private Long accountOutId; // 调出账户
    @TableField(value="account_out_name")
    private String accountOutName; // 调出账户名称
    @TableField(value="account_out_bank")
    private String accountOutBank; // 开户行（调出账户）
    @TableField(value="account_out_num")
    private String accountOutNum; // 账号（调出账户）
    @TableField(value="account_in_id")
    private Long accountInId; // 调入账户
    @TableField(value="account_in_name")
    private String accountInName; // 调入账户名称
    @TableField(value="account_in_bank")
    private String accountInBank; // 开户行（调入账户）
    @TableField(value="account_in_num")
    private String accountInNum; // 账号（调入账户）
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="allocate_mny")
    private BigDecimal allocateMny; // 调拨金额
    @TableField(value="allocate_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date allocateDate; // 调拨日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    
    
    

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public Long getAccountOutId() {
        return accountOutId;
    }

    public void setAccountOutId(Long accountOutId) {
        this.accountOutId = accountOutId;
    }
    public String getAccountOutName() {
        return accountOutName;
    }

    public void setAccountOutName(String accountOutName) {
        this.accountOutName = accountOutName;
    }
    public String getAccountOutBank() {
        return accountOutBank;
    }

    public void setAccountOutBank(String accountOutBank) {
        this.accountOutBank = accountOutBank;
    }
    public String getAccountOutNum() {
        return accountOutNum;
    }

    public void setAccountOutNum(String accountOutNum) {
        this.accountOutNum = accountOutNum;
    }
    public Long getAccountInId() {
        return accountInId;
    }

    public void setAccountInId(Long accountInId) {
        this.accountInId = accountInId;
    }
    public String getAccountInName() {
        return accountInName;
    }

    public void setAccountInName(String accountInName) {
        this.accountInName = accountInName;
    }
    public String getAccountInBank() {
        return accountInBank;
    }

    public void setAccountInBank(String accountInBank) {
        this.accountInBank = accountInBank;
    }
    public String getAccountInNum() {
        return accountInNum;
    }

    public void setAccountInNum(String accountInNum) {
        this.accountInNum = accountInNum;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getAllocateMny() {
        return allocateMny;
    }

    public void setAllocateMny(BigDecimal allocateMny) {
        this.allocateMny = allocateMny;
    }
    public Date getAllocateDate() {
        return allocateDate;
    }

    public void setAllocateDate(Date allocateDate) {
        this.allocateDate = allocateDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
