/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="loadReimburse")
public class LoadReimburseBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u501f\u6b3e\u62a5\u9500\u5ba1\u6279\u540e\u4e8b\u4ef6\u89e6\u53d1");
        this.logger.info("billId" + billId);
        LoadReimburseEntity loadReimburseEntity = (LoadReimburseEntity)((Object)this.loadReimburseService.selectById(billId));
        this.loadReimburseService.costPush(loadReimburseEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!res.isSuccess()) {
            return CommonResponse.error((String)res.getMsg());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse commonResponse = this.costDetailApi.checkShareFlag(billId);
        if (!commonResponse.isSuccess()) {
            return CommonResponse.error((String)commonResponse.getMsg());
        }
        this.loadReimburseService.pullCost(billId);
        return CommonResponse.success();
    }
}

