package com.ejianc.business.finance.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_up_back")
public class BondUpBackEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    @TableField("bond_id")
    private Long bondId;

    /**
     * 退还编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 退还金额
     */
    @TableField("back_mny")
    private BigDecimal backMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 办理时间
     */
    @TableField("back_time")
    private Date backTime;

    /**
     * 经办人
     */
    @TableField("employee_name")
    private String employeeName;
    @TableField(value="account_name")
    private String accountName; // 账户名
    @TableField(value="account_num")
    private String accountNum; // 银行账号
    @TableField(value="account_bank")
    private String accountBank; // 开户行
    @TableField(value="account_id")
    private Long accountId; // 账户名

    @TableField("bond_code")
    private String bondCode; //保证金编号 1

    @TableField("contract_name")
    private String contractName;// 合同名称 1

    @TableField("contract_id")
    private String contractId;//合同ID 1

    @TableField(value = "org_id")
    private Long orgId; // 组织 1

    @TableField(value = "org_name")
    private String orgName; // 组织名称 1

    @TableField(value = "project_id")
    private Long projectId; // 项目 1

    @TableField(value = "project_name")
    private String projectName; // 项目名称 1

    @TableField(value = " bond_pay_mny")
    private BigDecimal bondPayMny;//保证金金额 1

    @TableField(value = "return_pay_mny")
    private BigDecimal returnPayMny;//已退还金额 1

    @TableField(value = "bill_state")
    private Integer billState; // 单据状态1

    @TableField(value="customer_id")
    private Long customerId; // 客户id

    @TableField(value="customer_name")
    private String customerName; // 客户名称


    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBondCode() {
        return bondCode;
    }

    public void setBondCode(String bondCode) {
        this.bondCode = bondCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getBondPayMny() {
        return bondPayMny;
    }

    public void setBondPayMny(BigDecimal bondPayMny) {
        this.bondPayMny = bondPayMny;
    }

    public BigDecimal getReturnPayMny() {
        return returnPayMny;
    }

    public void setReturnPayMny(BigDecimal returnPayMny) {
        this.returnPayMny = returnPayMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
