package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.mapper.PayRecordMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 付款申请记录实体
 *
 * @author generator
 *
 */
@Service("payRecordService")
public class PayRecordServiceImpl extends BaseServiceImpl<PayRecordMapper, PayRecordEntity> implements IPayRecordService {

    @Autowired
    private IPayContractService contractService;

    @Autowired
    private IPaySporadicService sporadicService;

    @Autowired
    private IPayReimburseService reimburseService;

    @Autowired
    private IPayForegiftService foregiftService;

    @Autowired
    private ILoadApplyService loadApplyService;

    @Autowired
    private IPayContractSettleService contracctSettleService;

    @Autowired
    private IPayRecordSettleService settleService;

    @Autowired
    private ISubContractForPayApi subApi;

    @Autowired
    private IEquipmentContractApi equipmentApi;

    @Autowired
    private IMaterialSettlementApi materialApi;

    @Autowired
    private IRmatContractApi rmatContractApi;

    @Autowired
    private IOtherContractApi otherContractApi;

    @Autowired
    private IPayRecordSalaryGrantService payRecordSalaryGrantService;

    @Autowired
    private PayRecordMessageService payRecordMessageService;
    @Autowired
    private IPayRecordService payRecordService;

    @Autowired
    private IBankFlowService bankFlowService;

    @Override
    public PayRecordVO insertOrUpdate(PayRecordVO vo, boolean isBatchPay) {
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);

        BankFlowVO bankFlowVO = null;
        BigDecimal msgPayMny = BigDecimal.ZERO;
        if ("合同付款".equals(vo.getApplyType())) {
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.支出合同付款);
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setTradeAccountName(contract.getAccountName());
            bankFlowVO.setTradeAccountNum(contract.getAccountNum());
            bankFlowVO.setTradeAccountBank(contract.getAccountBank());

            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());
            // 合同
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());// 合同类型
            entity.setContractTypeExtend(contract.getContractTypeExtend());// 合同类型拓展字段
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            //付款-预付款
            entity.setExplanation(contract.getPayReason()); // 付款事由
            // 保存主表
            super.saveOrUpdate(entity);
            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = contract.getPayMny();

            // 查询付款记录
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
            if (payRecordEntity != null) {
                contract.setPayAccountName(payRecordEntity.getAccountName());
                contract.setPayAccountNum(payRecordEntity.getAccountNum());
                contract.setPayAccountBank(payRecordEntity.getAccountBank());
            }

            // 保存
            contractService.saveOrUpdate(contract);
            // 计算结算单支付金额并保存
            List<PayRecordSettleEntity> settleList = this.calculateSettlePayMny(entity);

            // 确认支付回写累计付款与累计预付款金额
            this.writeBackSumPayMny(entity.getPayapplyId(), entity, settleList, true);
        } else if ("工人工资-有合同".equals(vo.getApplyType())) {
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.支出合同付款);
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setTradeAccountName(contract.getAccountName());
            bankFlowVO.setTradeAccountNum(contract.getAccountNum());
            bankFlowVO.setTradeAccountBank(contract.getAccountBank());

            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());
            // 合同
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());// 合同类型
            entity.setContractTypeExtend(contract.getContractTypeExtend());// 合同类型拓展字段
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());
            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额

            // 查询付款记录
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
            if (payRecordEntity != null) {
                contract.setPayAccountName(payRecordEntity.getAccountName());
                contract.setPayAccountNum(payRecordEntity.getAccountNum());
                contract.setPayAccountBank(payRecordEntity.getAccountBank());
            }

            // 保存
            contractService.saveOrUpdate(contract);
            payRecordSalaryGrantService.payForGrant(entity, true, isBatchPay);

        } else if ("工人工资-无合同".equals(vo.getApplyType())) {
            PaySporadicEntity sporadic = sporadicService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.零星付款);
            bankFlowVO.setTradeOrgId(sporadic.getApplyUserId());
            bankFlowVO.setTradeOrgName(sporadic.getApplyUserName());
            bankFlowVO.setTradeAccountName(sporadic.getAccountName());
            bankFlowVO.setTradeAccountNum(sporadic.getAccountNum());
            bankFlowVO.setTradeAccountBank(sporadic.getAccountBank());


            entity.setBillCode(sporadic.getBillCode());// 单据编号
            entity.setProjectId(sporadic.getProjectId());// 项目
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());// 组织
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());// 申请人
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());// 申请时间
            entity.setApplyMny(sporadic.getApplyMny());// 申请金额

            sporadic.setPayStatus(2);// 已支付
            sporadic.setConfirmTime(entity.getConfirmTime());// 确认时间
            sporadic.setEmployeeId(entity.getEmployeeId());// 经办人
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd(sporadic.getPayMny(), entity.getThisPayMny()));// 累计支付金额

            // 查询付款记录
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
            if (payRecordEntity != null) {
                sporadic.setPayAccountName(payRecordEntity.getAccountName());
                sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
                sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
            }

            // 保存
            sporadicService.saveOrUpdate(sporadic);
            payRecordSalaryGrantService.payForGrantNoCantract(entity, false, isBatchPay);
            // 推送成本
            sporadicService.costPush(sporadic);

        } else if ("零星采购".equals(vo.getApplyType())) {
            PaySporadicEntity sporadic = sporadicService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.零星付款);
            bankFlowVO.setTradeOrgId(sporadic.getSupplierId());
            bankFlowVO.setTradeOrgName(sporadic.getSupplierName());
            bankFlowVO.setTradeAccountName(sporadic.getAccountName());
            bankFlowVO.setTradeAccountNum(sporadic.getAccountNum());
            bankFlowVO.setTradeAccountBank(sporadic.getAccountBank());

            entity.setBillCode(sporadic.getBillCode());// 单据编号
            entity.setProjectId(sporadic.getProjectId());// 项目
            entity.setProjectName(sporadic.getProjectName());
            entity.setOrgId(sporadic.getOrgId());// 组织
            entity.setOrgName(sporadic.getOrgName());
            entity.setApplyUserId(sporadic.getApplyUserId());// 申请人
            entity.setApplyUserName(sporadic.getApplyUserName());
            entity.setApplyTime(sporadic.getApplyTime());// 申请时间
            entity.setApplyMny(sporadic.getApplyMny());// 申请金额
            entity.setExplanation(sporadic.getPayReason()); // 付款事由
            // 保存主表
            this.saveOrUpdateNoES(entity);

            sporadic.setPayStatus(2);// 已支付
            sporadic.setConfirmTime(entity.getConfirmTime());// 确认时间
            sporadic.setEmployeeId(entity.getEmployeeId());// 经办人
            sporadic.setEmployeeName(entity.getEmployeeName());
            sporadic.setPayMny(MathUtil.safeAdd(sporadic.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = sporadic.getPayMny();

            // 查询付款记录
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
            queryParam.getOrderMap().put("createTime", "desc");
            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
            wrapper.last("limit 1");
            PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
            if (payRecordEntity != null) {
                sporadic.setPayAccountName(payRecordEntity.getAccountName());
                sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
                sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
            }

            // 保存
            sporadicService.saveOrUpdate(sporadic);
            // 推送成本
            sporadicService.costPush(sporadic);

        } else if ("报销".equals(vo.getApplyType())) {
            PayReimburseEntity reimburse = reimburseService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.费用报销);
            bankFlowVO.setTradeOrgId(reimburse.getApplyUserId());
            bankFlowVO.setTradeOrgName(reimburse.getApplyUserName());
            bankFlowVO.setTradeAccountName(reimburse.getAccountName());
            bankFlowVO.setTradeAccountNum(reimburse.getAccountNum());
            bankFlowVO.setTradeAccountBank(reimburse.getAccountBank());

            entity.setBillCode(reimburse.getBillCode());// 单据编号
            entity.setProjectId(reimburse.getProjectId());// 项目
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());// 组织
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());// 申请人
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());// 申请时间
            entity.setApplyMny(reimburse.getApplyMny());// 申请金额
            entity.setFeeType(reimburse.getFeeType());//付款类型
            entity.setExplanation(reimburse.getPayReason()); // 付款事由
            // 保存主表
            super.saveOrUpdate(entity);
            reimburse.setPayStatus(2);// 已支付
            reimburse.setConfirmTime(entity.getConfirmTime());// 确认时间
            reimburse.setEmployeeId(entity.getEmployeeId());// 经办人
            reimburse.setEmployeeName(entity.getEmployeeName());
            reimburse.setPayMny(MathUtil.safeAdd(reimburse.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = reimburse.getPayMny();
            // 保存
            reimburseService.saveOrUpdate(reimburse);
            // 推送成本
            reimburseService.costPush(reimburse);

        } else if ("押金".equals(vo.getApplyType())) {
            PayForegiftEntity foregift = foregiftService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.押金付款);
            bankFlowVO.setTradeOrgId(foregift.getApplyUserId());
            bankFlowVO.setTradeOrgName(foregift.getApplyUserName());
            bankFlowVO.setTradeAccountName(foregift.getAccountName());
            bankFlowVO.setTradeAccountNum(foregift.getAccountNum());
            bankFlowVO.setTradeAccountBank(foregift.getAccountBank());

            entity.setBillCode(foregift.getBillCode());// 单据编号
            entity.setContractId(foregift.getContractId());
            // 合同
            entity.setContractName(foregift.getContractName());
            entity.setContractType(foregift.getContractType());// 合同类型
            entity.setContractTypeExtend(foregift.getContractTypeExtend());// 合同类型拓展字段
            entity.setProjectId(foregift.getProjectId());// 项目
            entity.setProjectName(foregift.getProjectName());
            entity.setOrgId(foregift.getOrgId());// 组织
            entity.setOrgName(foregift.getOrgName());
            entity.setApplyUserId(foregift.getApplyUserId());// 申请人
            entity.setApplyUserName(foregift.getApplyUserName());
            entity.setApplyTime(foregift.getApplyTime());// 申请时间
            entity.setApplyMny(foregift.getApplyMny());// 申请金额
            entity.setReceiveUnitId(foregift.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(foregift.getReceiveUnitName());
            // 保存主表
            super.saveOrUpdate(entity);
            foregift.setPayStatus(2);// 已支付
            foregift.setConfirmTime(entity.getConfirmTime());// 确认时间
            foregift.setEmployeeId(entity.getEmployeeId());// 经办人
            foregift.setEmployeeName(entity.getEmployeeName());
            foregift.setPayMny(MathUtil.safeAdd(foregift.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = foregift.getPayMny();
            // 保存
            foregiftService.saveOrUpdate(foregift);
        } else if("备用金".equals(vo.getApplyType())) {
            LoadApplyEntity loadApplyEntity = loadApplyService.selectById(entity.getPayapplyId());

            bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.备用金付款);
            bankFlowVO.setTradeOrgId(loadApplyEntity.getApplyEmployeeId());
            bankFlowVO.setTradeOrgName(loadApplyEntity.getApplyEmployeeName());
            bankFlowVO.setTradeAccountName(loadApplyEntity.getAccountName());
            bankFlowVO.setTradeAccountNum(loadApplyEntity.getBankAccount());
            bankFlowVO.setTradeAccountBank(loadApplyEntity.getBankName());

            entity.setBillCode(loadApplyEntity.getBillCode());// 单据编号
            entity.setProjectId(loadApplyEntity.getProjectId());// 项目
            entity.setProjectName(loadApplyEntity.getProjectName());
            entity.setOrgId(loadApplyEntity.getOrgId());// 组织
            entity.setOrgName(loadApplyEntity.getOrgName());
            entity.setApplyUserId(loadApplyEntity.getApplyEmployeeId());// 申请人
            entity.setApplyUserName(loadApplyEntity.getApplyEmployeeName());
            entity.setApplyTime(loadApplyEntity.getApplyTime());// 申请时间
            entity.setApplyMny(loadApplyEntity.getApplyMny());// 申请金额
            // 保存主表
            super.saveOrUpdate(entity);

            loadApplyEntity.setPayStatus(2);// 已支付
            loadApplyEntity.setConfirmTime(entity.getConfirmTime());// 确认时间
            loadApplyEntity.setEmployeeId(entity.getEmployeeId());// 经办人
            loadApplyEntity.setEmployeeName(entity.getEmployeeName());
            loadApplyEntity.setPayMny(MathUtil.safeAdd(loadApplyEntity.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = loadApplyEntity.getPayMny();
            // 保存
            loadApplyService.saveOrUpdate(loadApplyEntity);
        }
        bankFlowVO.setOrgId(entity.getOrgId());
        bankFlowVO.setOrgName(entity.getOrgName());
        bankFlowVO.setSourceId(entity.getId());
        bankFlowVO.setBillId(entity.getPayapplyId());
        bankFlowVO.setBillCode(entity.getBillCode());
        bankFlowVO.setBillDate(entity.getConfirmTime());
        bankFlowVO.setAccountId(entity.getAccountId());
        bankFlowVO.setAccountName(entity.getAccountName());
        bankFlowVO.setAccountNum(entity.getAccountNum());
        bankFlowVO.setAccountBank(entity.getAccountBank());
        bankFlowVO.setPayMoney(entity.getThisPayMny());
        bankFlowVO.setMemo(entity.getMemo());
        bankFlowService.saveFlowVO(bankFlowVO);
        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);
        payRecordVO.setMsgPayMny(msgPayMny);//含本期累计支付金额
        payRecordVO.setMsgBillCode(entity.getBillCode());
        payRecordVO.setMsgId(entity.getId());
        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
        payRecordMessageService.sendMsg(payRecordVO, receivers, NoticeEnum.PAY_SUCCESS);
        return payRecordVO;
    }


    /**
     * 计算结算单支付金额并保存
     * @param entity
     */
    private List<PayRecordSettleEntity> calculateSettlePayMny(PayRecordEntity entity) {
        BigDecimal pendPayMny = entity.getThisPayMny();// 待结算单分摊付款金额。初始值为本期支付金额
        List<PayContractSettleEntity> contractSettleList = contracctSettleService.list(new QueryWrapper<PayContractSettleEntity>().eq("payapply_id", entity.getPayapplyId()));
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        for (PayContractSettleEntity contractSettle : contractSettleList) {
            BigDecimal surplusPayMny = MathUtil.safeSub(contractSettle.getBodyApplyMny(), contractSettle.getSumPayMny());// 剩余可支付金额
            // 如果有待支付且该结算单有剩余可支付金额
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0 && MathUtil.safeCompareTo(surplusPayMny, BigDecimal.ZERO) > 0) {
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                if (MathUtil.safeCompareTo(pendPayMny, surplusPayMny) > 0) {// 待支付大于剩余可支付
                    settle.setSettlePayMny(surplusPayMny);// 支付剩余可支付金额
                } else {
                    settle.setSettlePayMny(pendPayMny);// 支付所有待支付金额
                }
                pendPayMny = MathUtil.safeSub(pendPayMny, settle.getSettlePayMny());// 待支付减去已支付金额
                contractSettle.setSumPayMny(MathUtil.safeAdd(contractSettle.getSumPayMny(), settle.getSettlePayMny()));// 结算单累计已支付金额
                settleLsit.add(settle);
            }
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            settleService.saveOrUpdateBatch(settleLsit);
            contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }

    /**
     * 回写合同累计付款、累计预付款金额与结算单累计付款金额
     * @param billId
     * @param entity
     * @param settleList
     * @param flag
     */
    public boolean writeBackSumPayMny(Long billId, PayRecordEntity entity, List<PayRecordSettleEntity> settleList, boolean flag) {
        // 本期付款金额   true为回写，false为逆回写
        BigDecimal payMny = flag ? entity.getThisPayMny() : MathUtil.safeSub(new BigDecimal(0), entity.getThisPayMny());
        // 预付款时等于本期付款金额
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
//        List<PayRecordSettleEntity> settleList = settleService.list(new QueryWrapper<PayRecordSettleEntity>().eq("record_id", billId));
        // 结算单对应本期申请金额
        Map<Long, BigDecimal> settleMnyMap = new HashMap<>();
        BigDecimal pendPayMny = payMny;// 待结算单分摊付款金额。初始值为本期支付金额
        for (PayRecordSettleEntity settle : settleList) {
            // 本期申请金额   true为回写，false为逆回写
            BigDecimal applyMny = flag ? settle.getSettlePayMny() : MathUtil.safeSub(new BigDecimal(0), settle.getSettlePayMny());
            settleMnyMap.put(settle.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1) {//分包
            subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                subApi.updateSubSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 3) {//设备租赁
            equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 4) {//物资采购
            for (PayRecordSettleEntity settle : settleList) {
                materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 5) {//物资租赁
            rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settleEntity : settleList) {
                rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), settleMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 6) {//其它支出
            otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settleEntity : settleList) {
                otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), settleMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }


    /**
     * 付款退回
     *
     * @param vo 付款申请记录
     *
     * @return {@link PayRecordVO}
     */
    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        BigDecimal msgPayMny = BigDecimal.ZERO;
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
        if ("合同付款".equals(vo.getApplyType())) {
            // 增加一个负数的付款记录单；
            entity.setThisPayMny(entity.getThisPayMny().negate());
            PayContractEntity contract = contractService.selectById(entity.getPayapplyId());
            entity.setBillCode(contract.getBillCode());// 单据编号
            entity.setContractId(contract.getContractId());// 合同
            entity.setContractName(contract.getContractName());
            entity.setContractType(contract.getContractType());// 合同类型
            entity.setProjectId(contract.getProjectId());// 项目
            entity.setProjectName(contract.getProjectName());
            entity.setOrgId(contract.getOrgId());// 组织
            entity.setOrgName(contract.getOrgName());
            entity.setApplyUserId(contract.getApplyUserId());// 申请人
            entity.setApplyUserName(contract.getApplyUserName());
            entity.setApplyTime(contract.getApplyTime());// 申请时间
            entity.setApplyMny(contract.getApplyMny());// 申请金额
            entity.setReceiveUnitId(contract.getReceiveUnitId());// 收款单位
            entity.setReceiveUnitName(contract.getReceiveUnitName());
            entity.setFeeType(contract.getFeeType());//付款-预付款
            entity.setExplanation(contract.getPayReason()); // 付款事由
            super.saveOrUpdate(entity);

            // 退回后回写合同付款申请单
            contract.setPayStatus(2);// 已支付
            contract.setConfirmTime(entity.getConfirmTime());// 确认时间
            contract.setEmployeeId(entity.getEmployeeId());// 经办人
            contract.setEmployeeName(entity.getEmployeeName());
            // 【已付款金额】修改为【已付款金额】-【退回金额】 即：【已付款金额】=【已付款金额】+ （-【退回金额】）
            contract.setPayMny(MathUtil.safeAdd(contract.getPayMny(), entity.getThisPayMny()));// 累计支付金额
            msgPayMny = contract.getPayMny();
//            // 查询付款记录
//            QueryParam queryParam = new QueryParam();
//            queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
//            queryParam.getOrderMap().put("createTime", "desc");
//            QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
//            wrapper.last("limit 1");
//            PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
//            if (payRecordEntity != null) {
//                contract.setPayAccountName(payRecordEntity.getAccountName());
//                contract.setPayAccountNum(payRecordEntity.getAccountNum());
//                contract.setPayAccountBank(payRecordEntity.getAccountBank());
//            }
            contractService.saveOrUpdate(contract);

            // 付款退回修改表体每个结算单的【本期支付金额】：按照结算单时间，后进先出进行回退重新分摊
            List<PayRecordSettleEntity> settleList = this.calcSettlePayMnyAfterReturnPayment(entity);

            // 确认支付回写累计付款与累计预付款金额
            this.writeBackSumPayMnyAfterReturnPayment(entity, settleList);

            // 付款关闭
            if (vo.getClosed()) {
                contractService.closePayment(vo.getPayapplyId());
            }

            BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.付款退还, "合同付款退回");
            bankFlowVO.setTradeOrgId(contract.getReceiveUnitId());
            bankFlowVO.setTradeOrgName(contract.getReceiveUnitName());
            bankFlowVO.setOrgId(entity.getOrgId());
            bankFlowVO.setOrgName(entity.getOrgName());
            bankFlowVO.setSourceId(entity.getId());
            bankFlowVO.setBillId(entity.getPayapplyId());
            bankFlowVO.setBillCode(entity.getBillCode());
            bankFlowVO.setBillDate(entity.getConfirmTime());
            bankFlowVO.setAccountId(entity.getAccountId());
            bankFlowVO.setAccountName(entity.getAccountName());
            bankFlowVO.setAccountNum(entity.getAccountNum());
            bankFlowVO.setAccountBank(entity.getAccountBank());
            bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
            bankFlowVO.setMemo(entity.getMemo());
            bankFlowService.saveFlowVO(bankFlowVO);
        }
        //支付成功后发送消息给申请人
        PayRecordVO payRecordVO = BeanMapper.map(entity, PayRecordVO.class);
//        payRecordVO.setMsgPayMny(msgPayMny);//含本期累计支付金额
//        payRecordVO.setMsgBillCode(entity.getBillCode());
//        payRecordVO.setMsgId(entity.getId());
//        String[] receivers = String.valueOf(payRecordVO.getApplyUserId()).split(",");
//        payRecordMessageService.sendMsg(payRecordVO, receivers, NoticeEnum.PAY_SUCCESS);
        return payRecordVO;
    }

    /**
     * 付款退回后重新分摊
     *
     * @param entity 付款申请记录
     *
     * @return {@link List}<{@link PayRecordSettleEntity}>
     */
    private List<PayRecordSettleEntity> calcSettlePayMnyAfterReturnPayment(PayRecordEntity entity) {
        List<PayRecordSettleEntity> settleLsit = new ArrayList<>();
        BigDecimal pendPayMny = entity.getThisPayMny().negate();// 待结算单分摊付款金额。初始值为本期支付金额
        // 按照结算单时间，后进先出进行回退
        List<PayContractSettleEntity> contractSettleList = contracctSettleService.list(new LambdaQueryWrapper<PayContractSettleEntity>()
                .eq(PayContractSettleEntity::getPayapplyId, entity.getPayapplyId())
                .orderByDesc(PayContractSettleEntity::getCreateTime));

        for (PayContractSettleEntity contractSettle : contractSettleList) {
            if (MathUtil.safeCompareTo(pendPayMny, BigDecimal.ZERO) > 0) {
                PayRecordSettleEntity settle = new PayRecordSettleEntity();
                settle.setRecordId(entity.getId());
                settle.setPayapplyId(entity.getPayapplyId());
                settle.setSettleId(contractSettle.getSettleId());
                settle.setSettleApplyMny(contractSettle.getBodyApplyMny());
                // 够摊
                if (MathUtil.safeCompareTo(contractSettle.getSumPayMny(), pendPayMny) >= 0) {
                    settle.setReturnPayMny(pendPayMny);
                    contractSettle.setSumPayMny(MathUtil.safeSub(contractSettle.getSumPayMny(), pendPayMny));
                    pendPayMny = BigDecimal.ZERO;
                } else {
                    settle.setReturnPayMny(contractSettle.getSumPayMny());
                    pendPayMny = MathUtil.safeSub(pendPayMny, contractSettle.getSumPayMny());// 待支付减去已支付金额
                    contractSettle.setSumPayMny(BigDecimal.ZERO);
                }
                settle.setSettlePayMny(contractSettle.getSumPayMny());
                settleLsit.add(settle);
            }
        }
        if (CollectionUtils.isNotEmpty(settleLsit)) {
            settleService.saveOrUpdateBatch(settleLsit);
            contracctSettleService.saveOrUpdateBatch(contractSettleList);
        }
        return settleLsit;
    }


    /**
     * 回写合同累计付款、累计预付款金额与结算单累计付款金额
     * @param entity
     * @param settleList
     */
    public boolean writeBackSumPayMnyAfterReturnPayment(PayRecordEntity entity, List<PayRecordSettleEntity> settleList) {
        BigDecimal payMny = entity.getThisPayMny();
        BigDecimal prepayMny = null != entity.getFeeType() && entity.getFeeType() == 1 ? payMny : BigDecimal.ZERO;
        Map<Long, BigDecimal> settleMnyMap = new HashMap<>();
        BigDecimal pendPayMny = payMny;// 待结算单分摊付款金额。初始值为本期支付金额
        for (PayRecordSettleEntity settle : settleList) {
            settleMnyMap.put(settle.getSettleId(), settle.getReturnPayMny().negate());
        }
        if (entity.getContractType() == 1) {//分包
            subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                subApi.updateSubSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 2) {//设备采购
            equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updatePurchaseSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 3) {//设备租赁
            equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settle : settleList) {
                equipmentApi.updateRentSettleSumPayMny(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 4) {//物资采购
            for (PayRecordSettleEntity settle : settleList) {
                materialApi.updateSettlementBillAlreadyPaidAmount(settle.getSettleId(), settleMnyMap.get(settle.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 5) {//物资租赁
            rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settleEntity : settleList) {
                rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), settleMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        if (entity.getContractType() == 6) {//其它支出
            otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);//合同
            for (PayRecordSettleEntity settleEntity : settleList) {
                otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), settleMnyMap.get(settleEntity.getSettleId()));//结算单
            }
        }
        return true;
    }
}
