package com.ejianc.business.finance.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工人工资发放记录子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_finance_pay_record_salary_grant")
public class PayRecordSalaryGrantEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="payapply_id")
    private Long payapplyId; // 工人工资申请主键ID
    @TableField(value="record_id")
    private Long recordId; // 付款记录主键
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="salary_month")
    private String salaryMonth; // 月份
    @TableField(value="worker_id")
    private Long workerId; // 工人id
    @TableField(value="worker_name")
    private String workerName; // 工人
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商
    @TableField(value="id_card")
    private String idCard; // 身份证号码
    @TableField(value="team_id")
    private String teamId; // 班组id
    @TableField(value="team_name")
    private String teamName; // 班组名称
    @TableField(value="work_type")
    private String workType; // 工种id
    @TableField(value="work_type_name")
    private String workTypeName; // 工种名称
    @TableField(value="sex")
    private Integer sex; // 性別 1:男 2:女
    @TableField(value="phone")
    private String phone; // 手机号
    @TableField(value="bank_card")
    private String bankCard; // 银行卡号
    @TableField(value="bank_name")
    private String bankName; // 开户行
    @TableField(value="should_salary_mny")
    private BigDecimal shouldSalaryMny; // 应发工资
    @TableField(value="pay_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date payTime; // 支付时间
    @TableField(value="pay_mny")
    private BigDecimal payMny; // 本期支付金额
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申请金额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source")
    private Integer source; // 来源 1：合同付款 2：零星付款
    @TableField(value="ack_flag")
    private Integer ackFlag; // 确认状态：1：已确认:0：未确认
    @TableField(value="logon_people_id")
    private Long logonPeopleId; // 登录人id
    @TableField(value="logon_people")
    private String logonPeople; // 登录人
    @TableField(value="ack_time")
    private Date ackTime; // 确认时间
    @TableField(value="face_photo_id")
    private Long facePhotoId; // 人脸照片id
    @TableField(value="face_photo")
    private String facePhoto; // 人脸照片地址
    @TableField(value="sign_photo_id")
    private Long signPhotoId; // 签字照片id
    @TableField(value="sign_photo")
    private String signPhoto; // 签字照片地址 
    @TableField(value="pay_ratio")
    private BigDecimal payRatio; // 本期支付比例
    @TableField(value="salary_summary_id")
    private Long salarySummaryId; // 工人工资申请子表工资汇总id
    @TableField(value="payed_mny")
    private BigDecimal payedMny; // 已支付金额
    
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getSalaryMonth() {
        return salaryMonth;
    }

    public void setSalaryMonth(String salaryMonth) {
        this.salaryMonth = salaryMonth;
    }
    public Long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }
    public String getWorkerName() {
        return workerName;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getTeamId() {
        return teamId;
    }

    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public String getWorkType() {
        return workType;
    }

    public void setWorkType(String workType) {
        this.workType = workType;
    }
    public String getWorkTypeName() {
        return workTypeName;
    }

    public void setWorkTypeName(String workTypeName) {
        this.workTypeName = workTypeName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getBankCard() {
        return bankCard;
    }

    public void setBankCard(String bankCard) {
        this.bankCard = bankCard;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }
    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
    public Integer getAckFlag() {
        return ackFlag;
    }

    public void setAckFlag(Integer ackFlag) {
        this.ackFlag = ackFlag;
    }

    public Long getLogonPeopleId() {
        return logonPeopleId;
    }

    public void setLogonPeopleId(Long logonPeopleId) {
        this.logonPeopleId = logonPeopleId;
    }

    public String getLogonPeople() {
        return logonPeople;
    }

    public void setLogonPeople(String logonPeople) {
        this.logonPeople = logonPeople;
    }
    public Date getAckTime() {
        return ackTime;
    }

    public void setAckTime(Date ackTime) {
        this.ackTime = ackTime;
    }
    public Long getFacePhotoId() {
        return facePhotoId;
    }

    public void setFacePhotoId(Long facePhotoId) {
        this.facePhotoId = facePhotoId;
    }
    public String getFacePhoto() {
        return facePhoto;
    }

    public void setFacePhoto(String facePhoto) {
        this.facePhoto = facePhoto;
    }
    public Long getSignPhotoId() {
        return signPhotoId;
    }

    public void setSignPhotoId(Long signPhotoId) {
        this.signPhotoId = signPhotoId;
    }
    public String getSignPhoto() {
        return signPhoto;
    }

    public void setSignPhoto(String signPhoto) {
        this.signPhoto = signPhoto;
    }
    public BigDecimal getPayRatio() {
        return payRatio;
    }

    public void setPayRatio(BigDecimal payRatio) {
        this.payRatio = payRatio;
    }
    public Long getSalarySummaryId() {
        return salarySummaryId;
    }

    public void setSalarySummaryId(Long salarySummaryId) {
        this.salarySummaryId = salarySummaryId;
    }
    public BigDecimal getPayedMny() {
        return payedMny;
    }

    public void setPayedMny(BigDecimal payedMny) {
        this.payedMny = payedMny;
    }
    
}
