package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.vo.*;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yqls
 * @since 2020-05-28
 */
public interface IPayReimburseService extends IBaseService<PayReimburseEntity> {

    PayReimburseVO insertOrUpdate(PayReimburseVO payReimburseVO);

    PayReimburseVO queryDetail(Long id);

    List<PayReimburseVO> queryExportList(QueryParam param);

    String delete(List<Long> ids);

    JSONObject queryPageJson(QueryParam param, boolean isEs);

    JSONObject querySubExcelList(QueryParam param, boolean isEs);

    /**
     * 统计匹配条件的报销申请付款金额总数
     *
     * @param tenantId 租户Id
     * @param projectIds 待过滤项目Id列表
     * @return
     */
    Map<String, Object> countAmt(Long tenantId, List<Long> projectIds);

    CommonResponse<PayReimburseVO> pushCost(PayReimburseVO paySporadicVO);

    void costPush(PayReimburseEntity payReimburseEntity);

    //成本改造
    void pullCost(Long id);

    TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs);

    TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs);

    /**
     *  报销单参照
     * @param page
     * @param wrapper
     * @return
     */
    List<PayReimburseVO> queryReferData(Page<PayReimburseVO> page, QueryWrapper wrapper);

    CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject);

    IPage<PayReimburseStatisticsVO> payReimburseStatisticsList(Page<PayReimburseStatisticsVO> page, QueryWrapper wrapper, String dependOnProject);

    List<PayReimburseStatisticsVO> payReimburseStatisticsDetailList(Long projectId, Long orgId, QueryWrapper wrapper);


    /**
     *  预算控制 金额查询
     * @param vo
     * @return
     */
    BigDecimal totalBudgetMny(PayReimburseVO vo);

    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    ParamsCheckSpreadVO checkBudgetParams(PayReimburseVO vo);

    void closePayment(Long id);

    PayRecordVO returnPayment(PayRecordVO payRecordVO);

	BigDecimal fetchSjzcje(Long projectId);

	/**
	 * @description: 更新被分摊的组织费用报销单的分摊金额
	 * @date: 2024/1/17
	 */
    void updateShareMoneyByShareId(Long ishareId, boolean addFlag);

    BigDecimal queryFeeMny(Long projectId, Long feeTypeId);
}
