package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.finance.bean.*;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.*;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.*;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.business.material.api.IInstoreApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.sub.api.ISubOddjobApi;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Service
public class PaySporadicServiceImpl extends BaseServiceImpl<PaySporadicMapper, PaySporadicEntity> implements IPaySporadicService {

    private static final String PAY_SPORADIC_BILL_CODE = "PAY_SPORADIC";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IInstoreApi instoreApi;

    @Autowired
    private ISubOddjobApi oddjobApi;

    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IPaySporadicStockService stockService;

    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPaySporadicOddjobService paySporadicOddjobService;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPaySporadicOtherService paySporadicOtherService;
    @Autowired
    private IPaySporadicEquipmentRecordService equipmentRecordService;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;

    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPayReimburseService payReimburseService;//费用报销
    @Autowired
    private ILoadReimburseService loadReimburseService;//备用金

    @Autowired
    private IPaySporadicSalaryService paySporadicSalaryService;

    @Autowired
    private IPaySporadicSummaryService paySporadicSummaryService;

    @Autowired
    private IProjectTeamApi projectTeamApi;
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";//【项目可用资金】控制项目【申请金额	】

    private static final String PARAM_TOTAL_MNY = "P-6zD11147"; // 【预算间接费总金额】控 【实际间接费总金额】

    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private PayReimburseMapper payReimburseMapper;
    @Autowired
    private LoadReimburseMapper loadReimburseMapper;

    @Autowired
    private IBankFlowService bankFlowService;

    //零星材料付款申请入库单为空时，单据是否可保存 1是2否
    private static final String PARAM_STOCK = "P-Ri945r72";

    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Value("${extend.field.mode:false}")
    private Boolean extFieldsMode;


    private static Map sporadicPaymentTypeNameMap=new HashMap();
    static {
        sporadicPaymentTypeNameMap.put("1","零星材料");
        sporadicPaymentTypeNameMap.put("2","零星机械");
        sporadicPaymentTypeNameMap.put("3","其他");
        sporadicPaymentTypeNameMap.put("4","零星用工");
    }
    @Override
    public PaySporadicVO insertOrUpdate(PaySporadicVO vo) {
        PaySporadicEntity entity = BeanMapper.map(vo, PaySporadicEntity.class);
        if (null!=entity.getSporadicPaymentType()&&1==entity.getSporadicPaymentType()){
            CommonResponse<ParamRegisterSetVO> byCode = paramConfigApi.getByCode(PARAM_STOCK);
            if (byCode.isSuccess() && null != byCode.getData()) {
                ParamRegisterSetVO paramRegisterSetVO = byCode.getData();
                String valueData = paramRegisterSetVO.getValueData();
                List<PaySporadicStockVO> stockVOS = vo.getStockVOList();
                if (null!=stockVOS) {
                    List<PaySporadicStockVO> collect = stockVOS.stream().filter(d -> !"del".equals(d.getRowState())).collect(Collectors.toList());
                    if ("2".equals(valueData) && collect.size() == 0) {
                        throw new BusinessException("请选择入库单!");
                    }
                }else {
                    if ("2".equals(valueData)) {
                        throw new BusinessException("请选择入库单!");
                    }
                }
            }
        }
        //放入费用类别汇总(子表)
        List<PaySporadicOtherVO> payOtherVOList = vo.getOtherVOList();
        if (CollectionUtils.isNotEmpty(payOtherVOList)) {
            String otherTypeIds =  payOtherVOList.stream().filter(s -> !"del".equals(s.getRowState())&& null!=(s.getCostTypeId())).map(e->e.getCostTypeId().toString()).distinct().collect(Collectors.joining(","));
            String otherTypeNames = payOtherVOList.stream().filter(s -> !"del".equals(s.getRowState())&& StringUtils.isNotBlank(s.getCostType())).map(PaySporadicOtherVO::getCostType).distinct().collect(Collectors.joining(","));
            entity.setOtherCostTypeIds(otherTypeIds);
            entity.setOtherCostTypeNames(StringUtils.isBlank(otherTypeNames) ? null : otherTypeNames);
        } else {
            entity.setOtherCostTypeIds(null);
            entity.setOtherCostTypeNames(null);
        }
        // 自动生成编码
        this.autoSetBillCode(entity);
        //判断是否有入库单
        List<PaySporadicStockVO> stockVO = vo.getStockVOList();
        if (ListUtil.isNotEmpty(stockVO)){
            entity.setInputFlag("1");
        }else {
            entity.setInputFlag("0");
        }
        //设置默认值
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if(CollectionUtils.isNotEmpty(voList)){
            for(PayInvoiceVO invoiceVO : voList){
                // 保存时校验version是否一致
                if(!ValidateUtil.validateUpstreamVersion(String.valueOf(invoiceVO.getInvoiceId()),
                        BillTypeCodeEnum.税务收票.getBillTypeCode(), invoiceVO.getInvoiceVersion())){
                    throw new BusinessException("发票已被更新，请刷新后重做！");
                }
            }
        }
        CommonResponse<String> usedMnyRes = invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId());
        if (!usedMnyRes.isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);//存放发票确认标识
        super.saveOrUpdate(entity, false);
        Long id = entity.getId();
        // 更新零星用工单
        List<PaySporadicOddjobVO> oddjovList = this.updateOddjovVOS(vo, id);
        // 更新发票
        List<PayInvoiceVO> invoiceVOList = this.updateInvoiceVOS(vo, id);
        // 更新入库
        List<PaySporadicStockVO> stockVOList = this.updateStockVOS(vo, id);
        //更新劳务工资单
        List<PaySporadicSalaryVO> sporadicSalaryVOList = this.updateSalaryVOS(vo, id);
        //更新劳务工资汇总
        List<PaySporadicSummaryVO> sporadicSummaryVOList = this.updateSummaryVOS(vo, id);
        List<PaySporadicEquipmentRecordVO> equipmentRecordList = this.updateEquipmentRecordVOS(vo, id);
        List<PaySporadicEquipmentRecordVO> equipmentRecordVOS = vo.getEquipmentRecordList();
        if (CollectionUtils.isNotEmpty(equipmentRecordVOS)){
            List<PaySporadicEquipmentRecordVO> equipmentRecordDelList = equipmentRecordVOS.stream().filter(s -> ("del".equals(s.getRowState()))).collect(Collectors.toList());
            List<PaySporadicEquipmentRecordVO> equipmentRecordAddList = equipmentRecordVOS.stream().filter(s -> ("add".equals(s.getRowState()))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(equipmentRecordDelList)){
                List<RentUseRecordVO> delList = new ArrayList<>();
                for (PaySporadicEquipmentRecordVO recordVO : equipmentRecordDelList) {
                    RentUseRecordVO rentUseRecordVO = new RentUseRecordVO();
                    rentUseRecordVO.setId(recordVO.getSourceMainId());
                    rentUseRecordVO.setSporadicUseFlag(0);
                    delList.add(rentUseRecordVO);
                }
                CommonResponse<String> commonResponse =
                        equipmentContractApi.updateRentUseRecordSporadicUseFlag(delList);
               if (commonResponse.isSuccess()){

               }
            }
            if (CollectionUtils.isNotEmpty(equipmentRecordAddList)){
                List<RentUseRecordVO> addList = new ArrayList<>();
                for (PaySporadicEquipmentRecordVO recordVO : equipmentRecordAddList) {
                    RentUseRecordVO rentUseRecordVO = new RentUseRecordVO();
                    rentUseRecordVO.setId(recordVO.getSourceMainId());
                    rentUseRecordVO.setSporadicUseFlag(1);
                    addList.add(rentUseRecordVO);
                }
                CommonResponse<String> commonResponse =
                        equipmentContractApi.updateRentUseRecordSporadicUseFlag(addList);
                if (commonResponse.isSuccess()){

                }
            }
        }
        PaySporadicEntity byId = this.selectById(id);
        // 返回VO
        PaySporadicVO backVO = BeanMapper.map(byId, PaySporadicVO.class);
        if(entity.getId() != null){
            QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
            wrapper.eq("payapply_id", entity.getId());
            invoiceVOList = invoiceService.list(wrapper);
        }
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));// 发票列表
        backVO.setStockVOList(stockVOList);// 入库列表
        backVO.setSporadicSalaryList(sporadicSalaryVOList);
        backVO.setSporadicSummaryList(sporadicSummaryVOList);
        backVO.setEquipmentRecordList(equipmentRecordList);
        backVO.setSporadicOddjobList(oddjovList);
        ProjectFinanceVO v = BeanMapper.map(byId, ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }


    private List<PaySporadicEquipmentRecordVO> updateEquipmentRecordVOS(PaySporadicVO vo, Long id) {
        List<PaySporadicEquipmentRecordVO> voList = vo.getEquipmentRecordList();
        if(voList != null && !voList.isEmpty()){
            // 删除
            List<Long> ids = voList.stream().filter(s->"del".equals(s.getRowState())).map(PaySporadicEquipmentRecordVO::getId).collect(Collectors.toList());
            for (PaySporadicEquipmentRecordVO recordVO:voList){
                recordVO.setPayapplyId(id);
            }
            List<PaySporadicEquipmentRecordEntity> entityList = BeanMapper.mapList(voList, PaySporadicEquipmentRecordEntity.class);
            equipmentRecordService.saveOrUpdateBatch(entityList);
            voList = BeanMapper.mapList(entityList, PaySporadicEquipmentRecordVO.class);
            if (CollectionUtils.isNotEmpty(ids)){
                equipmentRecordService.removeByIds(ids);
            }
        }else{
            QueryWrapper<PaySporadicEquipmentRecordEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("payapply_id", id);
            equipmentRecordService.remove(wrapper, false);
        }
        QueryWrapper< PaySporadicEquipmentRecordEntity> wrapper = new QueryWrapper<PaySporadicEquipmentRecordEntity>();
        wrapper.eq("payapply_id", id);
        List<PaySporadicEquipmentRecordEntity> list = equipmentRecordService.list(wrapper);
        voList= BeanMapper.mapList(list, PaySporadicEquipmentRecordVO.class);
        return voList;
    }

    private List<PaySporadicSalaryVO> updateSalaryVOS(PaySporadicVO vo, Long id){
        // 新增
        List<PaySporadicSalaryVO> voList = vo.getSporadicSalaryList();
        // 删除
        QueryWrapper wrapper = new QueryWrapper<PaySporadicSalaryEntity>();
        wrapper.eq("payapply_id", id);
        List<PaySporadicSalaryVO> updSalarys = new ArrayList<>();
        if(voList != null && !voList.isEmpty()){
            for (PaySporadicSalaryVO salaryVO : voList) {
                salaryVO.setPayapplyId(id);
            }
            List<PaySporadicSalaryEntity> entityList = BeanMapper.mapList(voList, PaySporadicSalaryEntity.class);
            paySporadicSalaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList,PaySporadicSalaryVO.class);
            updSalarys.addAll(voList);
            List<Long> ids = voList.stream().map(PaySporadicSalaryVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(),"id", ids);
        }

        List<PayContractSalaryEntity> delSalList = paySporadicSalaryService.list(wrapper);
        if(CollectionUtils.isNotEmpty(delSalList)){
            List<PaySporadicSalaryVO> delSalVOList = BeanMapper.mapList(delSalList, PaySporadicSalaryVO.class);
            updSalarys.addAll(delSalVOList);
        }
        paySporadicSalaryService.remove(wrapper, false);

        //保存后 回写申请中工资条的已申请金额
        this.writeBackAlreadyApplyMny(updSalarys);
        return voList;
    }

    private List<PaySporadicSummaryVO>  updateSummaryVOS(PaySporadicVO vo, Long id){
        //新增修改
        List<PaySporadicSummaryVO> voList = vo.getSporadicSummaryList();
        //删除
        QueryWrapper wrapper = new QueryWrapper<PaySporadicSummaryEntity>();
        wrapper.eq("payapply_id", id);
        if(voList != null && !voList.isEmpty()){
            for (PaySporadicSummaryVO summaryVO : voList) {
                summaryVO.setPayapplyId(id);
            }
            List<PaySporadicSummaryEntity> entityList = BeanMapper.mapList(voList, PaySporadicSummaryEntity.class);
            paySporadicSummaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList,PaySporadicSummaryVO.class);
            // 删除
            List<Long> ids = voList.stream().map(PaySporadicSummaryVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(),"id", ids);
        }
        paySporadicSummaryService.remove(wrapper, false);
        return voList;
    }

    /**
     * 更新发票
     * @param vo
     * @param id
     * @return
     */
    private List<PayInvoiceVO> updateInvoiceVOS(PaySporadicVO vo, Long id) {
        // 新增
        List<PayInvoiceVO> voList = vo.getInvoiceVOList();
        if(voList != null && !voList.isEmpty()){
            for(PayInvoiceVO invoiceVO : voList){
                invoiceVO.setPayapplyId(id);
            }
            List<PayInvoiceEntity> entityList = BeanMapper.mapList(voList, PayInvoiceEntity.class);
            invoiceService.saveOrUpdateBatch(entityList);
            voList = BeanMapper.mapList(entityList, PayInvoiceVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper<PayInvoiceEntity>();
        wrapper.eq("payapply_id", id);
        if(voList != null && !voList.isEmpty()){
            // 删除
            List<Long> ids = voList.stream().map(PayInvoiceVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(),"id", ids);
        }
        invoiceService.remove(wrapper, false);
        return voList;
    }
    /**
     * 更新零星用工单
     * @param vo
     * @param id
     * @return
     */
    private List<PaySporadicOddjobVO> updateOddjovVOS(PaySporadicVO vo, Long id) {
        // 新增
        List<PaySporadicOddjobVO> voList = vo.getSporadicOddjobList();
        List<OddjobVO> oddjobVOList = new ArrayList<>();
        List<Long> oddjobIds = new ArrayList<>();
        if(voList != null && !voList.isEmpty()){
            for(PaySporadicOddjobVO oddjobVO : voList){
                oddjobVO.setPayapplyId(id);
                OddjobVO oddjobVOOne = new OddjobVO();
                oddjobVOOne.setId(oddjobVO.getOddjobId());
                oddjobIds.add(oddjobVO.getOddjobId());
                oddjobVOList.add(oddjobVOOne);
            }
            List<PaySporadicOddjobEntity> entityList = BeanMapper.mapList(voList, PaySporadicOddjobEntity.class);
            paySporadicOddjobService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PaySporadicOddjobVO.class);
        }
            // 删除
            List<Long> voIds = voList.stream().map(PaySporadicOddjobVO::getId).collect(Collectors.toList());
            List<PaySporadicOddjobEntity> dataList = paySporadicOddjobService.list(new QueryWrapper<PaySporadicOddjobEntity>().eq("payapply_id", id));
            List<Long> dataIds = dataList.stream().map(PaySporadicOddjobEntity::getId).collect(Collectors.toList());
            dataIds.removeAll(voIds);
            List<Long> delIds = dataIds;
        if(!delIds.isEmpty()){
            QueryWrapper wrapper =new QueryWrapper<PaySporadicOddjobEntity>().in("id", delIds);
            List<OddjobVO> delOddjobVOList = new ArrayList<>();
            List<PaySporadicOddjobEntity> oddList = paySporadicOddjobService.list(wrapper);
            for (PaySporadicOddjobEntity paySporadicOddjobEntity : oddList) {
                OddjobVO oddjobVO = new OddjobVO();
                oddjobVO.setId(paySporadicOddjobEntity.getOddjobId());
                delOddjobVOList.add(oddjobVO);
            }
            if(!delOddjobVOList.isEmpty()){
                oddjobApi.updateOddjobUse(delOddjobVOList,Boolean.FALSE);
            }
            paySporadicOddjobService.remove(wrapper, false);
        }
        // 回写无合同零星用工单是否占用
//            for(PaySporadicOddjobEntity data : dataList){
//                if(delIds.contains(data.getId()) && !oddjobIds.contains(data.getOddjobId())){
//                    OddjobVO oddjobVO = new OddjobVO();
//                    oddjobVO.setId(data.getOddjobId());
//                    oddjobVOList.add(oddjobVO);
//                }
//            }
        if(!oddjobVOList.isEmpty()){
                oddjobApi.updateOddjobUse(oddjobVOList,Boolean.TRUE);
            }
        return voList;
    }
    /**
     * 更新入库
     * @param vo
     * @param id
     * @return
     */
    private List<PaySporadicStockVO> updateStockVOS(PaySporadicVO vo, Long id) {
        // 新增
        List<PaySporadicStockVO> voList = vo.getStockVOList();
        List<InstoreVO> instoreVOList = new ArrayList<>();
        List<Long> stockIds = new ArrayList<>();
        if(voList != null && !voList.isEmpty()){
            for(PaySporadicStockVO stockVO : voList){
                // 保存时校验version是否一致
                if(!ValidateUtil.validateUpstreamVersion(String.valueOf(stockVO.getStockId()),
                        BillTypeCodeEnum.物资入库.getBillTypeCode(), stockVO.getStockVersion())){
                    throw new BusinessException("入库单已被更新，请刷新后重做！");
                }
                stockVO.setPayapplyId(id);
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(stockVO.getStockId());
                instoreVO.setPaymentFlag(1);
                stockIds.add(stockVO.getStockId());
                instoreVOList.add(instoreVO);
            }
            List<PaySporadicStockEntity> entityList = BeanMapper.mapList(voList, PaySporadicStockEntity.class);
            stockService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList(entityList, PaySporadicStockVO.class);
        }
        if(voList != null && !voList.isEmpty()){
            // 删除
            List<Long> voIds = voList.stream().map(PaySporadicStockVO::getId).collect(Collectors.toList());
            List<PaySporadicStockEntity> dataList = stockService.list(new QueryWrapper<PaySporadicStockEntity>().eq("payapply_id", id));
            List<Long> dataIds = dataList.stream().map(PaySporadicStockEntity::getId).collect(Collectors.toList());
            dataIds.removeAll(voIds);
            List<Long> delIds = dataIds;
            if(!delIds.isEmpty()){
                stockService.remove(new QueryWrapper<PaySporadicStockEntity>().in("id", delIds), false);
            }

            // 回写入库单是否付款
            for(PaySporadicStockEntity data : dataList){
                if(delIds.contains(data.getId()) && !stockIds.contains(data.getStockId())){
                    InstoreVO instoreVO = new InstoreVO();
                    instoreVO.setId(data.getStockId());
                    instoreVO.setPaymentFlag(0);
                    instoreVOList.add(instoreVO);
                }
            }
            if(!instoreVOList.isEmpty()){
                instoreApi.updatePayment(instoreVOList);
            }
        }
        return voList;
    }

    /**
     * 劳务工资申请无合同 新增/修改/删除 后回写工资条已申请金额
     * @return
     */
    public Boolean writeBackAlreadyApplyMny(List<PaySporadicSalaryVO> list){
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> salaryIds = list.stream().distinct().map(PaySporadicSalaryVO::getSalaryId).collect(Collectors.toList());
            List<PaySporadicSalaryVO> salarylist = paySporadicSalaryService.querySalaryAlreadyApplyMny(salaryIds);
            Map<Long, BigDecimal> map = salarylist.stream().collect(Collectors.toMap(PaySporadicSalaryVO::getSalaryId,a->a.getApplyMny()));
            for (Long salaryId : salaryIds) {
                if(!map.containsKey(salaryId)){
                    map.put(salaryId,BigDecimal.ZERO);
                }
            }
            projectTeamApi.updateAlreadyApplyMny(map);
        }
        return true;
    }

    @Override
    public PaySporadicVO queryDetail(Long id) {
        // 查询主表
        PaySporadicEntity entity = this.selectById(id);
        PaySporadicVO vo = BeanMapper.map(entity, PaySporadicVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        // 查询关联发票
        List<PayInvoiceEntity> invoiceEntityList = invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList(invoiceEntityList, PayInvoiceVO.class));
        // 查询零星用工单
        List<PaySporadicOddjobEntity> oddjobEntityList = paySporadicOddjobService.queryList(queryParam, false);
        vo.setSporadicOddjobList(BeanMapper.mapList(oddjobEntityList, PaySporadicOddjobVO.class));
        // 查询入库单
        List<PaySporadicStockEntity> stockEntityList = stockService.queryList(queryParam, false);
        vo.setStockVOList(BeanMapper.mapList(stockEntityList, PaySporadicStockVO.class));
        // 查询劳务工资单
        List<PaySporadicSalaryEntity> salaryEntityList = paySporadicSalaryService.queryList(queryParam, false);
        vo.setSporadicSalaryList(BeanMapper.mapList(salaryEntityList,PaySporadicSalaryVO.class));
        //查询劳务工资汇总
        List<PaySporadicSummaryEntity> summaryEntityList = paySporadicSummaryService.queryList(queryParam, false);
        vo.setSporadicSummaryList(BeanMapper.mapList(summaryEntityList,PaySporadicSummaryVO.class));
        // 查询付款记录
        List<PayRecordEntity> recordList = payRecordService.queryList(queryParam);

        vo.setRecordList(BeanMapper.mapList(recordList, PayRecordVO.class));
        List<PaySporadicEquipmentRecordEntity> equipmentRecordList = equipmentRecordService.queryList(queryParam);
        vo.setEquipmentRecordList(BeanMapper.mapList(equipmentRecordList, PaySporadicEquipmentRecordVO.class));
        //项目资金详情
        vo.setProjectFinanceVO(BeanMapper.map(vo, ProjectFinanceVO.class));
        if(null != vo.getPayMny()){
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PaySporadicVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List<PaySporadicVO> resVos = (List<PaySporadicVO>) queryPageJson(param, false).get("records");
        if(!resVos.isEmpty()){
            for(int i = 0 ; i< resVos.size(); i++){
                PaySporadicVO vo = resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            };
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<PaySporadicEntity> entityList = super.queryList(queryParam, false);
        if(CollectionUtils.isNotEmpty(entityList)) {
            //删除前获取工资条子表，回写工资条的已申请金额
            LambdaQueryWrapper<PaySporadicSalaryEntity> removeWrapper = new LambdaQueryWrapper<>();
            removeWrapper.in(PaySporadicSalaryEntity::getPayapplyId,ids);
            List<PaySporadicSalaryEntity> removeSalaryList = paySporadicSalaryService.list(removeWrapper);

//            LambdaQueryWrapper<PaySporadicOddjobEntity> oddWrapper = new LambdaQueryWrapper<>();
//            oddWrapper.in(PaySporadicOddjobEntity::getPayapplyId,ids);
//            List<PaySporadicOddjobEntity> oddjobEntities = paySporadicOddjobService.list(oddWrapper);
//            List<OddjobVO> oddjobVOList = new ArrayList<>();
//            if (ListUtil.isNotEmpty(oddjobEntities)){
//                for (PaySporadicOddjobEntity paySporadicOddjobEntity : oddjobEntities) {
//                    OddjobVO oddjobVO = new OddjobVO();
//                    oddjobVO.setId(paySporadicOddjobEntity.getOddjobId());
//                    oddjobVOList.add(oddjobVO);
//                }
//            }
//            if (!oddjobVOList.isEmpty()){
//                oddjobApi.updateOddjobUse(oddjobVOList,Boolean.FALSE);
//            }
            super.removeByIds(ids, false);
            //删除劳务工资申请单
            paySporadicSalaryService.remove(new QueryWrapper<PaySporadicSalaryEntity>().in("payapply_id", ids),false);
            //删除劳务工资汇总
            paySporadicSummaryService.remove(new QueryWrapper<PaySporadicSummaryEntity>().in("payapply_id", ids),false);
            //删除零星用工单
            QueryWrapper wrapperOdd =new QueryWrapper<PaySporadicOddjobEntity>().in("payapply_id", ids);
            List<PaySporadicOddjobEntity> oddList = paySporadicOddjobService.list(wrapperOdd);
            paySporadicOddjobService.remove(wrapperOdd,false);
            //回写零星用工单是否被占用
            List<OddjobVO> oddVOList = new ArrayList<>();
            for(PaySporadicOddjobEntity data : oddList){
                OddjobVO oddVO = new OddjobVO();
                oddVO.setId(data.getOddjobId());
                oddVOList.add(oddVO);
            }
            if(!oddVOList.isEmpty()){
                oddjobApi.updateOddjobUse(oddVOList,Boolean.FALSE);
            }
            QueryWrapper wrapper = new QueryWrapper<PaySporadicStockEntity>().in("payapply_id", ids);
            //回写收票
            invoiceService.updateInvoiceUsedMnyByDel(ids);
            // 删除发票
            invoiceService.remove(wrapper, false);
            // 删除入库
            List<PaySporadicStockEntity> stockList = stockService.list(wrapper);
            stockService.remove(wrapper, false);
            // 回写入库单是否付款
            List<InstoreVO> instoreVOList = new ArrayList<>();
            for(PaySporadicStockEntity data : stockList){
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(data.getStockId());
                instoreVO.setPaymentFlag(0);
                instoreVOList.add(instoreVO);
            }
            if(!instoreVOList.isEmpty()){
                instoreApi.updatePayment(instoreVOList);
            }
            QueryWrapper<PaySporadicEquipmentRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("payapply_id",ids);
            List<PaySporadicEquipmentRecordEntity> equipmentRecordEntities = equipmentRecordService.list(queryWrapper);
            List<RentUseRecordVO> delList = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(equipmentRecordEntities)){
                    for (PaySporadicEquipmentRecordEntity entity : equipmentRecordEntities) {
                        RentUseRecordVO rentUseRecordVO = new RentUseRecordVO();
                        rentUseRecordVO.setId(entity.getSourceMainId());
                        rentUseRecordVO.setSporadicUseFlag(0);
                        delList.add(rentUseRecordVO);
                    }
                }
            if (CollectionUtils.isNotEmpty(delList)){
                CommonResponse<String> commonResponse =
                        equipmentContractApi.updateRentUseRecordSporadicUseFlag(delList);
            }
            QueryWrapper paySporadicEquipmentWrapper = new QueryWrapper<PaySporadicEquipmentRecordEntity>().in("payapply_id", ids);
            equipmentRecordService.remove(paySporadicEquipmentWrapper,false);

            //删除后 回写申请中工资条的已申请金额
            this.writeBackAlreadyApplyMny(BeanMapper.mapList(removeSalaryList,PaySporadicSalaryVO.class));
        }
        return "删除成功！";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("purchasePeople");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 */
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", authOrgIds);
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", authOrgIds, authResponse.getData() == null ? null : authResponse.getData().size());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        // 单据权限控制支持--仅制单人查看
        if (StringUtils.isNotEmpty(param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()) && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));
        }

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        Page<PaySporadicVO> pages = new Page<>(param.getPageIndex(), param.getPageSize());
        String otherCostTypeIds = null;
        if (param.getParams().containsKey("otherCostTypeIds")) {
            otherCostTypeIds = param.getParams().get("otherCostTypeIds").getValue().toString();
            param.getParams().remove("otherCostTypeIds");
            param.getParams().put("other_cost_type_ids",new Parameter(QueryParam.LIKE,otherCostTypeIds));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PaySporadicVO> list = baseMapper.queryPageList(pages, wrapper, flag);

        /** 找出要查询的扩展单据id*/
        List<Long> businessIdList = new ArrayList<>();
        list.forEach(vo -> {
            if(null != vo.getApplyMny()){
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            if (null!=vo.getSporadicPaymentType()){
                vo.setSporadicPaymentTypeName((String) sporadicPaymentTypeNameMap.get(String.valueOf(vo.getSporadicPaymentType())));
            }
            businessIdList.add(vo.getId());
        });

        CommonResponse<Map<Long, CustomBusinessDataVO>> customBusinessDataResponse = null;
        if(extFieldsMode && ListUtil.isNotEmpty(businessIdList)){
            /** 根据单据id查询出这些单据的扩展字段集合 */
            customBusinessDataResponse = customBusinessDataService.queryCustomBusinessData(businessIdList);
            if(customBusinessDataResponse.isSuccess()) {
                Map<Long, CustomBusinessDataVO> customBusinessDataMap = customBusinessDataResponse.getData();
                for (PaySporadicVO vo : list) {
                    CustomBusinessDataVO subCustomBusinessDataVo = customBusinessDataMap.get(vo.getId());
                    if(subCustomBusinessDataVo != null) {
                        Map<String, Object> subCustomField = JSONObject.parseObject(subCustomBusinessDataVo.getBusinessData());
                        /** 将扩展字段的值赋值给相应的单据 */
                        vo.setCustomField(subCustomField);
                    }
                }
            }
        }

        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        page.put("records", list);
        page.put("total", pages.getTotal());
        page.put("current", pages.getCurrent());
        page.put("size", pages.getSize());
        page.put("pages", pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper<PaySporadicEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("ifnull(sum(pay_mny),0) as amt");

        queryWrapper.eq("tenant_id", tenantId);
        queryWrapper.eq("dr", BaseVO.DR_UNDELETE);
//        付款类型：1-组织付款 2-项目付款
        queryWrapper.eq("pay_type", 2);
//        支付状态：1-未支付 2-已支付
        queryWrapper.eq("pay_status", 2);

        if(CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in("project_id", projectIds);
        }
//        已生效的单据
        queryWrapper.in("bill_state",
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()}));
        List<Long> orgIds = new ArrayList<>();
        UserContext userContext = sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty(authOrgIds)) {
            CommonResponse<List<OrgVO>> authResponse =
                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
                            collect(Collectors.toList()));
            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }  else {
            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        if(ListUtil.isNotEmpty(orgIds)){
            queryWrapper.in("org_id", orgIds);
        }
        return super.getMap(queryWrapper);
    }

    @Override
    public CommonResponse<PaySporadicVO> pushCost(PaySporadicVO paySporadicVO) {
        PaySporadicEntity paySporadicEntity = baseMapper.selectById(paySporadicVO.getId());
        paySporadicEntity.setSubjectId(paySporadicVO.getSubjectId());
        paySporadicEntity.setSubjectName(paySporadicVO.getSubjectName());
        super.saveOrUpdate(paySporadicEntity,false);
        //推送数据
        costPush(paySporadicEntity);
        return CommonResponse.success(this.queryDetail(paySporadicEntity.getId()));
    }
    @Override
    public void costPush(PaySporadicEntity paySporadicEntity) {

        logger.info("推送开始:{}",JSONObject.toJSONString(paySporadicEntity.getId()));
        if (!"1".equals(paySporadicEntity.getDependOnProject())){
            return;
        }
        //1.判断是否关联
        Long subjectId = paySporadicEntity.getSubjectId();
        boolean newRelationFlag = true;
        if(null == subjectId){
            newRelationFlag = false;
        }
        //更新是否关联
        LambdaUpdateWrapper<PaySporadicEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PaySporadicEntity::getId, paySporadicEntity.getId());
        updateWrapper.set(PaySporadicEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        costDetailApi.deleteSubject(paySporadicEntity.getId());
        saveCost(paySporadicEntity);

    }

    private void saveCost(PaySporadicEntity entity) {
        logger.info("推送实体转换:{}",JSONObject.toJSONString(entity.getId()));

        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getSubjectId());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getPayMny());
        costDetailVO.setHappenMny(entity.getPayMny());
        costDetailVO.setHappenDate(entity.getApplyTime());
        costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(PAY_SPORADIC_BILL_CODE);
        costDetailVO.setSourceTabType(PAY_SPORADIC_BILL_CODE);
        costDetailVO.setProjectId(entity.getProjectId());

        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        //如果当前零星用工单是无合同劳务工资申请同时成本科目为空时，传人工费 否则传间接费
        if(entity.getSalaryFlag() != null && entity.getSalaryFlag()==1 && entity.getSubjectId() == null){
            costDetailVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
            costDetailVO.setCostTypeName(CostTypeEnum.LABOR_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
        }else{
            costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型 说明：按照预算枚举传
            costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称 说明：按照预算枚举传
        }
        if (entity.getSporadicPaymentType()!=null){
            if (entity.getSporadicPaymentType().equals(1)) {
                //零星材料-推成本，费用类型=材料费；
                costDetailVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType()); // 费用类型
                costDetailVO.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName()); // 费用类型名称
            } else if (entity.getSporadicPaymentType().equals(2)) {
                //零星机械-推成本，费用类型=机械设备；
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType()); // 费用类型
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName()); // 费用类型名称
            } else if (entity.getSporadicPaymentType().equals(3)) {
                //其他-推成本，费用类型=间接费 ；
                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType()); // 费用类型
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName()); // 费用类型名称
            } else if (entity.getSporadicPaymentType().equals(4)) {
                //零星用工-推成本，费用类型=人工；
                costDetailVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType()); // 费用类型
                costDetailVO.setCostTypeName(CostTypeEnum.LABOR_COST_TYPE.getName()); // 费用类型名称
            }
        }


        costDetailVO.setPeriod(settlementDate.format(df)); // 期间 说明：按发生日期（happenDate）格式化成年月（2022-09 ） 传
        costDetailVO.setShareFlag(0); // 归集状态(1:是，0：否)    说明：传0
        costDetailVO.setSourceBillCode(entity.getBillCode()); // 来源单据编码 说明：XHCCHECK00000190
        costDetailVO.setSourceBillName("零星付款申请"); // 来源单据名称 说明：材料验收单
        costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/paymentList/sporadicCard?id=" + entity.getId());
        costDetailVOList.add(costDetailVO);
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            costDetailVOList.toString();
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送返回结果:{}",JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    /**
     * 校验同合同、同组织下只能有一张未生效单据
     * @param entity
     */
    private void validateBeforeSave(PaySporadicEntity entity) {
        LambdaQueryWrapper<PaySporadicEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getSupplierId, entity.getSupplierId());
        lambda.eq(PaySporadicEntity::getOrgId, entity.getOrgId());
        lambda.eq(PaySporadicEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0, PaySporadicEntity::getId, entity.getId());
        lambda.notIn(PaySporadicEntity::getBillState, Arrays.asList(
                BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<PaySporadicEntity> entityList = super.list(lambda);
        if(entityList != null && entityList.size() > 0) {
            throw new BusinessException("该供应商在当前组织下存在未审批通过的申请单["
                    + entityList.get(0).getBillCode() + "]，无法发起申请!");
        }
    }

    /**
     * 自动生成编码
     * @param entity
     */
    private void autoSetBillCode(PaySporadicEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PAY_SPORADIC_BILL_CODE, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //修改  校验合同编号是否重复
        LambdaQueryWrapper<PaySporadicEntity> lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getBillCode, entity.getBillCode());
        lambda.eq(PaySporadicEntity::getTenantId, tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0, PaySporadicEntity::getId, entity.getId());
        List<PaySporadicEntity> entityList = super.list(lambda);
        if(entityList != null && entityList.size() > 0) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PaySporadicEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PaySporadicEntity::getId, id);
        updateWrapper.set(PaySporadicEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        // 单据权限控制支持--仅制单人查看
        if (StringUtils.isNotEmpty(param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()) && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", InvocationInfoProxy.getUsercode()));
        }

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PaySporadicVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;

    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId",new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        // 组织本下
        param.getParams().put("org_id",new Parameter("in", orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        Parameter parameterFlag = param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();

        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PaySporadicVO> list = baseMapper.queryPageList(null, wrapper, flag);

        // 过滤为空的数据并求和
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null)
                .map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null)
                .map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);

        return vo;
    }

    @Override
    public BigDecimal totalBudgetMny(PaySporadicVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
        //      零星付款申请【申请金额】合计值； paySporadicService
        QueryWrapper<PaySporadicEntity> sporadicQuery = new QueryWrapper<>();
        sporadicQuery.eq("project_Id", vo.getProjectId());
        sporadicQuery.eq("depend_on_project",1);
        //只有费用类型等于其他时才算间接费
        sporadicQuery.eq("sporadic_payment_type",3);
        if (vo.getId()!=null){
            sporadicQuery.ne("id",vo.getId());
        }
        if (vo.getApplyMny()!=null){
            applyMny = applyMny.add(vo.getApplyMny());

        }
        sporadicQuery.select("sum(apply_mny) as applyMny");
        PaySporadicEntity sporadicEntity = super.getOne(sporadicQuery);
        if(sporadicEntity!=null &&null != sporadicEntity.getApplyMny()
                &&!"0".equals(sporadicEntity.getApplyMny())) {
            applyMny = applyMny.add(sporadicEntity.getApplyMny());
        }
        return applyMny;
    }


    /**
     * 参数控制
     *
     * @param vo 【预算间接费总金额】控 【实际间接费总金额】
     *
     * @return {@link ParamsCheckVO}
     */
    @Override
    public ParamsCheckSpreadVO checkBudgetParams(PaySporadicVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = {"none", "warn", "alert"};
        Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<>();
        paramsCheckVOMap.put("alert", new ArrayList<>());
        paramsCheckVOMap.put("warn", new ArrayList<>());
        //获取 预算间接费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制  零星费用=其他时触发预警
        if (null != res.getData() && 3==vo.getSporadicPaymentType()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //预算间接费总金额
            BigDecimal budgetTaxMny =  data.getIndirectionTaxMny()==null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);

            if (!response.isSuccess()) {
                throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                //零星付款申请
                BigDecimal  totalContractMny= totalBudgetMny(vo);

                //获取其他三项金额
                CommonResponse<BigDecimal> bigDecimalCommonResponse = otherContractApi.budgetControlTotal(vo.getProjectId());
                logger.info("预算间接费 其他合同总金额 返回内容:{}", JSONObject.toJSONString(bigDecimalCommonResponse));
                if (!bigDecimalCommonResponse.isSuccess()){
                    throw new BusinessException(bigDecimalCommonResponse.getMsg());
                }
                totalContractMny = totalContractMny.add(bigDecimalCommonResponse.getData());
                PayReimburseVO payReimburse = new PayReimburseVO();
                payReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(payReimburseService.totalBudgetMny(payReimburse));
                LoadReimburseVO loadReimburse = new LoadReimburseVO();
                loadReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(loadReimburseService.totalBudgetMny(loadReimburse));
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        // 【预算间接费总金额】控 【实际间接费总金额】
                        if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                            // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                            BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                         //                        设备合同总金额：{}元，预算机械费总金额
                            paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                            paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际间接费总金额：")
                                .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                .append("元， 预算间接费总金额 * ")
                                .append(roleValue).append("%：")
                                .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                .append("元，超出金额：")
                                .append(over.setScale(2, RoundingMode.HALF_UP))
                                .append("元。");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                    }
                }
            }
        }
        CommonResponse<List<BillParamVO>> response1 = paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId);
        if (!response1.isSuccess()) {
            logger.info(response1.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        List<BillParamVO> billParamVOS1 = response1.getData();
        if (CollectionUtils.isNotEmpty(billParamVOS1)) {
            for (BillParamVO billParamVO : billParamVOS1) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal surplusApplyMny = ComputeUtil.safeMultiply(roleValue.divide(BigDecimal.valueOf(100)),vo.getProSurplusApplyMny());
                BigDecimal payMny=vo.getApplyMny();
                if (ComputeUtil.isGreaterThan(payMny,surplusApplyMny)) {
                    ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                    paramsCheckDsVO.setWarnItem("付款申请额超项目可用资金");
                    paramsCheckDsVO.setWarnName("本期申请金额大于剩余可申请金额");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("本次申请金额：").append(payMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元，剩余可申请金额*").append(roleValue.setScale(2, BigDecimal.ROUND_HALF_UP)).append("%:").append(surplusApplyMny.setScale(2, BigDecimal.ROUND_HALF_UP)).append("元。超出金额：").append(payMny.subtract(surplusApplyMny.setScale(2, BigDecimal.ROUND_HALF_UP)).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }

        // 施工合同金额控制支出
        CommonResponse<List<BillParamVO>> sghtkzc = paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData()) {
            List<BillParamVO> billParamVOS = sghtkzc.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getApplyMny());
                CommonResponse<BigDecimal> res996 = incomeContractApi.fetchSghtzje(vo.getProjectId());
                if (!res996.isSuccess()) {
                    throw new BusinessException("获取施工合同工总金额失败");
                }
                BigDecimal sght = res996.getData();
                for (BillParamVO billParamVO : billParamVOS) {
                    if (0 != billParamVO.getControlType()) {
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = NumberUtil.div(roleValue, new BigDecimal("100"), 8);
                        BigDecimal sghtzje = NumberUtil.mul(sght, scale);
                        if (sjzcje.compareTo(sghtzje) > 0) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("该项目实际支出总金额：")
                                    .append(sjzcje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，施工合同工总金额*")
                                    .append(roleValue)
                                    .append("%：")
                                    .append(sghtzje.setScale(2, RoundingMode.HALF_UP))
                                    .append("，超出金额：")
                                    .append(com.ejianc.framework.core.util.ComputeUtil.safeSub(sjzcje, sghtzje).setScale(2, RoundingMode.HALF_UP));
                            ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                            paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem("实际支出总金额超施工合同总金额");
                            paramsCheckDsVO.setWarnName("实际支出总金额大于施工合同总金额");
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                        }
                    }
                }
            }
        }


        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("alert"))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty(paramsCheckVOMap.get("warn"))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource(paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse<BigDecimal> fbCommonResponse = subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "分包" + "实际支出金额失败");
        }
        BigDecimal fb = fbCommonResponse.getData();
        CommonResponse<BigDecimal> wzCommonResponse = materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "物资" + "实际支出金额失败");
        }
        BigDecimal wz = wzCommonResponse.getData();
        CommonResponse<BigDecimal> zzcCommonResponse = rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "周转材" + "实际支出金额失败");
        }
        BigDecimal zzc = zzcCommonResponse.getData();
        CommonResponse<BigDecimal> sbcgCommonResponse = equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备采购" + "实际支出金额失败");
        }
        BigDecimal sbcg = sbcgCommonResponse.getData();
        CommonResponse<BigDecimal> sbzlCommonResponse = equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "设备租赁" + "实际支出金额失败");
        }
        BigDecimal sbzl = sbzlCommonResponse.getData();
        CommonResponse<BigDecimal> qtCommonResponse = otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("获取" + "其他" + "实际支出金额失败");
        }
        BigDecimal qt = qtCommonResponse.getData();
        BigDecimal fybx = payReimburseMapper.fetchSjzcje(projectId, null);
        BigDecimal lx = baseMapper.fetchSjzcje(projectId, id);
        BigDecimal yj = loadReimburseMapper.fetchSjzcje(projectId, null);
        return NumberUtil.add(mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj);
    }

    /**
     * （其他支出合同总金额+费用报销总金额+备用金报销总金额+零星付款总金额）> 预算间接费总金额 * X%
     *
     */
    private Integer totalMnyControl(PaySporadicVO vo, List<ParamsCheckDsSpreadVO> checkDsVOS, Integer controlType) {
        //获取 预算间接费总金额
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse<BudgetProjectProQuantityAndMnyVO> res = budgetProjectProApi.fetchQuantityAndMny(requestVo);
        logger.info("预算间接费总金额 返回内容:{}", JSONObject.toJSONString(res));
        if (!res.isSuccess()){
            throw new BusinessException("网络错误"+res.getMsg());
        }
        // 没有预算不控制，预算不包含不控制
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = res.getData();
            //预算间接费总金额
            BigDecimal budgetTaxMny =  data.getBudgetTaxMny()==null ? BigDecimal.ZERO : data.getBudgetTaxMny();
            CommonResponse<List<BillParamVO>> response = paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());

            if (!response.isSuccess()) {
                throw new BusinessException(" 【预算间接费总金额】控 【实际间接费总金额】，获取控制参数失败，失败原因：" + response.getMsg());
            }
            List<BillParamVO> billParamVOS = response.getData();
            if (CollectionUtils.isNotEmpty(billParamVOS)) {
                //零星付款申请
                BigDecimal  totalContractMny= totalBudgetMny(vo);

                //获取其他三项金额
                CommonResponse<BigDecimal> bigDecimalCommonResponse = otherContractApi.budgetControlTotal(vo.getProjectId());
                logger.info("预算间接费 其他合同总金额 返回内容:{}", JSONObject.toJSONString(bigDecimalCommonResponse));
                if (!bigDecimalCommonResponse.isSuccess()){
                    throw new BusinessException(bigDecimalCommonResponse.getMsg());
                }
                totalContractMny = totalContractMny.add(bigDecimalCommonResponse.getData());
                PayReimburseVO payReimburse = new PayReimburseVO();
                payReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(payReimburseService.totalBudgetMny(payReimburse));
                LoadReimburseVO loadReimburse = new LoadReimburseVO();
                loadReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(loadReimburseService.totalBudgetMny(loadReimburse));
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);

                    // 【预算间接费总金额】控 【实际间接费总金额】
                    if (totalContractMny.compareTo(budgetTaxMnyResult) > 0) {
                        controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                        // 超出金额 = 实际间接费总金额 - 预算间接费总金额 * X%
                        BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);

                        ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());

//                        设备合同总金额：{}元，预算机械费总金额
                        paramsCheckDsVO.setWarnItem("实际间接费总金额超预算间接费总金额");
                        paramsCheckDsVO.setWarnName("实际间接费总金额大于预算间接费总金额 * " + roleValue + "%");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("实际间接费总金额：")
                                .append(totalContractMny.setScale(2, RoundingMode.HALF_UP))
                                .append("元， 预算间接费总金额 * ")
                                .append(roleValue).append("%：")
                                .append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP))
                                .append("元，超出金额：")
                                .append(over.setScale(2, RoundingMode.HALF_UP))
                                .append("元。");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                }
            }
        }
        return controlType;
    }
    /**
     * 更新参数控制结果
     *
     * @param paramsArray      参数数组
     * @param paramsCheckVOMap 预警结果map
     * @param billParamVO      控制参数
     * @param paramsCheckDsVO  预警信息
     */
    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<PaySporadicOtherVO> successList = new ArrayList<>();
            List<PaySporadicOtherVO> errorList = new ArrayList<>();
            StringBuilder errMsg = new StringBuilder();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 6) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PaySporadicOtherVO paySporadicOtherVO = new PaySporadicOtherVO();
                    if (org.apache.commons.lang3.StringUtils.isBlank(datas.get(0))) {
                        errMsg.append("`费用名称必填项`");
                    } else {
                        paySporadicOtherVO.setName(datas.get(0));
                    }

                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(1))) {
                        try {
                            BigDecimal num = new BigDecimal(datas.get(1));
                            paySporadicOtherVO.setNum(num);
                        } catch (Exception e) {
                            errMsg.append("`数量为必须为数字`");
                        }
                    } else {
                        errMsg.append("`数量为必填项`");
                    }

                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(2))) {
                        try {
                            paySporadicOtherVO.setTaxPrice(new BigDecimal(datas.get(2)));
                        } catch (Exception e) {
                            errMsg.append("`单价必须为数字`");
                        }
                    } else {
                        errMsg.append("`单价为必填项`");
                    }

                    if (org.apache.commons.lang3.StringUtils.isNotBlank(datas.get(3))) {
                        try {
                            paySporadicOtherVO.setTaxRate(new BigDecimal(datas.get(3)));
                        } catch (Exception e) {
                            errMsg.append("`税率必须为数字`");
                        }
                    }
                    /**
                     * 没有税率 含税=无税
                     */
                    BigDecimal taxMoney = ComputeUtil.safeMultiply(paySporadicOtherVO.getNum(), paySporadicOtherVO.getTaxPrice());
                    paySporadicOtherVO.setTaxMoney(taxMoney);
                    if (Objects.isNull(paySporadicOtherVO.getTaxRate())) {
                        paySporadicOtherVO.setMoney(taxMoney);
                        paySporadicOtherVO.setTax(BigDecimal.ZERO);
                    } else {
                        //有税率计算无税单价 无税金额
                        BigDecimal taxPrice = paySporadicOtherVO.getTaxPrice();
                        BigDecimal rate = ComputeUtil.safeDiv(paySporadicOtherVO.getTaxRate() , new BigDecimal(100));
                        BigDecimal price = ComputeUtil.safeDiv( taxPrice,ComputeUtil.safeAdd(BigDecimal.ONE, rate));
                        BigDecimal money = ComputeUtil.safeMultiply(price, paySporadicOtherVO.getNum());
                        paySporadicOtherVO.setMoney(money);
                        paySporadicOtherVO.setPrice(price);
                        BigDecimal tax = ComputeUtil.safeSub(paySporadicOtherVO.getTaxMoney(), paySporadicOtherVO.getMoney());
                        paySporadicOtherVO.setTax(tax);
                    }
                    paySporadicOtherVO.setMemo(datas.get(5));
                    paySporadicOtherVO.setErrorMessage(errMsg.toString());
                    if (StringUtils.isNotEmpty(paySporadicOtherVO.getErrorMessage())) {
                        errorList.add(paySporadicOtherVO);
                    } else {
                        successList.add(paySporadicOtherVO);
                    }
                }
            }
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    @Override
    public void closePayRecord(Long id){
        PaySporadicEntity entity = super.selectById(id);
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
        //表体未存付款金额 不予处理
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("已关闭");
        entity.setCloseTime(new Date());
        entity.setCloseUser(sessionManager.getUserContext().getUserName());
        super.updateById(entity);
    }

    @Override
    public void returnPayRecord(PayRecordVO vo){
        //已付款金额】修改为【已付款金额】-【退回金额】
        PayRecordEntity entity = BeanMapper.map(vo, PayRecordEntity.class);
        // 增加一个负数的付款记录单；
        entity.setId(null);
        entity.setThisPayMny(entity.getThisPayMny().negate());
        PaySporadicEntity sporadic = super.selectById(entity.getPayapplyId());
        entity.setBillCode(sporadic.getBillCode());
        entity.setProjectId(sporadic.getProjectId());// 项目
        entity.setProjectName(sporadic.getProjectName());
        entity.setOrgId(sporadic.getOrgId());// 组织
        entity.setOrgName(sporadic.getOrgName());
        entity.setApplyUserId(sporadic.getApplyUserId());// 申请人
        entity.setApplyUserName(sporadic.getApplyUserName());
        entity.setApplyTime(vo.getConfirmTime());// 申请时间
        entity.setApplyMny(sporadic.getApplyMny());// 申请金额
        entity.setExplanation(sporadic.getPayReason()); // 付款事由
        entity.setFeeType(sporadic.getApplyType());//付款-预付款
        sporadic.setPayStatus(2);// 已支付
        sporadic.setConfirmTime(entity.getConfirmTime());// 确认时间
        sporadic.setEmployeeId(entity.getEmployeeId());// 经办人
        sporadic.setEmployeeName(entity.getEmployeeName());
        sporadic.setPayMny(MathUtil.safeAdd(sporadic.getPayMny(), entity.getThisPayMny()));// 累计支付金额
        super.saveOrUpdate(sporadic);
        // 查询付款记录
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter(QueryParam.EQ, entity.getPayapplyId()));
        queryParam.getOrderMap().put("createTime", "desc");
        QueryWrapper<PayRecordEntity> wrapper = changeToQueryWrapper(queryParam);
        wrapper.last("limit 1");
        PayRecordEntity payRecordEntity = payRecordService.getOne(wrapper);
        if (payRecordEntity != null) {
            sporadic.setPayAccountName(payRecordEntity.getAccountName());
            sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
            sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
        }
        payRecordService.saveOrUpdate(entity);
        if (vo.getClosed()){
            closePayRecord(vo.getPayapplyId());
        }
        // 付款退回后按新的支付金额重新推送成本
        costPush(sporadic);

        BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType(BankFlowSourceType.付款退还, "零星付款退回");
        bankFlowVO.setTradeOrgId(sporadic.getSupplierId());
        bankFlowVO.setTradeOrgName(sporadic.getSupplierName());
        bankFlowVO.setOrgId(entity.getOrgId());
        bankFlowVO.setOrgName(entity.getOrgName());
        bankFlowVO.setSourceId(entity.getId());
        bankFlowVO.setBillId(entity.getPayapplyId());
        bankFlowVO.setBillCode(entity.getBillCode());
        bankFlowVO.setBillDate(entity.getConfirmTime());
        bankFlowVO.setAccountId(entity.getAccountId());
        bankFlowVO.setAccountName(entity.getAccountName());
        bankFlowVO.setAccountNum(entity.getAccountNum());
        bankFlowVO.setAccountBank(entity.getAccountBank());
        bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
        bankFlowVO.setMemo(entity.getMemo());

        bankFlowService.saveFlowVO(bankFlowVO);
    }


    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull(projectId, "项目id不能为空");
        return baseMapper.fetchSjzcje(projectId, null);
    }
}
