/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receive"})
public class ReceiveController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private ILoadReimburseService loadReimburseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = this.receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = this.receiveService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", (Object)this.receiveService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = this.receiveService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.receiveService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = this.receiveService.queryExportList(queryParam);
        HashMap<String, List<ReceiveVO>> beans = new HashMap<String, List<ReceiveVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("receive-export.xlsx", beans, response);
    }

    @GetMapping(value={"/countRecAndPay"})
    @ResponseBody
    public CommonResponse<JSONObject> countRecAndPay(@RequestParam(value="projectRange") Integer projectRange, @RequestParam(value="orgId", required=false) Long orgId) {
        JSONObject resp = new JSONObject();
        List<Object> orgIds = new ArrayList();
        orgIds = orgId != null ? ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()) : ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        ArrayList<Long> projectIds = new ArrayList<Long>();
        Map<String, Object> result = this.receiveService.countRecAmt(InvocationInfoProxy.getTenantid(), projectIds, false, orgIds);
        resp.put("rec", result.get("amt"));
        Map<String, Object> payContractResult = this.payContractService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> paySporadicResult = this.paySporadicService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> payReimburse = this.payReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        Map<String, Object> loadReimburseResult = this.loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds, orgIds);
        BigDecimal totalOut = new BigDecimal(0);
        totalOut = totalOut.add(new BigDecimal(payContractResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(paySporadicResult.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(payReimburse.get("amt").toString()));
        totalOut = totalOut.add(new BigDecimal(loadReimburseResult.get("amt").toString()));
        resp.put("out", (Object)totalOut.divide(new BigDecimal(10000), 2, 4));
        return CommonResponse.success((Object)resp);
    }
}

