/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/finance/"})
public class PayContractApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService contractService;

    @RequestMapping(value={"getSumPayMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=false) Long orgId) {
        try {
            SumPayMnyVO vo = this.contractService.getSumPayMny(contractId, orgId);
            return CommonResponse.success((Object)vo);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getSumPayMnyVOList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMnyVOList(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=false) Long orgId) {
        try {
            SumPayMnyVO vo = this.contractService.getSumPayMnyVOList(contractId, orgId);
            return CommonResponse.success((Object)vo);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getSubSettlePay"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, BigDecimal>> getSubSettlePay(@RequestBody PubContractSubQueryVO pubContractSubQueryVO) {
        Map<String, BigDecimal> map = this.contractService.getSubSettlePay(pubContractSubQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"getPayMnyByTenantIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, PayMnyWarnVO>> getPayMnyByTenantIds(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
        Map<String, PayMnyWarnVO> map = this.contractService.getPayMnyByTenantIds(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"warnPayMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, PayMnyWarnVO>> warnPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
        Map<String, PayMnyWarnVO> map = this.contractService.warnPayMny(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"warnMaterialPayMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
        Map<String, PayMnyWarnVO> map = this.contractService.warnMaterialPayMny(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }

    @RequestMapping(value={"warnMaterialPrePayMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPrePayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO) {
        Map<String, PayMnyWarnVO> map = this.contractService.warnMaterialPrePayMny(pubWarnQueryVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", map);
    }
}

