/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/receive/"})
public class ReceiveManageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;

    @GetMapping(value={"getSumReceiveVOList"})
    public CommonResponse<SumReceiveVO> getSumReceiveVOList(@RequestParam(value="contractId", required=true) Long contractId) {
        try {
            SumReceiveVO vo = this.receiveService.getSumReceiveVOList(contractId);
            return CommonResponse.success((Object)vo);
        }
        catch (Exception e) {
            this.logger.error("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
            return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @PostMapping(value={"countByProperties"})
    public CommonResponse<BigDecimal> countByProperties(@RequestBody Map<String, Object> param) {
        Map<String, Object> result = this.receiveService.countRecAmt(Long.valueOf(param.get("tenantId").toString()), null != param.get("projectIds") ? (List)param.get("projectIds") : null, true, null != param.get("orgIds") ? (List)param.get("orgIds") : null);
        return CommonResponse.success((Object)new BigDecimal(result.get("amt").toString()));
    }

    @PostMapping(value={"getAnnuallyCountData"})
    public CommonResponse<JSONObject> getAnnuallyCountData(@RequestBody Long orgId) {
        QueryParam queryParam = new QueryParam();
        Calendar calendar = Calendar.getInstance();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (orgId != null) {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        queryParam.getParams().put("confirmTime", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
        List receiveEntities = this.receiveService.queryList(queryParam, false);
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        List paySporadicEntities = this.paySporadicService.queryList(queryParam, false);
        List reimburseEntities = this.payReimburseService.queryList(queryParam, false);
        queryParam.getParams().remove("confirmTime");
        queryParam.getParams().remove("payStatus");
        queryParam.getParams().put("applyTime", new Parameter("between", (Object)(calendar.get(1) + "-01-01," + calendar.get(1) + "-12-31")));
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal totalReceive = new BigDecimal("0.00");
        BigDecimal totalOut = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)receiveEntities)) {
            for (BaseEntity entity : receiveEntities) {
                if (entity.getReceiveMny() == null) continue;
                totalReceive = totalReceive.add(entity.getReceiveMny());
            }
        }
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (BaseEntity entity : contractEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)paySporadicEntities)) {
            for (BaseEntity entity : paySporadicEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)reimburseEntities)) {
            for (BaseEntity entity : reimburseEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)loadReimburseEntities)) {
            for (BaseEntity entity : loadReimburseEntities) {
                if (entity.getReimburseMny() == null) continue;
                totalOut = totalOut.add(entity.getReimburseMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("totalReceive", (Object)totalReceive);
        back.put("totalOut", (Object)totalOut);
        return CommonResponse.success((Object)back);
    }

    @GetMapping(value={"getEachMonthCountData"})
    public CommonResponse<List<List<String>>> getEachMonthCountData(@RequestParam Integer type, @RequestParam(value="orgId", required=false) Long orgId) {
        CommonResponse response;
        List<Long> projectIds = new ArrayList<Long>();
        if (type != 1 && (response = this.projectApi.getProjectIdsByProperties(type.intValue())).isSuccess()) {
            if (ListUtil.isNotEmpty((List)((List)response.getData()))) {
                projectIds = (List)response.getData();
            } else {
                Map<String, JSONObject> last12Month = ReceiveManageApi.getLast12Month();
                ArrayList data = new ArrayList();
                for (Map.Entry<String, JSONObject> entry : last12Month.entrySet()) {
                    JSONObject v = entry.getValue();
                    ArrayList<String> item = new ArrayList<String>();
                    item.add(v.getString("name"));
                    item.add("0.00");
                    item.add("0.00");
                    data.add(item);
                }
                return CommonResponse.success(data);
            }
        }
        Map<String, JSONObject> last12Month = ReceiveManageApi.getLast12Month();
        ArrayList<Long> finalProjectIds = projectIds;
        ArrayList data = new ArrayList();
        for (Map.Entry<String, JSONObject> entry : last12Month.entrySet()) {
            String key = entry.getKey();
            JSONObject v = entry.getValue();
            List<BigDecimal> value = this.eachMonthData(key, finalProjectIds, orgId);
            v.put("value", value);
            ArrayList<String> item = new ArrayList<String>();
            item.add(v.getString("name"));
            item.add(value.get(0).toString());
            item.add(value.get(1).toString());
            data.add(item);
        }
        return CommonResponse.success(data);
    }

    private List<BigDecimal> eachMonthData(String mon, List<Long> projectIds, Long orgId) {
        ArrayList<BigDecimal> data = new ArrayList<BigDecimal>();
        QueryParam queryParam = new QueryParam();
        Calendar calendar = Calendar.getInstance();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        if (orgId != null) {
            queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            CommonResponse listCommonResponse = this.projectApi.queryChildrenProjectByOrgId(orgId);
            if (listCommonResponse.isSuccess()) {
                List list = (List)listCommonResponse.getData();
                List collect = list.stream().map(BaseVO::getId).collect(Collectors.toList());
                projectIds = projectIds.stream().filter(collect::contains).collect(Collectors.toList());
            }
        }
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        }
        queryParam.getParams().put("confirmTime", new Parameter("between", (Object)(mon + "-01-01," + mon + "-31")));
        List receiveEntities = this.receiveService.queryList(queryParam, false);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        List paySporadicEntities = this.paySporadicService.queryList(queryParam, false);
        List reimburseEntities = this.payReimburseService.queryList(queryParam, false);
        queryParam.getParams().remove("confirmTime");
        queryParam.getParams().remove("payStatus");
        queryParam.getParams().put("applyTime", new Parameter("between", (Object)(mon + "-01-01," + mon + "-31")));
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal totalReceive = new BigDecimal("0.00");
        BigDecimal totalOut = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)receiveEntities)) {
            for (BaseEntity entity : receiveEntities) {
                if (entity.getReceiveMny() == null) continue;
                totalReceive = totalReceive.add(entity.getReceiveMny());
            }
        }
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (BaseEntity entity : contractEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)paySporadicEntities)) {
            for (BaseEntity entity : paySporadicEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)reimburseEntities)) {
            for (BaseEntity entity : reimburseEntities) {
                if (entity.getPayMny() == null) continue;
                totalOut = totalOut.add(entity.getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)loadReimburseEntities)) {
            for (BaseEntity entity : loadReimburseEntities) {
                if (entity.getReimburseMny() == null) continue;
                totalOut = totalOut.add(entity.getReimburseMny());
            }
        }
        totalReceive = totalReceive.divide(new BigDecimal("10000")).setScale(2, 4);
        totalOut = totalOut.divide(new BigDecimal("10000")).setScale(2, 4);
        data.add(totalReceive);
        data.add(totalOut);
        return data;
    }

    private static Map<String, JSONObject> getLast12Month() {
        LinkedHashMap<String, JSONObject> mon = new LinkedHashMap();
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        for (int i = 0; i < 12; ++i) {
            JSONObject jsonObject = new JSONObject();
            String key = cal.get(1) + "-";
            String name = cal.get(1) + "\u5e74";
            key = cal.get(2) + 1 < 10 ? key + "0" + (cal.get(2) + 1) : key + (cal.get(2) + 1);
            name = cal.get(2) == 0 ? name + (cal.get(2) + 1) + "\u6708" : cal.get(2) + 1 + "\u6708";
            jsonObject.put("name", (Object)name);
            jsonObject.put("sec", (Object)(12 - i));
            System.out.println(key);
            System.out.println(jsonObject);
            mon.put(key, jsonObject);
            cal.set(2, cal.get(2) - 1);
        }
        mon = mon.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oleValue, newValue) -> oleValue, LinkedHashMap::new));
        return mon;
    }

    public static void main(String[] args) {
        Map<String, JSONObject> last12Month = ReceiveManageApi.getLast12Month();
        ArrayList item = new ArrayList();
        last12Month.forEach((key, v) -> {
            v.put("value", v);
            item.add(v.getString("name"));
            System.out.println(v);
        });
        item.forEach(System.out::println);
    }
}

